/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.data2.IProps;
import inferno.data2.Occupant;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.vis.AbstractTable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LocallyQuickestDoorsTable
extends AbstractTable {
    private String d_selectedAgentName;

    public LocallyQuickestDoorsTable(KB kb) {
        super(kb);
    }

    @Override
    public void initModel(String className) throws SecurityException, ClassNotFoundException {
        this.d_values = new Object[1][1];
        this.d_columnNames = new String[]{"0"};
    }

    @Override
    public void update(List<Object> data) {
        if (data != null) {
            Serializable ser3;
            IProps props = this.d_kb.getProps();
            OccAgent agent = (OccAgent)data.get(0);
            Occupant occ = agent.getOcc();
            List targetCosts = null;
            ILocalTarget best = null;
            Serializable ser0 = props.getDbgObj(occ, "LOCQUICKEST_TARGETCOSTS");
            if (ser0 != null) {
                targetCosts = (List)((Object)ser0);
            }
            if ((ser3 = props.getDbgObj(occ, "LOCQUICKEST_BEST")) != null) {
                best = (ILocalTarget)((Object)ser3);
            }
            this.d_selectedAgentName = occ.name;
            if (targetCosts != null) {
                this.updateDoorsTable(targetCosts, best, agent);
                this.d_table.repaint();
            }
        } else {
            this.d_values = new Object[1][1];
            this.d_columnNames = new String[]{"0"};
            this.d_tableModel.setColumnCount(1);
            this.d_selectedAgentName = "";
            this.d_table.repaint();
        }
    }

    private void updateDoorsTable(List<LocallyQuickest.TargetCostComparer> targetCosts, ILocalTarget best, OccAgent agent) {
        if (agent.isDone()) {
            return;
        }
        Collections.sort(targetCosts, new Comparator<LocallyQuickest.TargetCostComparer>(this){

            @Override
            public int compare(LocallyQuickest.TargetCostComparer o1, LocallyQuickest.TargetCostComparer o2) {
                return o1.target.toString().compareTo(o2.target.toString());
            }
        });
        this.d_values = new Object[targetCosts.size() + 1][1];
        for (int row = 0; row < targetCosts.size(); ++row) {
            this.d_table.setValueAt(targetCosts.get((int)row).target.toString(), row + 1, 0);
            for (int col = 0; col < targetCosts.size(); ++col) {
                if (this.d_tableModel.getColumnCount() <= col + 1) {
                    this.d_tableModel.addColumn((Object)col, new Object[targetCosts.size()]);
                }
                if (row == 0) {
                    this.d_tableModel.setValueAt(targetCosts.get((int)col).target.toString(), row, col + 1);
                }
                if (row != col) {
                    this.d_tableModel.setValueAt(targetCosts.get(row).compareTo(this.d_kb, agent, best, targetCosts.get(col)), row + 1, col + 1);
                }
                this.d_tableModel.fireTableDataChanged();
            }
        }
    }
}

