/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.theObservable;

public class DisplayFilter
extends theObservable {
    public static final Predicate<?> FILTER_ALL = Filters.rejectAll();
    private final Map<Class<?>, Predicate<?>> d_filters = new HashMap();

    protected void changed(Class<?> type) {
        this.setChanged();
        this.tryFireNotification(type);
    }

    public <T> void registerFilter(Class<T> clazz, Predicate<? extends T> filter) {
        assert (filter != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        Predicate<? extends T> oldFilter = this.d_filters.put(clazz, filter);
        if (!filter.equals(oldFilter)) {
            this.changed(clazz);
        }
    }

    public <T> void filterAllOfType(Class<T> type) {
        this.registerFilter(type, Filters.rejectAll(type));
    }

    public void removeFilter(Class<?> clazz) {
        Predicate<?> existing = this.d_filters.remove(clazz);
        if (existing != null) {
            this.changed(clazz);
        }
    }

    public boolean isFilteringAllOf(Class<?> type) {
        Predicate<?> filter = this.d_filters.get(type);
        if (filter == Filters.rejectAll()) {
            return true;
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && this.isFilteringAllOf(superClass)) {
            return true;
        }
        for (Class<?> iface : type.getInterfaces()) {
            if (!this.isFilteringAllOf(iface)) continue;
            return true;
        }
        return false;
    }

    public boolean filter(Object obj) {
        return this.filter(obj, obj.getClass());
    }

    private boolean filter(Object obj, Class<?> level) {
        Predicate<?> filter = this.d_filters.get(level);
        if (filter != null && !filter.test(obj)) {
            return true;
        }
        Class<?> superClass = level.getSuperclass();
        if (superClass != null && this.filter(obj, superClass)) {
            return true;
        }
        for (Class<?> iface : level.getInterfaces()) {
            if (!this.filter(obj, iface)) continue;
            return true;
        }
        return false;
    }
}

