/*
 * Decompiled with CFR 0.152.
 */
package inferno.util;

import inferno.sim.OccAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import thunderheadeng.geometry.RTree;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.ListSet;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class Util {
    public static <T> int binarySearch(List<T> a, T key, Comparator<? super T> c) {
        return Util.binarySearch(a, 0, a.size() - 1, key, c);
    }

    public static <T> int binarySearch(List<T> a, int beginIx, int endIx, T key, Comparator<? super T> c) {
        assert (beginIx >= 0 && endIx < a.size());
        int low = beginIx;
        int high = endIx;
        while (low <= high) {
            int mid = low + high >> 1;
            T midVal = a.get(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static double calcRTreeRebuildFactor(List<OccAgent> agents) {
        return Util.calcRTreeRebuildFactor(agents, 20, new RTree<OccAgent>());
    }

    public static double calcRTreeRebuildFactor(List<OccAgent> agents, int averagingCount, RTree<OccAgent> occFinder) {
        theTimer timer = new theTimer();
        double insertTime = 0.0;
        double updateTime = 0.0;
        ArrayList<OccAgent> updateAgents = new ArrayList<OccAgent>(agents);
        for (int m = 0; m < averagingCount; ++m) {
            occFinder.clear();
            timer.reset();
            for (OccAgent occ : agents) {
                occFinder.insert(occ.getOcc().getBoundingBox(false), occ);
            }
            insertTime += timer.curr();
            Collections.shuffle(updateAgents);
            timer.reset();
            for (OccAgent occ : updateAgents) {
                occFinder.remove(occ);
                occFinder.insert(occ.getOcc().getBoundingBox(false), occ);
            }
            updateTime += timer.curr();
        }
        double updatePerOcc = (updateTime /= (double)averagingCount) / (double)agents.size();
        double factor = (insertTime /= (double)averagingCount) / updatePerOcc / (double)agents.size();
        if (factor < 0.0) {
            factor = 0.0;
        } else if (factor > 1.0) {
            factor = 1.0;
        }
        return factor;
    }

    public static void profileRTreeRebuild(List<OccAgent> agents, double updateFactor) {
        Util.profileRTreeRebuild(agents, updateFactor, 20, new RTree<OccAgent>());
    }

    public static void profileRTreeRebuild(List<OccAgent> agents, double updateFactor, int count, RTree<OccAgent> occFinder) {
        theTimer timer = new theTimer();
        int updateCount = (int)(updateFactor * (double)agents.size());
        double insertTime = 0.0;
        double updateTime = 0.0;
        ArrayList<OccAgent> removeAgents = new ArrayList<OccAgent>(agents);
        for (int m = 0; m < count; ++m) {
            occFinder.clear();
            timer.reset();
            for (OccAgent occ : agents) {
                occFinder.insert(occ.getOcc().getBoundingBox(false), occ);
            }
            insertTime += timer.curr();
            Collections.shuffle(removeAgents);
            timer.reset();
            for (int n = 0; n < updateCount; ++n) {
                OccAgent occ;
                occ = (OccAgent)removeAgents.get(n);
                occFinder.remove(occ);
                occFinder.insert(occ.getOcc().getBoundingBox(false), occ);
            }
            updateTime += timer.curr();
        }
        double avgInsert = insertTime / (double)count;
        double avgUpdate = updateTime / (double)count;
        System.out.printf("avg insert all: %g%n", avgInsert);
        System.out.printf("avg update %d: %g%n", updateCount, avgUpdate);
    }

    private static <T> int[] createBins(List<T> items, Map<T, Double> valMap, double binFrac, double minBinSize) {
        if (items.size() <= 1) {
            return new int[]{1};
        }
        Collections.sort(items, new MapValueSorter<T>(valMap));
        double minTol = minBinSize;
        int binSize = 1;
        double currDist = valMap.get(items.get(0));
        ArrayList<Integer> binSizes = new ArrayList<Integer>();
        for (int m = 1; m < items.size(); ++m) {
            double tol;
            T door = items.get(m);
            double dist = valMap.get(door);
            if (theUtil.eq(currDist, dist, tol = Math.max(binFrac * currDist, minTol))) {
                valMap.put(door, currDist);
                ++binSize;
                continue;
            }
            currDist = dist;
            binSizes.add(binSize);
            binSize = 1;
        }
        binSizes.add(binSize);
        return theUtil.toIntArray(binSizes);
    }

    public static boolean isOrdered(Collection<?> c) {
        return c.isEmpty() || c.size() == 1 || c instanceof List || c instanceof LinkedHashSet || c instanceof LinkedIdentityHashSet || c instanceof Queue || c instanceof SortedSet || c instanceof ListSet;
    }

    public static boolean isOrdered(Map<?, ?> m) {
        return m.isEmpty() || m.size() == 1 || m instanceof LinkedHashMap || m instanceof LinkedIdentityHashMap || m instanceof SortedMap || m instanceof ListMap;
    }

    public static <T> Stream<T> reverseStream(List<T> items) {
        assert (items instanceof RandomAccess);
        int num = items.size() - 1;
        return IntStream.rangeClosed(0, num).mapToObj(i -> items.get(num - i));
    }

    public static class MapValueSorter<T>
    implements Comparator<T> {
        private Map<T, Double> d_values;

        public MapValueSorter(Map<T, Double> values) {
            this.d_values = values;
        }

        @Override
        public int compare(T e1, T e2) {
            return Double.compare(this.d_values.get(e1), this.d_values.get(e2));
        }
    }
}

