/*
 * Decompiled with CFR 0.152.
 */
package inferno.util;

import inferno.data2.IIdentifiable;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

public class IdSet<T extends IIdentifiable>
extends AbstractSet<T>
implements Serializable {
    static final long serialVersionUID = 1L;
    private final BitSet d_set;

    public IdSet() {
        this.d_set = new BitSet();
    }

    public IdSet(int sizeHint) {
        this.d_set = new BitSet(sizeHint);
    }

    public IdSet(Collection<? extends T> objs) {
        this(objs.size());
        this.addAll(objs);
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IIdentifiable) {
            return this.d_set.get(((IIdentifiable)o).getId());
        }
        return false;
    }

    @Override
    public boolean add(T e) {
        int id = e.getId();
        if (!this.d_set.get(id)) {
            this.d_set.set(id);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c instanceof IdSet) {
            IdSet as = (IdSet)c;
            this.d_set.or(as.d_set);
            return true;
        }
        return super.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof IdSet) {
            IdSet as = (IdSet)c;
            this.d_set.and(as.d_set);
            return true;
        }
        return super.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof IdSet) {
            IdSet as = (IdSet)c;
            this.d_set.andNot(as.d_set);
            return true;
        }
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IIdentifiable)) {
            return false;
        }
        IIdentifiable obj = (IIdentifiable)o;
        int id = obj.getId();
        boolean set = this.d_set.get(id);
        this.d_set.clear(id);
        return set;
    }

    @Override
    public boolean isEmpty() {
        return this.d_set.isEmpty();
    }

    @Override
    public void clear() {
        this.d_set.clear();
    }

    @Override
    public int size() {
        return this.d_set.cardinality();
    }
}

