/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.test.ITestSuite;
import inferno.test.NightlyTests;
import java.util.function.Function;
import java.util.function.Supplier;

public class TestPrefs {
    public static final Prop<String> SOURCE_DIR = new Prop<String>("PTH_TESTS_SOURCE_DIR", "");
    public static final Prop<Boolean> STORE = new Prop<Boolean>("PTH_TESTS_STORE", false);
    public static final Prop<String> STORE_LOCATION = new Prop<String>("PTH_TESTS_STORE_LOCATION", "test_results/");
    public static final Prop<Boolean> STORE_INCLUDE_VERSION = new Prop<Boolean>("PTH_TESTS_STORE_INCLUDE_VERSION", false);
    public static final Prop<Boolean> MAKE_VIS_FILES = new Prop<Boolean>("PTH_TESTS_MAKE_VIS_FILES", false);
    public static final Prop<Boolean> COPY_INPUT_FILE = new Prop<Boolean>("PTH_TESTS_COPY_INPUT_FILE", false);
    public static final Prop<ITestSuite> TESTSUITE = new Prop<ITestSuite>("PTH_TESTS_TESTSUITE", () -> new NightlyTests(), new ClassParser());

    private static <T> Function<String, T> getDefaultParser(T example) {
        assert (example != null);
        return TestPrefs.getDefaultParser(example.getClass());
    }

    private static <T> Function<String, T> getDefaultParser(Class<?> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return sval -> Boolean.parseBoolean(sval) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (String.class.isAssignableFrom(type)) {
            return sval -> sval;
        }
        return null;
    }

    public static class Prop<T> {
        public final String key;
        public final Supplier<? extends T> defVal;
        public final Function<String, ? extends T> parser;

        public Prop(String key, T defVal) {
            this(key, () -> defVal, TestPrefs.getDefaultParser(defVal));
        }

        public Prop(String key, T defVal, Function<String, ? extends T> parser) {
            this(key, () -> defVal, parser);
        }

        public Prop(String key, Supplier<? extends T> defSupplier, Function<String, ? extends T> parser) {
            this.key = key;
            this.defVal = defSupplier;
            this.parser = parser;
        }
    }

    private static class ClassParser<T>
    implements Function<String, T> {
        private ClassParser() {
        }

        @Override
        public T apply(String t) {
            try {
                Class<?> clazz = Class.forName(t);
                return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

