/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Occupant;
import inferno.data2.SpeedModifier;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ElevatorModel;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.Estimate;
import inferno.sim.path.IPath;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.locallyquickest.IGlobalTarget;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalDoorCosts;
import inferno.sim.steering.locallyquickest.LocalDoorTarget;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.commons.lang3.builder.ToStringBuilder;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class LocallyQuickest
implements IPathPlanner,
Serializable {
    static final long serialVersionUID = 1L;
    private final IGlobalTarget d_globalTarget;
    private int d_globalTargetChanges = 0;
    private Map<ILocalTarget, TargetInfo> d_localTargetInfo;
    private List<ILocalTarget> d_validLocalTargets;
    private double d_tLastMeshChange;
    private LocalTimeEstimate d_estimator;
    private ILocalTarget d_prevBestLocalTarget;
    private LQuickPath d_prevBestLocalTargetPath;
    private double d_tBestLocalTargetFirstChosen;
    private double d_tBestLocalTargetEvaluated;
    private int d_numEvals;
    private double d_distTravelledLastReset;
    private double d_prevDistTravelled;
    private Predicate<WingedEdge> d_transientEdgeFilter;
    protected ANode d_room;
    private Backtrack d_backtrack;

    public LocallyQuickest(OccAgent agent, LocalTimeEstimate estimator, IGlobalTarget target) {
        this.d_estimator = estimator;
        this.d_globalTarget = target;
        this.d_room = null;
        this.invalidate(agent, true);
        this.d_tLastMeshChange = 0.0;
        this.d_transientEdgeFilter = LocallyQuickest.getTransientEdgeFilter(null, Collections.EMPTY_SET, true);
        this.d_backtrack = new Backtrack();
    }

    private static Predicate<WingedEdge> getTransientEdgeFilter(ANode currRoom, Set<ANode> acceptDoors, boolean filterOnewayDoors) {
        Predicate<WingedEdge> potDangerousEdgeFilter = Predicates.or(EdgeFilters.filterDoors(Filters.accept(acceptDoors)), EdgeFilters.acceptRoomEdges(currRoom).negate());
        return EdgeFilters.filterDangerous(potDangerousEdgeFilter, filterOnewayDoors);
    }

    public void checkCache(KB kb, OccAgent agent) {
        if (kb.getMesh().dtModified() > this.d_tLastMeshChange) {
            this.d_localTargetInfo = null;
            this.d_validLocalTargets = null;
            this.d_prevDistTravelled = agent.getOcc().totalDistanceMeters;
            this.d_globalTarget.invalidate();
            this.d_tLastMeshChange = kb.getMesh().dtModified();
        }
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
        ANode destNode;
        if (this.d_room == null) {
            return;
        }
        assert (queue.getR1() == this.d_room || queue.getR2() == this.d_room);
        ANode aNode = destNode = queue.getR1() == this.d_room ? queue.getR2() : queue.getR1();
        if (this.d_room != destNode) {
            Point3d crossLoc = queue.getNode().getNearestLocOnDoor(agent.getPos());
            assert (crossLoc != null);
            if (crossLoc == null) {
                crossLoc = agent.getPos();
            }
            this.d_backtrack.update(this, queue, crossLoc, destNode);
            this.d_room = destNode;
            this.invalidate(agent, true);
        }
    }

    public void invalidate(OccAgent agent, boolean recalcTargets) {
        this.d_prevBestLocalTarget = null;
        this.d_tBestLocalTargetFirstChosen = Double.POSITIVE_INFINITY;
        this.d_tBestLocalTargetEvaluated = Double.NEGATIVE_INFINITY;
        this.d_distTravelledLastReset = agent.getOcc().totalDistanceMeters;
        this.d_numEvals = 0;
        this.d_estimator.clearAllMemory();
        if (recalcTargets) {
            this.d_localTargetInfo = null;
            this.d_validLocalTargets = null;
            this.d_globalTargetChanges = 0;
        }
    }

    @Override
    public Predicate<WingedEdge> getTransientEdgeFilter(KB kb, OccAgent agent) {
        return this.d_transientEdgeFilter;
    }

    private Predicate<PathChange> getPathPlanningFilter(KB kb, OccAgent agent) {
        Predicate<ANode> nodeFilter = this.d_room != null ? Filters.accept(this.d_room) : Filters.acceptAll(ANode.class);
        Predicate<Tri> triFilter = TriFilters.rejectClosed(nodeFilter);
        return agent.generatePathFilter(kb, triFilter, EdgeFilters.acceptAll(), OccAgent.PathFilterType.LOCAL);
    }

    private boolean isCurrTarget(ILocalTarget target) {
        return target.equals(this.d_prevBestLocalTarget);
    }

    private void evalLocalPath(KB kb, OccAgent agent, ILocalTarget localTarget, TargetEval eval, boolean updateCurrTargetPath, Map<ILocalTarget, LQuickPath> paths) {
        if (paths.containsKey(localTarget)) {
            return;
        }
        boolean isCurrTarget = this.isCurrTarget(localTarget);
        LQuickPath path = isCurrTarget && !updateCurrTargetPath && this.d_prevBestLocalTargetPath != null ? this.d_prevBestLocalTargetPath : this.getLocalPath(kb, agent, localTarget);
        paths.put(localTarget, path);
        if (path == null) {
            eval.setPathLength(Double.POSITIVE_INFINITY, TargetEval.infiniteTailDist());
        } else {
            eval.setPathLength(path.getLocalLength(), path.tailDist != null ? path.tailDist : TargetEval.irrelevantTailDist());
        }
    }

    private LQuickPath getLocalPath(KB kb, OccAgent agent, ILocalTarget localTarget) {
        TargetInfo ti = this.d_localTargetInfo.get(localTarget);
        LQuickPath path = localTarget.getLocalPath(kb, agent, this.getPathPlanningFilter(kb, agent), ti.target, ti.tailInfo);
        return path;
    }

    private List<ILocalTarget> getValidLocalTargets(Collection<ILocalTarget> potentialTargets, double tailLengthFilter, Predicate<Pair<TargetInfo, Estimate.PointToGoalDist>> targetFilter, KB kb, OccAgent agent, Map<ILocalTarget, LQuickPath> reachableTargets) {
        ArrayList<ILocalTarget> validTargets = new ArrayList<ILocalTarget>();
        for (ILocalTarget target : potentialTargets) {
            TargetInfo ti = this.d_localTargetInfo.get(target);
            double bestExitDist = ti.tailInfo.minDist.dist;
            if (tailLengthFilter <= bestExitDist) continue;
            Estimate.DoorToGoalValue tailInfo = ti.tailInfo;
            ArrayList<Estimate.PointToGoalDist> allowedDists = new ArrayList<Estimate.PointToGoalDist>(tailInfo.dists.size());
            for (Estimate.PointToGoalDist tdist : tailInfo.dists) {
                if (!targetFilter.test(new Pair<TargetInfo, Estimate.PointToGoalDist>(ti, tdist))) continue;
                allowedDists.add(tdist);
            }
            if (allowedDists.isEmpty()) continue;
            if (allowedDists.size() != tailInfo.dists.size()) {
                tailInfo = new Estimate.DoorToGoalValue(tailInfo.door1, tailInfo.goal, true, allowedDists);
                ti = new TargetInfo(ti.ltarget, ti.target, tailInfo);
                this.d_localTargetInfo.put(target, ti);
            }
            if (!reachableTargets.containsKey(target)) {
                LQuickPath path = this.getLocalPath(kb, agent, target);
                reachableTargets.put(target, path);
            }
            if (reachableTargets.get(target) == null) continue;
            validTargets.add(target);
        }
        return validTargets;
    }

    @Override
    public boolean update(KB kb, OccAgent agent, boolean forceNewPath) {
        int globalTargetChanges = this.d_globalTarget.isStatic(kb) ? 0 : this.d_globalTarget.update(kb, agent);
        this.d_globalTargetChanges |= globalTargetChanges;
        if (theUtil.testAny(globalTargetChanges, 1)) {
            this.invalidate(agent, true);
        }
        if (this.d_prevBestLocalTarget == null || forceNewPath) {
            return true;
        }
        double minRepathDT = kb.getParams().min_repath_dt;
        double evalDT = this.d_numEvals == 1 ? agent.d_realTimeModifier * minRepathDT : minRepathDT;
        double tNextEval = this.d_tBestLocalTargetEvaluated + evalDT;
        return theUtil.ge(kb.getCurrentSimTime(), tNextEval, 1.0E-6);
    }

    private void getTargetsInRoom(KB kb, OccAgent agent, ANode room, Set<ILocalTarget> targets) {
        for (ANode door : room.getDoors()) {
            if (door.isInternalDoor()) continue;
            targets.add(new LocalDoorTarget(door));
        }
        Collection<? extends ILocalTarget> ltargets = this.d_globalTarget.getLocalTargets(kb, agent, room);
        targets.addAll(ltargets);
        for (ElevatorLevel level : kb.getElevatorModel().getTransportLevels(room.getElevatorLevel())) {
            for (ANode dischargeDoor : level.pickupNode.getDoorsOutOfRoom()) {
                targets.add(new LocalDoorTarget(dischargeDoor, true));
            }
        }
    }

    @Override
    public IPath getPath(KB kb, OccAgent agent, boolean forceNewPath) {
        IdentityHashSet<ANode> pathDoors;
        Occupant occ = agent.getOcc();
        int globalTargetChanges = this.d_globalTargetChanges;
        this.d_globalTargetChanges = 0;
        double t = kb.getCurrentSimTime();
        ++this.d_numEvals;
        this.d_tBestLocalTargetEvaluated = t;
        this.checkCache(kb, agent);
        if (this.d_room == null) {
            this.d_room = occ.curNode;
        } else if (occ.curNode != this.d_room) {
            System.err.printf("[0x9823ba] Occupant, %s, trying to get locally quickest path in wrong room.  Expected room %s, got room %s%nClearing backtrack prevention.%n", agent.getOcc().name, this.d_room, occ.curNode);
            this.d_room = occ.curNode;
            this.invalidate(agent, true);
        }
        assert (this.d_room != null);
        if (this.d_room == null) {
            System.err.printf("[0x8b0xfe] Occupant %s has null room%n", occ.name);
            return null;
        }
        boolean gtargetMoved = theUtil.testAny(globalTargetChanges, 2);
        if (gtargetMoved) {
            this.d_localTargetInfo = null;
            this.d_prevBestLocalTargetPath = null;
            this.d_validLocalTargets = null;
        }
        LinkedHashSet<ILocalTarget> targets = Collections.EMPTY_SET;
        if (this.d_localTargetInfo == null || this.d_validLocalTargets == null) {
            targets = new LinkedHashSet<ILocalTarget>();
            this.getTargetsInRoom(kb, agent, this.d_room, targets);
        }
        if (this.d_localTargetInfo == null) {
            assert (this.d_globalTarget != null);
            this.d_localTargetInfo = this.getLocalTargetEstimates(kb, agent, targets, this.d_globalTarget, occ.curNode, false);
        }
        if (this.d_validLocalTargets == null) {
            Iterator<Map.Entry<ILocalTarget, TargetInfo>> backtrackFilter;
            HashMap<ILocalTarget, LQuickPath> validLocalTargetPaths = new HashMap<ILocalTarget, LQuickPath>();
            List<ILocalTarget> validLocalTargets = Collections.EMPTY_LIST;
            while ((validLocalTargets = this.getValidLocalTargets((Collection<ILocalTarget>)targets, Double.POSITIVE_INFINITY, (Predicate<Pair<TargetInfo, Estimate.PointToGoalDist>>)((Object)(backtrackFilter = this.d_backtrack.getFilter(this.d_room))), kb, agent, (Map<ILocalTarget, LQuickPath>)validLocalTargetPaths)).isEmpty() && !Predicates.alwaysTrue(backtrackFilter)) {
                this.clearBacktrack(false);
            }
            this.d_validLocalTargets = validLocalTargets;
            this.d_localTargetInfo.keySet().retainAll(validLocalTargets);
            if (this.d_prevBestLocalTarget != null) {
                if (!this.d_validLocalTargets.contains(this.d_prevBestLocalTarget)) {
                    this.invalidate(agent, false);
                } else {
                    this.d_prevBestLocalTargetPath = (LQuickPath)validLocalTargetPaths.get(this.d_prevBestLocalTarget);
                }
            }
            for (Map.Entry<ILocalTarget, TargetInfo> entry : this.d_localTargetInfo.entrySet()) {
                ILocalTarget target = entry.getKey();
                TargetInfo info = entry.getValue();
                Map<Estimate.PointToGoalDist, Collection<ILocalTarget>> localTailTargets = this.getLocalTargetsOnTails(target, info, this.d_validLocalTargets);
                localTailTargets.entrySet().forEach(lttEntry -> info.addLocalTailTargets((Estimate.PointToGoalDist)lttEntry.getKey(), (Collection)lttEntry.getValue()));
            }
            this.updateTailDataForLocalElevatorDoors(this.d_localTargetInfo, kb.getElevatorModel());
            this.initEvals(this.d_validLocalTargets, validLocalTargetPaths, this.d_localTargetInfo);
            this.d_prevDistTravelled = agent.getOcc().totalDistanceMeters;
        }
        LQuickPath result = null;
        if (!this.d_validLocalTargets.isEmpty()) {
            BestTarget bestDoorAndPath = this.getBestTarget(kb, agent, forceNewPath);
            if (bestDoorAndPath != null) {
                if (!this.isCurrTarget(bestDoorAndPath.target)) {
                    this.d_prevBestLocalTarget = bestDoorAndPath.target;
                    this.d_tBestLocalTargetFirstChosen = kb.getCurrentSimTime();
                }
                for (Map.Entry<ILocalTarget, TargetInfo> entry : this.d_localTargetInfo.entrySet()) {
                    TargetEval eval = bestDoorAndPath.targetEvals.get(entry.getKey());
                    if (eval == null) continue;
                    ((TargetInfo)entry.getValue()).eval = eval;
                }
                this.d_prevBestLocalTargetPath = result = bestDoorAndPath.path;
            } else if (this.d_prevBestLocalTarget != null) {
                this.invalidate(agent, true);
            }
        }
        IPath resultPath = null;
        if (result == null) {
            pathDoors = Collections.EMPTY_SET;
        } else {
            resultPath = result.path;
            pathDoors = new IdentityHashSet<ANode>();
            for (TriEdge te : result.edges) {
                if (!te.edge.isDoor()) continue;
                pathDoors.add(te.edge.getDoorNode());
            }
        }
        this.d_transientEdgeFilter = LocallyQuickest.getTransientEdgeFilter(this.d_room, pathDoors, agent.getOcc().obeyOnewayDoors);
        this.d_prevDistTravelled = agent.getOcc().totalDistanceMeters;
        if (agent.isSelected()) {
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_TARGETINFO", (Serializable)((Object)this.d_localTargetInfo));
        }
        return resultPath;
    }

    @Override
    public IPathPlanner.IStatus getStatus(KB kb, OccAgent agent) {
        return null;
    }

    private double getLocalDelayEstimate(KB kb, OccAgent agent, ILocalTarget target, double localDist, DoubleSupplier getTransportFinishedDelay) {
        double tTargetChosen = this.isCurrTarget(target) ? this.d_tBestLocalTargetFirstChosen : Double.POSITIVE_INFINITY;
        return target.getLocalDelayEstimate(kb, agent, this.d_estimator, tTargetChosen, localDist, this.d_localTargetInfo.get((Object)target).tailInfo, getTransportFinishedDelay);
    }

    private double getLocalTravelTimeEstimate(KB kb, OccAgent agent, ILocalTarget target, double localDist) {
        return target.getLocalTravelTimeEstimate(kb, agent, this.d_estimator, localDist);
    }

    private DoorDir getLocalDoorDirection(LocalDoorTarget target) {
        ANode localDoor = target.door;
        Estimate.DoorToGoalValue val = this.d_localTargetInfo.get((Object)target).tailInfo;
        DoorDir dir = val.getDir(localDoor);
        assert (dir != null);
        return dir;
    }

    private LocalTimeEstimateVal getLocalTimeEstimate(KB kb, OccAgent agent, ILocalTarget localTarget, TargetEval eval, Predicate<ILocalTarget> queueEvalFilter, Map<ILocalTarget, LocalTimeEstimateVal> localTimeEstKnownDistMap, DoubleSupplier getTransportFinishedDelay) {
        double queueTime;
        LocalTimeEstimateVal timeEst = localTimeEstKnownDistMap.get(localTarget);
        if (timeEst != null) {
            return timeEst;
        }
        double localDist = eval.pathLenEst;
        if (Double.isInfinite(localDist)) {
            timeEst = new LocalTimeEstimateVal(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            localTimeEstKnownDistMap.put(localTarget, timeEst);
            return timeEst;
        }
        if (queueEvalFilter.test(localTarget)) {
            queueTime = this.getLocalDelayEstimate(kb, agent, localTarget, localDist, getTransportFinishedDelay);
            eval.tLastEvaluated = kb.getCurrentSimTime();
            eval.queueTimeLastKnown = queueTime;
        } else {
            queueTime = eval.queueTimeLastKnown;
        }
        double travelTime = this.getLocalTravelTimeEstimate(kb, agent, localTarget, localDist);
        LocalTimeEstimateVal localTimeEst = new LocalTimeEstimateVal(queueTime, travelTime);
        localTimeEstKnownDistMap.put(localTarget, localTimeEst);
        return localTimeEst;
    }

    /*
     * WARNING - void declaration
     */
    private ILocalTarget getLowestCostTarget(KB kb, OccAgent agent, Collection<? extends ILocalTarget> targets, Map<ILocalTarget, TargetEval> targetEvals, Map<ILocalTarget, LocalTimeEstimateVal> localTimeEstKnownDistMap, List<ILocalTarget> betterThanPrev) {
        void var12_13;
        TargetCostComparer prevDoorCost = null;
        ArrayList<TargetCostComparer> targetCosts = new ArrayList<TargetCostComparer>();
        double distTravelledInRoom = agent.getOcc().totalDistanceMeters - this.d_distTravelledLastReset;
        for (ILocalTarget iLocalTarget : targets) {
            ANode adjNode;
            TargetEval teval = targetEvals.get(iLocalTarget);
            double localDist = teval.pathLenEst;
            if (localDist < agent.getGeometryRadius()) {
                localDist = 0.0;
            }
            LocalTimeEstimateVal localTimeEst = localTimeEstKnownDistMap.get(iLocalTarget);
            if (this.isCurrTarget(iLocalTarget)) {
                double stopTime = OccAgent.calcStopTime(agent.getVel().length(), agent.getMaxStopAccel(kb));
                localTimeEst = new LocalTimeEstimateVal((Double)localTimeEst.getLocalTimeEstimate().v1, Math.max(0.0, (Double)localTimeEst.getLocalTimeEstimate().v2 - stopTime));
            }
            ANode curNode = agent.getOcc().curNode;
            if (iLocalTarget instanceof LocalDoorTarget && ((LocalDoorTarget)iLocalTarget).door.isElevatorDoor() && curNode.getElevatorLevel() == null && (adjNode = ((LocalDoorTarget)iLocalTarget).door.doorQueue.getAdjNode(curNode)) != null && adjNode.getElevatorLevel() != null && agent.getOcc().elevatorWaitTime.canWait()) {
                double travelToElevatorTime = this.d_estimator.getTravelTime(kb, agent, localDist);
                localTimeEst = new LocalTimeEstimateVal(0.0, Math.max(0.0, travelToElevatorTime), Collections.singletonMap(AdditionalTimeEstType.TRANSPORT_DOOR, new Pair<Double, Double>(0.0, (Double)localTimeEst.getLocalTimeEstimate().v2)));
            }
            int priority = 0;
            boolean IS_PREV_BEST = true;
            int IS_DIRECT = 2;
            int IS_TARGET = 4;
            if (this.isCurrTarget(iLocalTarget)) {
                priority |= 1;
            }
            if (this.d_localTargetInfo.get(iLocalTarget).getLocalTailTargets(teval.tailDist).isEmpty()) {
                priority |= 2;
            }
            if (this.isGlobalTarget(iLocalTarget)) {
                priority |= 4;
            }
            TargetCostComparer dc = new TargetCostComparer(kb, agent, iLocalTarget, priority, distTravelledInRoom, localDist, localTimeEst, teval);
            targetCosts.add(dc);
            if (prevDoorCost == null && iLocalTarget.equals(this.d_prevBestLocalTarget)) {
                prevDoorCost = dc;
            }
            if (!KB.DEBUG_PATHS || !agent.isSelected()) continue;
            System.out.printf("%s's location through %s:%n", agent.getOcc().name, iLocalTarget != null ? iLocalTarget.toString() : null);
        }
        Collections.sort(targetCosts, new Comparator<TargetCostComparer>(this){

            @Override
            public int compare(TargetCostComparer o1, TargetCostComparer o2) {
                return Double.compare(o1.targetEval.getTailDist(), o2.targetEval.getTailDist());
            }
        });
        if (agent.isSelected()) {
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_TARGETCOSTS", targetCosts);
        }
        TargetCostComparer bestTarget = (TargetCostComparer)targetCosts.get(targetCosts.size() - 1);
        int n = targetCosts.size() - 2;
        while (var12_13 >= 0) {
            TargetCostComparer dc = (TargetCostComparer)targetCosts.get((int)var12_13);
            if (dc.compareTo(kb, agent, this.d_prevBestLocalTarget, bestTarget) < 0) {
                bestTarget = dc;
            }
            --var12_13;
        }
        if (betterThanPrev != null && this.d_prevBestLocalTarget != null && !bestTarget.target.equals(this.d_prevBestLocalTarget)) {
            assert (prevDoorCost != null);
            for (TargetCostComparer dc : targetCosts) {
                if (dc == prevDoorCost || dc.compareTo(kb, agent, this.d_prevBestLocalTarget, prevDoorCost) >= 0) continue;
                betterThanPrev.add(dc.target);
            }
            assert (!betterThanPrev.isEmpty());
        }
        return bestTarget.target;
    }

    private double getNextQueueEvalTime(KB kb, OccAgent agent, ILocalTarget localDoor, Vector3d prevBestDoorDir, double tLastEvaluated) {
        if (prevBestDoorDir == null || localDoor.equals(this.d_prevBestLocalTarget)) {
            return kb.getCurrentSimTime();
        }
        Vector3d naiveTargetVec = localDoor.getNaiveDistanceVec(kb, agent, this.d_room);
        Util.safeNormalize(naiveTargetVec, 1.0E-9);
        if (prevBestDoorDir.dot(naiveTargetVec) >= 0.0) {
            return kb.getCurrentSimTime();
        }
        double minRepathDT = kb.getParams().min_repath_dt;
        double maxRepathDT = kb.getParams().max_repath_dt;
        double avgTime = kb.getParams().local_speed_avg_time;
        double speed = agent.getAverageSpeedAlongPath(kb, avgTime);
        double speedFrac = speed / (double)agent.getOcc().maxVel;
        double evalDT = theUtil.lerp(minRepathDT, maxRepathDT, speedFrac);
        return tLastEvaluated + evalDT;
    }

    private Vector3d getNaiveDir(KB kb, OccAgent agent, ILocalTarget target) {
        Vector3d vec = target.getNaiveDistanceVec(kb, agent, this.d_room);
        Util.safeNormalize(vec, 1.0E-9);
        return vec;
    }

    private List<ILocalTarget> getInitialTestTargets(KB kb, OccAgent agent, boolean updateCurrDoorPath, double distTravelled, Map<ILocalTarget, TargetEval> targetEvals, Map<ILocalTarget, LQuickPath> paths) {
        for (ILocalTarget target : this.d_validLocalTargets) {
            TargetInfo ti = this.d_localTargetInfo.get(target);
            TargetEval eval = ti.eval.clone();
            targetEvals.put(target, eval);
            Vector3d naiveTargetVec = target.getNaiveDistanceVec(kb, agent, this.d_room);
            double naiveTargetDist = Util.safeNormalize(naiveTargetVec, 1.0E-9);
            eval.updatePathLenEst(naiveTargetDist, distTravelled);
        }
        return this.getTestTargets(kb, agent, this.d_validLocalTargets, updateCurrDoorPath, false, targetEvals, paths);
    }

    private List<ILocalTarget> getTestTargets(KB kb, OccAgent agent, Collection<? extends ILocalTarget> targets, boolean updateCurrDoorPath, boolean precisePathLens, Map<ILocalTarget, TargetEval> targetEvals, Map<ILocalTarget, LQuickPath> paths) {
        ArrayDeque<? extends ILocalTarget> targetStack = new ArrayDeque<ILocalTarget>(targets);
        HashSet<? extends ILocalTarget> closedTargets = new HashSet<ILocalTarget>(targetStack);
        ArrayList<ILocalTarget> testTargets = new ArrayList<ILocalTarget>();
        while (!targetStack.isEmpty()) {
            ILocalTarget target = (ILocalTarget)targetStack.removeFirst();
            TargetEval eval = targetEvals.get(target);
            if (target.equals(this.d_prevBestLocalTarget) || precisePathLens && !eval.isLenEstExact()) {
                this.evalLocalPath(kb, agent, target, eval, updateCurrDoorPath, paths);
            }
            if (!eval.hasPath()) continue;
            testTargets.add(target);
            TargetInfo ti = this.d_localTargetInfo.get(target);
            for (ILocalTarget tailTarget : ti.getLocalTailTargets(eval.tailDist)) {
                if (!closedTargets.add(tailTarget)) continue;
                targetStack.addLast(tailTarget);
            }
        }
        return testTargets;
    }

    private double calcTransportFinishedDelay(KB kb, OccAgent agent) {
        if (!agent.getOcc().curNode.isTransportNode()) {
            return 0.0;
        }
        Elevator elev = agent.getOcc().curNode.getElevatorLevel().getElevator();
        if (!elev.isOpen()) {
            return 0.0;
        }
        double maxDischargeTime = 0.0;
        ElevatorLevel dischargeLevel = elev.getCurrentLevel();
        for (ANode door : dischargeLevel.pickupNode.getDoors()) {
            DoorDir exitDir;
            double dischargeTime = this.d_estimator.getEmptyTime(kb, door, exitDir = door.doorQueue.getDir(dischargeLevel.pickupNode).opposite());
            if (!(dischargeTime > maxDischargeTime)) continue;
            maxDischargeTime = dischargeTime;
        }
        return maxDischargeTime;
    }

    private BestTarget getBestTarget(KB kb, OccAgent agent, boolean updateCurrTargetPath) {
        HashMap<ILocalTarget, LQuickPath> paths;
        HashMap<ILocalTarget, TargetEval> targetEvals;
        double distTravelled = agent.getOcc().totalDistanceMeters - this.d_prevDistTravelled;
        boolean newLoc = distTravelled > 0.001;
        List<ILocalTarget> testTargets = this.getInitialTestTargets(kb, agent, updateCurrTargetPath |= newLoc, distTravelled, targetEvals = new HashMap<ILocalTarget, TargetEval>(), paths = new HashMap<ILocalTarget, LQuickPath>());
        if (testTargets.isEmpty() || this.d_prevBestLocalTarget != null && paths.get(this.d_prevBestLocalTarget) == null) {
            return null;
        }
        Vector3d prevBestDoorDir = this.d_prevBestLocalTarget != null ? this.getNaiveDir(kb, agent, this.d_prevBestLocalTarget) : null;
        IdentityHashSet queueUpdateTargets = new IdentityHashSet();
        for (ILocalTarget localTarget : testTargets) {
            double tNextEval = this.getNextQueueEvalTime(kb, agent, localTarget, prevBestDoorDir, ((TargetEval)targetEvals.get((Object)localTarget)).tLastEvaluated);
            if (!theUtil.ge(kb.getCurrentSimTime(), tNextEval, 1.0E-6)) continue;
            queueUpdateTargets.add(localTarget);
        }
        Predicate<ILocalTarget> queueUpdateFilter = Filters.accept(queueUpdateTargets);
        CachedValue cachedTransportFinishDelay = new CachedValue();
        DoubleSupplier getTransportFinishedDelay = () -> cachedTransportFinishDelay.unsafeGet(() -> this.calcTransportFinishedDelay(kb, agent));
        ArrayList<ILocalTarget> betterThanPrev = new ArrayList<ILocalTarget>();
        ILocalTarget best = this.getBestTarget(kb, agent, testTargets, true, targetEvals, queueUpdateFilter, betterThanPrev, getTransportFinishedDelay);
        if (!(this.d_prevBestLocalTarget == null || best != null && this.isCurrTarget(best))) {
            assert (!betterThanPrev.isEmpty());
            betterThanPrev.add(this.d_prevBestLocalTarget);
            testTargets = this.getTestTargets(kb, agent, betterThanPrev, updateCurrTargetPath, true, targetEvals, paths);
            assert (!testTargets.isEmpty());
            queueUpdateFilter = Predicates.alwaysTrue();
            best = this.getBestTarget(kb, agent, testTargets, false, targetEvals, queueUpdateFilter, null, getTransportFinishedDelay);
        }
        if (best == null) {
            return null;
        }
        this.evalLocalPath(kb, agent, best, (TargetEval)targetEvals.get(best), updateCurrTargetPath, paths);
        assert (paths.containsKey(best));
        LQuickPath path = (LQuickPath)paths.get(best);
        if (path == null) {
            return null;
        }
        if (agent.isSelected()) {
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_BEST", (Serializable)((Object)best));
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_TARGETEVALS", targetEvals);
        }
        return new BestTarget(best, path, targetEvals);
    }

    private ILocalTarget getBestTarget(KB kb, OccAgent agent, Collection<? extends ILocalTarget> targets, boolean isAllTargets, Map<ILocalTarget, TargetEval> targetEvals, Predicate<ILocalTarget> queueEvalFilter, List<ILocalTarget> betterThanPrev, DoubleSupplier getTransportFinishedDelay) {
        assert (!targets.isEmpty());
        if (targets.size() == 1) {
            ILocalTarget onlyTarget = targets.iterator().next();
            return onlyTarget;
        }
        int noFlowCount = 0;
        HashMap<ILocalTarget, LocalTimeEstimateVal> localTimeEstMap = new HashMap<ILocalTarget, LocalTimeEstimateVal>();
        for (ILocalTarget iLocalTarget : targets) {
            LocalTimeEstimateVal est = this.getLocalTimeEstimate(kb, agent, iLocalTarget, targetEvals.get(iLocalTarget), queueEvalFilter, localTimeEstMap, getTransportFinishedDelay);
            if (!Double.isInfinite((Double)est.getLocalTimeEstimate().v1)) continue;
            ++noFlowCount;
        }
        if (isAllTargets) {
            if (noFlowCount == targets.size()) {
                this.d_estimator.clearAllMemory();
            }
            this.d_estimator.updateEstimates(kb, targets);
        }
        for (ILocalTarget iLocalTarget : targets) {
            TargetInfo ti = this.d_localTargetInfo.get(iLocalTarget);
            TargetEval eval = targetEvals.get(iLocalTarget);
            Collection<ILocalTarget> tailTargets = ti.getLocalTailTargets(eval.tailDist);
            if (tailTargets.isEmpty()) continue;
            LocalTimeEstimateVal tLocal = (LocalTimeEstimateVal)localTimeEstMap.get(iLocalTarget);
            for (ILocalTarget tailTarget : tailTargets) {
                LocalTimeEstimateVal tTailTarget = this.getLocalTimeEstimate(kb, agent, tailTarget, targetEvals.get(tailTarget), queueEvalFilter, localTimeEstMap, getTransportFinishedDelay);
                tLocal.setQueueTime((Double)tLocal.getLocalTimeEstimate().v1 + (Double)tTailTarget.getLocalTimeEstimate().v1);
            }
        }
        ILocalTarget bestTarget = this.getLowestCostTarget(kb, agent, targets, targetEvals, localTimeEstMap, betterThanPrev);
        if (KB.DEBUG_PATHS && agent.isSelected()) {
            System.out.printf("**** Selected Door: %s ****%n", bestTarget.toString());
        }
        return bestTarget;
    }

    private Map<ILocalTarget, TargetInfo> getLocalTargetEstimates(KB kb, OccAgent agent, Collection<ILocalTarget> localTargets, IGlobalTarget globalTarget, ANode currentNode, boolean printOutput) {
        LinkedHashMap<ILocalTarget, TargetInfo> doorToGoalDist = new LinkedHashMap<ILocalTarget, TargetInfo>();
        ArrayList<LTargetFuture> dtdBatches = new ArrayList<LTargetFuture>(localTargets.size());
        for (ILocalTarget localTarget : localTargets) {
            if (this.d_globalTarget.isLocalTarget(localTarget)) {
                Estimate.DoorToGoalValue bestVal;
                if (localTarget instanceof LocalDoorTarget) {
                    LocalDoorTarget ldt = (LocalDoorTarget)localTarget;
                    bestVal = Estimate.DoorToGoalValue.zeroPath(ldt.door, PathGen.newDoorGoal(ldt.door), currentNode);
                } else {
                    bestVal = new Estimate.DoorToGoalValue(null, null, true, Collections.singletonList(new Estimate.PointToGoalDist(null, 0.5, 0.0, 0.0, null, null, new TriPoint[0], Collections.emptyList())));
                }
                TargetInfo dm = new TargetInfo(localTarget, this.d_globalTarget, bestVal);
                doorToGoalDist.put(localTarget, dm);
                continue;
            }
            assert (localTarget instanceof LocalDoorTarget);
            LocalDoorTarget doorTarget = (LocalDoorTarget)localTarget;
            ANode localSrcNode = currentNode;
            if (currentNode.isTransportNode()) {
                Elevator elev = currentNode.getElevatorLevel().getElevator();
                localSrcNode = doorTarget.door.getAdjacentNodes().stream().filter(node -> node.isTransportNode() && node.getElevatorLevel().getElevator() == elev).findFirst().orElse(localSrcNode);
            }
            Future<Estimate.DoorToGoalValue> future = this.d_globalTarget.getDistFromLocalTarget(kb, agent, doorTarget, localSrcNode);
            dtdBatches.add(new LTargetFuture(doorTarget, future));
        }
        for (LTargetFuture ltfuture : dtdBatches) {
            Estimate.DoorToGoalValue exitVal;
            LocalDoorTarget localTarget = ltfuture.ltarget;
            try {
                exitVal = ltfuture.future.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            TargetInfo dm = new TargetInfo(localTarget, this.d_globalTarget, exitVal);
            doorToGoalDist.put(localTarget, dm);
        }
        if (printOutput) {
            PrintStream out = kb.getParams().out;
            out.println("Door to Goal Distance Map for Selected Agent:");
            this.printDoorToGoalDist(doorToGoalDist, kb.getParams().out);
        }
        return doorToGoalDist;
    }

    private void printDoorToGoalDist(Map<ILocalTarget, TargetInfo> doorToGoalDist, PrintStream out) {
        for (ILocalTarget e : doorToGoalDist.keySet()) {
            TargetInfo val = doorToGoalDist.get(e);
            String v1Name = e.toString();
            String v2Name = val.target.toString();
            out.printf("localTarget=%s; globalTarget=%s; min_tail_dist=%.2f%n", v1Name, v2Name, val.tailInfo.minDist.dist);
        }
        out.printf("%n", new Object[0]);
    }

    private Map<Estimate.PointToGoalDist, Collection<ILocalTarget>> getLocalTargetsOnTails(ILocalTarget targetToUpdate, TargetInfo targetToUpdateInfo, Collection<ILocalTarget> validLocalTargets) {
        IdentityHashMap<Estimate.PointToGoalDist, Collection<ILocalTarget>> result = new IdentityHashMap<Estimate.PointToGoalDist, Collection<ILocalTarget>>();
        for (Estimate.PointToGoalDist tdist : targetToUpdateInfo.tailInfo.dists) {
            ArrayList<ILocalTarget> additionalTargets = new ArrayList<ILocalTarget>();
            Set<Pair<ANode, DoorDir>> usedDoors = tdist.usedDoors;
            for (ILocalTarget target : validLocalTargets) {
                DoorDir dir;
                LocalDoorTarget doorTarget;
                if (!(target instanceof LocalDoorTarget) || target.equals(targetToUpdate) || !usedDoors.contains(new Pair<ANode, DoorDir>(doorTarget.door, dir = this.getLocalDoorDirection(doorTarget = (LocalDoorTarget)target)))) continue;
                additionalTargets.add(target);
            }
            if (additionalTargets.isEmpty()) continue;
            additionalTargets.trimToSize();
            result.put(tdist, additionalTargets);
        }
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        return result;
    }

    private void updateTailDataForLocalElevatorDoors(Map<ILocalTarget, TargetInfo> data, ElevatorModel elevModel) {
        HashMap<Elevator, ILocalTarget> locallyTargetedElevators = new HashMap<Elevator, ILocalTarget>();
        for (ILocalTarget iLocalTarget : data.keySet()) {
            Optional<Elevator> localElevatorOpt = this.getEnteringElevator(elevModel, iLocalTarget);
            if (!localElevatorOpt.isPresent()) continue;
            locallyTargetedElevators.put(localElevatorOpt.get(), iLocalTarget);
        }
        if (locallyTargetedElevators.isEmpty()) {
            return;
        }
        for (Map.Entry entry : data.entrySet()) {
            for (Estimate.PointToGoalDist ptgDist : ((TargetInfo)entry.getValue()).tailInfo.dists) {
                Set locallyTargetedElevatorsInTail = ptgDist.usedDoors.stream().map(nodeDirPair -> LocallyQuickest.getEnteringElevator(elevModel, (ANode)nodeDirPair.v1, (DoorDir)((Object)((Object)((Object)nodeDirPair.v2))))).filter(Optional::isPresent).map(Optional::get).filter(elev -> locallyTargetedElevators.containsKey(elev)).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
                for (Elevator tailElevator : locallyTargetedElevatorsInTail) {
                    TargetInfo info = (TargetInfo)entry.getValue();
                    ILocalTarget otherWithInfo = (ILocalTarget)locallyTargetedElevators.get(tailElevator);
                    if (otherWithInfo == entry.getKey()) continue;
                    info.addLocalTailTargets(ptgDist, Arrays.asList(otherWithInfo));
                }
            }
        }
    }

    private Optional<Elevator> getEnteringElevator(ElevatorModel liftModel, ILocalTarget target) {
        if (target instanceof LocalDoorTarget && ((LocalDoorTarget)target).door.isElevatorDoor()) {
            DoorDir dir = this.getLocalDoorDirection((LocalDoorTarget)target);
            return LocallyQuickest.getEnteringElevator(liftModel, ((LocalDoorTarget)target).door, dir);
        }
        return Optional.empty();
    }

    private static Optional<Elevator> getEnteringElevator(ElevatorModel liftModel, ANode door, DoorDir dir) {
        Optional<Elevator> enteringLiftOpt = Optional.empty();
        ANode dest = DoorDir.getDest(door, dir);
        if (dest != null && dest.isTransportNode()) {
            Elevator lift = dest.getElevatorLevel().getElevator();
            enteringLiftOpt = Optional.of(lift);
        }
        return enteringLiftOpt;
    }

    private void initEvals(Collection<ILocalTarget> validLocalTargets, Map<ILocalTarget, LQuickPath> paths, Map<ILocalTarget, TargetInfo> infos) {
        for (ILocalTarget target : validLocalTargets) {
            TargetInfo ti = infos.get(target);
            LQuickPath path = paths.get(target);
            assert (path != null);
            ti.eval.setPathLength(path.getLocalLength(), path.tailDist != null ? path.tailDist : TargetEval.irrelevantTailDist());
        }
    }

    private boolean isGlobalTarget(ILocalTarget ltarget) {
        return this.d_globalTarget.isLocalTarget(ltarget);
    }

    public void clearBacktrack(boolean clearAll) {
        if (this.d_backtrack != null) {
            this.d_backtrack.clearNextBacktrack(clearAll);
        }
    }

    public static double convertTailPathToTime(Occupant occ, TriPoint[] triPtPath) {
        if (triPtPath == null || triPtPath.length == 0) {
            return 0.0;
        }
        double totalTime = 0.0;
        for (int i = 0; i < triPtPath.length - 1; ++i) {
            Optional<ElevatorLevel> dischargeOpt;
            WingedEdge tp2Edge;
            TriPoint tp1 = triPtPath[i];
            TriPoint tp2 = triPtPath[i + 1];
            if (tp1.getEdge().isTransportDoor() && tp1.tri.node.isTransportNode() && (tp2Edge = tp2.getEdge()) != null && tp2Edge.isTransportDoor() && (dischargeOpt = tp2Edge.getDoorNode().getConnectedElevatorLevel()).isPresent()) {
                ElevatorLevel pickupLevel = tp1.tri.node.getElevatorLevel();
                totalTime += pickupLevel.openTime + pickupLevel.getElevator().getOpenTime() + pickupLevel.getTravelTimeTot(dischargeOpt.get());
                continue;
            }
            SpeedModifier speedMod = tp1.tri.node.getSpeedModifier();
            double speed = speedMod.getAbsoluteSpeed(occ.maxVel, !occ.movingTerrainPref.standing);
            double dist = tp1.p.distance(tp2.p);
            totalTime += dist / speed;
        }
        return totalTime;
    }

    @Override
    public void setRoom(ANode room, OccAgent agent) {
        if (room != this.d_room) {
            this.d_room = room;
            this.invalidate(agent, true);
        }
    }

    private static class Backtrack
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final Set<ANode> d_previousVisitedRooms = new IdentityHashSet<ANode>();
        private final Set<ANode> d_previousDoors = new IdentityHashSet<ANode>();
        private EnterDir d_enterDir = EnterDir.UNKNOWN;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(LocallyQuickest lq, DoorQueue crossedQueue, Point3d crossLoc, ANode destNode) {
            this.d_enterDir = EnterDir.UNKNOWN;
            try {
                boolean passedThroughPlannedDoor;
                boolean enteredPlannedRoom;
                if (lq.d_room == null) {
                    return;
                }
                if (lq.d_prevBestLocalTarget == null || lq.d_localTargetInfo == null) {
                    this.d_previousVisitedRooms.add(lq.d_room);
                    return;
                }
                if (!lq.d_localTargetInfo.containsKey(lq.d_prevBestLocalTarget)) {
                    return;
                }
                boolean bl = enteredPlannedRoom = lq.d_prevBestLocalTarget instanceof LocalDoorTarget && ((LocalDoorTarget)lq.d_prevBestLocalTarget).door.doorQueue.getAdjNode(lq.d_room) == destNode;
                if (enteredPlannedRoom) {
                    this.d_previousVisitedRooms.add(lq.d_room);
                    ANode door = crossedQueue.getNode();
                    LocalDoorTarget dt = new LocalDoorTarget(door);
                    TargetInfo ti = lq.d_localTargetInfo.get(dt);
                    if (ti != null) {
                        Estimate.PointToGoalDist tailDist;
                        DoorDir naturalDir;
                        DoorDir crossDir = door.doorQueue.getDir(destNode);
                        this.d_enterDir = crossDir == (naturalDir = ti.getNaturalDir(tailDist = ti.tailInfo.getDistFrom(crossLoc))) ? EnterDir.NATURAL : EnterDir.UNNATURAL;
                    }
                }
                boolean bl2 = passedThroughPlannedDoor = lq.d_prevBestLocalTarget instanceof LocalDoorTarget && ((LocalDoorTarget)lq.d_prevBestLocalTarget).door == crossedQueue.getNode();
                if (passedThroughPlannedDoor) {
                    this.d_previousDoors.add(crossedQueue.getNode());
                } else {
                    this.d_previousDoors.remove(crossedQueue.getNode());
                    if (KB.DEBUG_PATHS || KB.DEBUG_STEERING) {
                        System.err.printf("Occupant accidently enters %s, not updating backtrack prevent.%n", destNode);
                    }
                }
            }
            finally {
                this.d_previousVisitedRooms.remove(destNode);
            }
        }

        public void clearNextBacktrack(boolean clearAll) {
            if (!this.d_previousVisitedRooms.isEmpty()) {
                this.d_previousVisitedRooms.clear();
                if (!clearAll) {
                    return;
                }
            }
            if (!this.d_previousDoors.isEmpty()) {
                this.d_previousDoors.clear();
                return;
            }
        }

        public Predicate<Pair<TargetInfo, Estimate.PointToGoalDist>> getFilter(ANode currNode) {
            if (this.d_previousVisitedRooms.isEmpty() && this.d_previousDoors.isEmpty()) {
                return Filters.acceptAll();
            }
            return p -> {
                TargetInfo o = (TargetInfo)p.v1;
                Estimate.PointToGoalDist td = (Estimate.PointToGoalDist)p.v2;
                if (!this.d_previousDoors.isEmpty() && o.ltarget instanceof LocalDoorTarget) {
                    for (Pair<ANode, DoorDir> usedDoor : td.usedDoors) {
                        if (!this.d_previousDoors.contains(usedDoor.v1)) continue;
                        return false;
                    }
                }
                if (this.d_enterDir == EnterDir.NATURAL && o.ltarget instanceof LocalDoorTarget) {
                    LocalDoorTarget doorTarget = (LocalDoorTarget)o.ltarget;
                    DoorDir outDir = doorTarget.door.doorQueue.getDir(currNode).opposite();
                    if (o.getNaturalDir(td) == outDir) {
                        return true;
                    }
                }
                if (!this.d_previousVisitedRooms.isEmpty()) {
                    for (Pair<ANode, DoorDir> usedDoor : td.usedDoors) {
                        ANode n1 = ((ANode)usedDoor.v1).doorQueue.getR1();
                        ANode n2 = ((ANode)usedDoor.v1).doorQueue.getR2();
                        if (!this.d_previousVisitedRooms.contains(n1) && !this.d_previousVisitedRooms.contains(n2)) continue;
                        return false;
                    }
                }
                return true;
            };
        }

        private static enum EnterDir {
            UNKNOWN,
            NATURAL,
            UNNATURAL;

        }
    }

    protected static class LQuickPath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final IPath path;
        public final List<TriEdge> edges;
        public final Estimate.PointToGoalDist tailDist;

        public LQuickPath(IPath path, List<TriEdge> edges, Estimate.PointToGoalDist tailDist) {
            this.path = path;
            this.edges = edges;
            this.tailDist = tailDist;
        }

        public double getLocalLength() {
            return this.path.length(false);
        }
    }

    public static class TargetEval
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public double tFlowrateReset;
        public double tLastEvaluated;
        public double queueTimeLastKnown;
        public double pathLenLastKnown;
        public double pathLenEst;
        public Estimate.PointToGoalDist tailDist;
        private Double tailTime = null;

        public TargetEval(double tFlowrateReset) {
            this(tFlowrateReset, Double.NEGATIVE_INFINITY, 0.0, Double.NaN, Double.NaN, TargetEval.irrelevantTailDist());
        }

        public TargetEval(double tFlowrateReset, double tLastEvaluated, double queueTimeLastKnown, double pathLenLastKnown, double pathLenEst, Estimate.PointToGoalDist tailDist) {
            this.tFlowrateReset = tFlowrateReset;
            this.tLastEvaluated = tLastEvaluated;
            this.queueTimeLastKnown = queueTimeLastKnown;
            this.pathLenLastKnown = pathLenLastKnown;
            this.pathLenEst = pathLenEst;
            this.tailDist = tailDist;
        }

        public static Estimate.PointToGoalDist irrelevantTailDist() {
            return new Estimate.PointToGoalDist(null, 0.5, 0.0, 0.0, null, null, new TriPoint[0], Collections.emptyList());
        }

        public static Estimate.PointToGoalDist infiniteTailDist() {
            return new Estimate.PointToGoalDist(null, 0.5, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, null, null, new TriPoint[0], Collections.emptyList());
        }

        protected TargetEval clone() {
            try {
                return (TargetEval)super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        public boolean isInitialized() {
            return !Double.isNaN(this.pathLenEst);
        }

        public void setPathLength(double len, Estimate.PointToGoalDist tailDist) {
            this.pathLenEst = this.pathLenLastKnown = len;
            if (this.tailDist != tailDist) {
                this.tailDist = tailDist;
                this.tailTime = null;
            }
        }

        public boolean hasPath() {
            return !Double.isInfinite(this.pathLenEst);
        }

        public boolean isLenEstExact() {
            return this.isInitialized() && theUtil.eq(this.pathLenEst, this.pathLenLastKnown, 0.001);
        }

        public void updatePathLenEst(double minDist, double distTravelled) {
            if (!this.isInitialized()) {
                this.pathLenEst = minDist;
            } else if (this.hasPath()) {
                this.pathLenEst = Math.max(minDist, this.pathLenEst - distTravelled);
            }
        }

        public double getTailDist() {
            return this.tailDist.dist;
        }

        public double getTailTime(KB kb, OccAgent agent) {
            if (this.tailTime == null) {
                double calcTailTime = LocallyQuickest.convertTailPathToTime(agent.getOcc(), this.tailDist.path);
                for (Pair<ANode, DoorDir> door : this.tailDist.usedDoors) {
                    double tQueue = ((ANode)door.v1).doorQueue.getWaitTime(kb, (DoorDir)((Object)door.v2), agent);
                    calcTailTime += tQueue;
                }
                this.tailTime = calcTailTime;
            }
            return this.tailTime;
        }
    }

    public static class TargetInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ILocalTarget ltarget;
        public final IGlobalTarget target;
        public final Estimate.DoorToGoalValue tailInfo;
        public TargetEval eval;
        private Map<Estimate.PointToGoalDist, Collection<ILocalTarget>> pLocalTailTargets;

        public TargetInfo(ILocalTarget ltarget, IGlobalTarget target, Estimate.DoorToGoalValue targetDist) {
            this.ltarget = ltarget;
            this.target = target;
            this.tailInfo = targetDist;
            this.eval = new TargetEval(0.0);
            this.pLocalTailTargets = Collections.emptyMap();
        }

        public DoorDir getNaturalDir(Estimate.PointToGoalDist tailDist) {
            return this.tailInfo.getNaturalDir(tailDist);
        }

        public Collection<ILocalTarget> getLocalTailTargets(Estimate.PointToGoalDist tdist) {
            return this.pLocalTailTargets.getOrDefault(tdist, Collections.emptyList());
        }

        public void addLocalTailTargets(Estimate.PointToGoalDist tdist, Collection<ILocalTarget> targets) {
            if (this.pLocalTailTargets.isEmpty()) {
                this.pLocalTailTargets = new HashMap<Estimate.PointToGoalDist, Collection<ILocalTarget>>();
            }
            if (!this.pLocalTailTargets.containsKey(tdist)) {
                this.pLocalTailTargets.put(tdist, new ArrayList());
            }
            this.pLocalTailTargets.get(tdist).addAll(targets);
        }
    }

    private static class BestTarget {
        public final ILocalTarget target;
        public final LQuickPath path;
        public final Map<ILocalTarget, TargetEval> targetEvals;

        public BestTarget(ILocalTarget target, LQuickPath path, Map<ILocalTarget, TargetEval> targetEvals) {
            this.target = target;
            this.path = path;
            this.targetEvals = targetEvals;
        }
    }

    public static class LocalTimeEstimateVal {
        private Pair<Double, Double> timeEstimate;
        private final Map<AdditionalTimeEstType, Pair<Double, Double>> additionalTimeEst;

        public LocalTimeEstimateVal(double queueTime, double travelTime) {
            this(queueTime, travelTime, null);
        }

        public LocalTimeEstimateVal(double queueTime, double travelTime, Map<AdditionalTimeEstType, Pair<Double, Double>> additionalTimeEst) {
            this.timeEstimate = new Pair<Double, Double>(queueTime, travelTime);
            this.additionalTimeEst = additionalTimeEst;
        }

        public void setTravelTime(double travelTime) {
            this.timeEstimate = new Pair<Double, Double>((Double)this.timeEstimate.v1, travelTime);
        }

        public void setQueueTime(double queueTime) {
            this.timeEstimate = new Pair<Double, Double>(queueTime, (Double)this.timeEstimate.v2);
        }

        public String toString() {
            return new ToStringBuilder(this).append("queueTime", this.timeEstimate.v1).append("travelTime", this.timeEstimate.v2).append("additionalTimeEst", this.additionalTimeEst).toString();
        }

        public Pair<Double, Double> getLocalTimeEstimate() {
            return this.getLocalTimeEstimate(AdditionalTimeEstType.NONE);
        }

        public Pair<Double, Double> getLocalTimeEstimate(AdditionalTimeEstType type) {
            if (type == AdditionalTimeEstType.NONE || this.additionalTimeEst == null || !this.additionalTimeEst.containsKey((Object)type)) {
                return this.timeEstimate;
            }
            return this.additionalTimeEst.get((Object)type);
        }

        public double getTotalTimeEst(AdditionalTimeEstType type) {
            Pair<Double, Double> p = this.getLocalTimeEstimate(type);
            return (Double)p.v1 + (Double)p.v2;
        }

        private static AdditionalTimeEstType getTimeEstTypeFor(OccAgent agent, ILocalTarget target) {
            return target instanceof LocalDoorTarget && ((LocalDoorTarget)target).door.isTransportDoor() && !agent.getOcc().curNode.isTransportNode() ? AdditionalTimeEstType.TRANSPORT_DOOR : AdditionalTimeEstType.NONE;
        }
    }

    public static enum AdditionalTimeEstType {
        NONE,
        TRANSPORT_DOOR;

    }

    public static class TargetCostComparer {
        public final ILocalTarget target;
        public final double distTravelled;
        public final LocalTimeEstimateVal localTimeEst;
        public final double localDist;
        public final int priority;
        public final TargetEval targetEval;

        public TargetCostComparer(KB kb, OccAgent agent, ILocalTarget target, int priority, double distTravelled, double localDist, LocalTimeEstimateVal localTimeEst, TargetEval targetEval) {
            this.target = target;
            this.distTravelled = distTravelled;
            this.priority = priority;
            this.localTimeEst = localTimeEst;
            this.localDist = localDist;
            this.targetEval = targetEval;
        }

        public int compareTo(KB kb, OccAgent agent, ILocalTarget currTarget, TargetCostComparer o) {
            double cost2;
            AdditionalTimeEstType type1 = LocalTimeEstimateVal.getTimeEstTypeFor(agent, this.target);
            AdditionalTimeEstType type2 = LocalTimeEstimateVal.getTimeEstTypeFor(agent, o.target);
            Pair<Double, Double> timeEst1 = this.localTimeEst.getLocalTimeEstimate(type1);
            Pair<Double, Double> timeEst2 = o.localTimeEst.getLocalTimeEstimate(type2);
            double queueTime1 = (Double)timeEst1.v1;
            double queueTime2 = (Double)timeEst2.v1;
            double cost1 = LocalDoorCosts.getCost(kb, agent, this.target.equals(currTarget), this.distTravelled, queueTime1, (Double)timeEst1.v2, this.targetEval);
            if (theUtil.eq(cost1, cost2 = LocalDoorCosts.getCost(kb, agent, o.target.equals(currTarget), o.distTravelled, queueTime2, (Double)timeEst2.v2, o.targetEval), 1.0E-6) || Double.isInfinite(cost1) && Double.isInfinite(cost2)) {
                return this.priority < o.priority || this.priority == o.priority && o.localDist < this.localDist ? 1 : -1;
            }
            return cost2 < cost1 ? 1 : -1;
        }

        public String toString() {
            return this.target.toString();
        }
    }

    private static class LTargetFuture {
        public final LocalDoorTarget ltarget;
        public final Future<Estimate.DoorToGoalValue> future;

        public LTargetFuture(LocalDoorTarget ltarget, Future<Estimate.DoorToGoalValue> future) {
            this.ltarget = ltarget;
            this.future = future;
        }
    }
}

