/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.Estimate;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.locallyquickest.IGlobalTarget;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalDoorTarget;
import inferno.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import thunderheadeng.util.LinkedIdentityHashSet;

public class GlobalDoorTarget
implements IGlobalTarget,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Set<ANode> doors;
    private transient PathGen.IPathGoal d_goal;

    public GlobalDoorTarget(Collection<ANode> doors) {
        assert (Util.isOrdered(doors));
        assert (!doors.isEmpty());
        this.doors = doors instanceof Set ? (Set<Object>)doors : new LinkedIdentityHashSet<ANode>(doors);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public boolean isStatic(KB kb) {
        return true;
    }

    @Override
    public int update(KB kb, OccAgent agent) {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GlobalDoorTarget && ((GlobalDoorTarget)obj).doors.equals(this.doors);
    }

    public int hashCode() {
        return 0xF323FA3 ^ this.doors.hashCode();
    }

    @Override
    public Future<Estimate.DoorToGoalValue> getDistFromLocalTarget(KB kb, OccAgent agent, LocalDoorTarget localDoor, ANode currentRoom) {
        Predicate<Tri> triFilter = TriFilters.rejectClosed();
        return kb.getPathEstimates().doorToGoalDistance(localDoor.door, this.getGoal(), currentRoom, agent.generatePathFilter(kb, triFilter, EdgeFilters.acceptAll(), OccAgent.PathFilterType.DOOR_TO_GOAL));
    }

    protected PathGen.IPathGoal getGoal() {
        if (this.d_goal == null) {
            this.d_goal = PathGen.newDoorGoal(this.doors);
        }
        return this.d_goal;
    }

    @Override
    public Collection<? extends ILocalTarget> getLocalTargets(KB kb, OccAgent agent, ANode currentRoom) {
        ArrayList<LocalDoorTarget> ltargets = Collections.EMPTY_LIST;
        for (ANode door : this.doors) {
            if (!currentRoom.getDoors().contains(door)) continue;
            if (ltargets.isEmpty()) {
                ltargets = new ArrayList<LocalDoorTarget>();
            }
            ltargets.add(new LocalDoorTarget(door));
        }
        return ltargets;
    }

    @Override
    public boolean isLocalTarget(ILocalTarget target) {
        return target instanceof LocalDoorTarget && this.doors.contains(((LocalDoorTarget)target).door);
    }

    public String toString() {
        StringBuilder name = new StringBuilder();
        name.append('[');
        for (ANode door : this.doors) {
            if (name.length() > 1) {
                name.append(", ");
            }
            name.append(door.name);
        }
        name.append(']');
        return name.toString();
    }
}

