/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.Occupant;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.IdleSeparation;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class SocialDistance
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final int FILTERID = -1348979970;
    private static final double HPRIOR_FACTOR = theUtil.getSystemDouble("SocialDistance.HPRIOR_FACTOR", 0.5);
    private static final double HPRIOR_FACTOR_SQ = HPRIOR_FACTOR * HPRIOR_FACTOR;
    private static final double MIN_BACKWARD_FACTOR = theUtil.getSystemDouble("SocialDistance.MIN_BACKWARD_FACTOR", 0.5);
    private static final int METHOD_IX = theUtil.getSystemInt("SocialDistance.METHOD", Method.MIN_DIST.ordinal());
    public static final Method METHOD = METHOD_IX >= Method.values().length ? Method.AVG_DIST : Method.values()[METHOD_IX];
    private final ArrayList<NearOccInfo> d_nearOccPredictPositions = new ArrayList();
    private final ArrayList<OccAgent> d_highCostOccs = new ArrayList();
    private final Map<Vector3d, DirCost> d_costs = new HashMap<Vector3d, DirCost>();
    private final Map<OccAgent, Double> d_cachedSocialDist = new IdentityHashMap<OccAgent, Double>();

    public SocialDistance(KB kb, OccInfo oi, SeekInfo seekInfo, Senses senses) {
        double predictTime = SocialDistance.getPredictTime(oi);
        Collection<OccAgent> nearOccs = senses.getNearOccs(-1348979970, oi);
        for (OccAgent nearOcc : nearOccs) {
            double sd = this.getSocialDist(kb, oi, nearOcc);
            if (sd == 0.0) continue;
            Point3d predictPos = Util3D.add(nearOcc.getPos(), (Tuple3d)Util3D.scale(nearOcc.getVel(), predictTime));
            boolean higherPrior = InvSteerUtil.compare(kb, oi, nearOcc) > 0;
            this.d_nearOccPredictPositions.add(new NearOccInfo(nearOcc, predictPos, higherPrior));
        }
    }

    public int getSeekSampleOptions() {
        if (this.isDistancing()) {
            return 4;
        }
        return 0;
    }

    public boolean isDistancing() {
        return !this.d_nearOccPredictPositions.isEmpty();
    }

    public boolean separateFrom(KB kb, OccInfo oi, OccAgent other) {
        return this.getSocialDist(kb, oi, other) != 0.0;
    }

    private double getSocialDist(KB kb, OccInfo oi, OccAgent other) {
        return this.d_cachedSocialDist.computeIfAbsent(other, o -> {
            int pcomp = InvSteerUtil.compare(kb, oi, o);
            if (!InvSteerUtil.canSeparate(kb, oi, null, o, pcomp, false) || oi.oa.isAssisting(kb, (OccAgent)o)) {
                return 0.0;
            }
            return oi.oa.getSocialDistance((OccAgent)o);
        });
    }

    public void init(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, List<Vector3d> sampleDirs) {
        if (this.d_nearOccPredictPositions.isEmpty()) {
            return;
        }
        Occupant occ = oi.oa.getOcc();
        double predictDist = oi.cache.maxVel * SocialDistance.getPredictTime(oi);
        double prefSocialDist = oi.oa.getOcc().socialDist;
        double prefSocialDistSq = prefSocialDist * prefSocialDist;
        double adjustedSocialDistSq = prefSocialDistSq * HPRIOR_FACTOR_SQ;
        BitSet nearOccInfluence = new BitSet(this.d_nearOccPredictPositions.size());
        boolean higherPriorDetected = this.d_nearOccPredictPositions.stream().anyMatch(noi -> noi.higherPrior);
        BiFunction<Vector3d, DirInfo, DirInfo> getDirInfo = (dir, nullDirInfo) -> {
            Point3d predictPos = dir == null ? occ.loc : Util3D.add(occ.loc, (Tuple3d)Util3D.scale(dir, predictDist));
            ToDoubleFunction<NearOccInfo> getDistSq = noi -> {
                Vector3d nearMoveDir;
                Vector3d avoidDir;
                OccAgent nearOcc = noi.occ;
                if (noi.higherPrior && !nearOcc.isWaiting(kb) && Util.dot2d(avoidDir = IdleSeparation.getAvoidDir(kb, nearOcc, oi.priority), nearMoveDir = Util.vector2d(nearOcc.getPos(), oi.oa.getPos())) > 0.0) {
                    Point3d pos1 = predictPos;
                    Point3d pos2 = noi.projPos;
                    return Inter2D.distSqToNearestPtOnLine(pos2.x, pos2.y, avoidDir.x, avoidDir.y, pos1.x, pos1.y);
                }
                return predictPos.distanceSquared(noi.projPos);
            };
            double comfort = 0.0;
            OccAgent lowestComfortNeighbor = null;
            double maxVel = oi.cache.maxVel;
            switch (METHOD.ordinal()) {
                case 0: {
                    double count = 0.0;
                    double closestNeighborDistSq = Double.POSITIVE_INFINITY;
                    for (int m = 0; m < this.d_nearOccPredictPositions.size(); ++m) {
                        NearOccInfo entry = this.d_nearOccPredictPositions.get(m);
                        double distSq = getDistSq.applyAsDouble(entry);
                        if (!(distSq < prefSocialDistSq)) continue;
                        nearOccInfluence.set(m);
                        comfort += Math.sqrt(distSq);
                        count += 1.0;
                        if (!(distSq < closestNeighborDistSq)) continue;
                        closestNeighborDistSq = distSq;
                        lowestComfortNeighbor = entry.occ;
                    }
                    if (count == 0.0) {
                        return null;
                    }
                    comfort /= count;
                    break;
                }
                case 1: {
                    Vector3d occDir = new Vector3d();
                    double lowestComfort = Double.POSITIVE_INFINITY;
                    for (int m = 0; m < this.d_nearOccPredictPositions.size(); ++m) {
                        double maxDistSq;
                        NearOccInfo entry = this.d_nearOccPredictPositions.get(m);
                        double distSq = getDistSq.applyAsDouble(entry);
                        double d = maxDistSq = higherPriorDetected && !entry.higherPrior ? adjustedSocialDistSq : prefSocialDistSq;
                        if (seekInfo.seekDir != null) {
                            occDir.sub(entry.projPos, predictPos);
                            Util3D.safeNormalize(occDir, 1.0E-6);
                            double dot = Util.dot2d(occDir, seekInfo.seekDir);
                            if (dot < 0.0) {
                                double angle = Math.abs(Util2D.sAngle(seekInfo.seekDir.x, seekInfo.seekDir.y, occDir.x, occDir.y));
                                double minFactor = MIN_BACKWARD_FACTOR;
                                double factor = KnownFuncs.linInterp(1.5707963267948966, 1.0, Math.PI, minFactor, angle);
                                maxDistSq *= factor * factor;
                            }
                        }
                        if (!(distSq < maxDistSq)) continue;
                        nearOccInfluence.set(m);
                        double occComfort = Math.sqrt(distSq / maxDistSq);
                        if (!(occComfort < lowestComfort)) continue;
                        lowestComfort = occComfort;
                        lowestComfortNeighbor = entry.occ;
                    }
                    if (lowestComfortNeighbor == null) {
                        return null;
                    }
                    comfort = lowestComfort;
                    if (dir == null || seekInfo.seekDir == null || !theUtil.lt0(seekInfo.seekDir.dot((Vector3d)dir), 1.0E-6)) break;
                    maxVel *= 1.0 - comfort;
                    break;
                }
                case 2: {
                    double count = 0.0;
                    double closestNeighborDistSq = Double.POSITIVE_INFINITY;
                    for (int m = 0; m < this.d_nearOccPredictPositions.size(); ++m) {
                        NearOccInfo entry = this.d_nearOccPredictPositions.get(m);
                        double distSq = getDistSq.applyAsDouble(entry);
                        if (!(distSq < prefSocialDistSq)) continue;
                        nearOccInfluence.set(m);
                        comfort += Math.sqrt(distSq) / prefSocialDist;
                        count += 1.0;
                        if (!(distSq < closestNeighborDistSq)) continue;
                        closestNeighborDistSq = distSq;
                        lowestComfortNeighbor = entry.occ;
                    }
                    if (count == 0.0) {
                        return null;
                    }
                    comfort /= count;
                    break;
                }
            }
            return new DirInfo((Vector3d)dir, comfort, maxVel);
        };
        DirInfo nullDirInfo2 = null;
        if (Arrays.asList(sampleDirs).contains(null)) {
            nullDirInfo2 = getDirInfo.apply(null, null);
        }
        ArrayList<DirInfo> dirInfos = new ArrayList<DirInfo>();
        if (nullDirInfo2 != null) {
            dirInfos.add(nullDirInfo2);
        }
        for (Vector3d vector3d : sampleDirs) {
            DirInfo di;
            if (vector3d == null || (di = getDirInfo.apply(vector3d, nullDirInfo2)) == null) continue;
            dirInfos.add(di);
        }
        if (dirInfos.isEmpty()) {
            return;
        }
        this.d_highCostOccs.ensureCapacity(nearOccInfluence.cardinality());
        for (int m = 0; m < this.d_nearOccPredictPositions.size(); ++m) {
            if (!nearOccInfluence.get(m)) continue;
            this.d_highCostOccs.add(this.d_nearOccPredictPositions.get((int)m).occ);
        }
        double[] comfortRange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (DirInfo di : dirInfos) {
            if (di.comfort < comfortRange[0]) {
                comfortRange[0] = di.comfort;
            }
            if (!(di.comfort > comfortRange[1])) continue;
            comfortRange[1] = di.comfort;
        }
        double d = comfortRange[1] - comfortRange[0];
        if (d == 0.0) {
            return;
        }
        double iComfortRange = 1.0 / d;
        for (DirInfo di : dirInfos) {
            double cost = 1.0 - (di.comfort - comfortRange[0]) * iComfortRange;
            double maxVel = di.maxVel;
            this.d_costs.put(di.dir, new DirCost(new double[]{cost, maxVel}));
        }
    }

    public static double getSensingRadius(KB kb, OccInfo oi) {
        double sdist = oi.oa.getOcc().socialDist;
        return Double.isNaN(sdist) ? 0.0 : sdist + oi.cache.maxVel * SocialDistance.getPredictTime(oi) * 2.0;
    }

    private static double getPredictTime(OccInfo oi) {
        return (double)oi.oa.getOcc().reacTime * 1.0;
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d dir, Consumer<OccAgent> highCostOccs) {
        DirCost cost = this.d_costs.get(dir);
        if (cost != null) {
            if (highCostOccs != null) {
                for (OccAgent other : this.d_highCostOccs) {
                    Vector3d odir = Util3D.vector(oi.oa.getPos(), other.getPos());
                    if (Util3D.safeNormalize(odir, 0.0) != 0.0 && !theUtil.gt0(odir.dot(dir), 1.0E-6)) continue;
                    highCostOccs.accept(other);
                }
            }
            return cost.cost;
        }
        return new double[]{0.0, oi.cache.maxVel};
    }

    private static final class NearOccInfo {
        public final OccAgent occ;
        public final Point3d projPos;
        public final boolean higherPrior;

        public NearOccInfo(OccAgent occ, Point3d projPos, boolean higherPrior) {
            this.occ = occ;
            this.projPos = projPos;
            this.higherPrior = higherPrior;
        }

        public String toString() {
            return String.format("(%g,%g)", this.occ.getName(), this.projPos);
        }
    }

    private static class DirInfo {
        public final Vector3d dir;
        public final double comfort;
        public final double maxVel;

        public DirInfo(Vector3d dir, double comfort, double maxVel) {
            this.dir = dir;
            this.comfort = comfort;
            this.maxVel = maxVel;
        }

        public String toString() {
            return String.format("%s=%g", this.dir, this.comfort);
        }
    }

    private static class DirCost {
        double[] cost;

        public DirCost(double[] cost) {
            this.cost = cost;
        }

        public String toString() {
            return String.format("(%g,%g)", this.cost[0], this.cost[1]);
        }
    }

    private static enum Method {
        AVG_DIST,
        MIN_DIST,
        AVG_INV_COST;

    }
}

