/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import common.data.EscalatorPreference;
import inferno.data2.IAgentBodyShape;
import inferno.data2.NavigateMeshData;
import inferno.data2.OccPriority;
import inferno.data2.PolygonShape;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.geom.WallSlider;
import inferno.sim.AgentVehicle;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LookAtUtil;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import inferno.sim.steering.inverse.AvoidObstacles;
import inferno.sim.steering.inverse.AvoidOccs;
import inferno.sim.steering.inverse.AvoidWalls;
import inferno.sim.steering.inverse.BehaviorWeights;
import inferno.sim.steering.inverse.CornerBehavior;
import inferno.sim.steering.inverse.ICostCalc;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.IdleSeparation;
import inferno.sim.steering.inverse.InvSteerMeta;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.LaneBehavior;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.PassBehavior;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.SeekSeparation;
import inferno.sim.steering.inverse.SeekWallSeparation;
import inferno.sim.steering.inverse.Senses;
import inferno.sim.steering.inverse.SocialDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ListSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.QuadFunction;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;

public class NavigateMesh
implements ISteeringBehavior,
Serializable {
    static final long serialVersionUID = 1L;
    public static final boolean NO_HIGH_PRIORITY = System.getProperty("NavigateMesh.NO_HIGH_PRIORITY") != null;
    private static final double LOWCOST_THRESHHOLD = 0.01;
    private ISeekCalc d_seek;
    private final Predicate<OccAgent> d_avoidFilter;
    private final Predicate<OccAgent> d_collisionFilter;
    private final ICostCalc[] d_additionalCalcs;
    private Steer d_lastSteer = null;
    private double d_nextSteerTime = 0.0;

    public NavigateMesh(ISeekCalc seekCalc, Predicate<OccAgent> avoidFilter, Predicate<OccAgent> collisionFilter, ICostCalc ... additionalCalcs) {
        this.d_seek = seekCalc;
        this.d_additionalCalcs = additionalCalcs;
        this.d_avoidFilter = avoidFilter;
        this.d_collisionFilter = collisionFilter;
    }

    @Override
    public void done(KB kb, OccAgent occ, boolean interrupted) {
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.d_seek.doorCrossed(t, agent, door);
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        return this.d_seek.generateSeekCurve(kb, agent);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return this.d_seek.getPathFollow(agent);
    }

    public String getName() {
        return "Inverse-steering Mesh Navigation";
    }

    public void setSeekCostCalc(ISeekCalc seek) {
        this.d_seek = seek;
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return this.d_seek.getTimeLimit(kb, agent);
    }

    private boolean isSteeringDirty(KB kb) {
        return this.d_lastSteer == null || theUtil.ge(kb.getCurrentSimTime(), this.d_nextSteerTime, 1.0E-6);
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek) {
        if (!this.isSteeringDirty(world)) {
            InvSteerMeta meta = InvSteerUtil.getSteerMeta(this.d_lastSteer);
            return meta.tightGeometry ? this.d_lastSteer : this.d_lastSteer.applySeek(seek);
        }
        Predicate<OccAgent> occAvoidFilter = this.d_avoidFilter;
        Predicate<OccAgent> occCollisionFilter = this.d_collisionFilter;
        BestDir lowestCost = this.getLowestCostDir(world, agent, seek, occAvoidFilter, occCollisionFilter);
        double speed = lowestCost.speed;
        Vector3d desiredVel = Util3D.scale(lowestCost.dir, speed);
        assert (Util.isValid(desiredVel));
        Supplier<Vector3d> getGoalOrient = () -> {
            boolean canTurnInPlace;
            Vector3d idleOrient;
            if (desiredVel.lengthSquared() <= 1.0E-6 && (idleOrient = this.d_seek.getIdleOrient(world, agent)) != null) {
                return idleOrient;
            }
            if (agent.isWaiting(world)) {
                return desiredVel.lengthSquared() == 0.0 ? agent.getDirFacing() : Util3D.normalize(desiredVel);
            }
            Vector3d seekDir = seek.curve.getTangent(0.0);
            Vector3d goalOrient = lowestCost.orient != null ? lowestCost.orient : (!(canTurnInPlace = true) && agent.getOcc().bodyShape instanceof PolygonShape && desiredVel.lengthSquared() == 0.0 ? agent.getDirFacing() : (desiredVel.lengthSquared() == 0.0 ? seekDir : (desiredVel.dot(seekDir) < 0.0 ? Util3D.negate(desiredVel) : new Vector3d(desiredVel))));
            goalOrient.normalize();
            return goalOrient;
        };
        Vector3d orient = LookAtUtil.orientToTargetIfVisible(world, agent.getOcc().lookAtSource, agent, getGoalOrient);
        InvSteerMeta meta = null;
        boolean tightGeometry = false;
        if (lowestCost.meta.isValidMeta(world)) {
            meta = lowestCost.meta;
            tightGeometry = lowestCost.meta.tightGeometry;
        }
        OccAgent avoidOcc = lowestCost.avoidOccs.length == 0 ? null : lowestCost.avoidOccs[0];
        boolean collidable = !Predicates.alwaysFalse(occCollisionFilter);
        this.d_lastSteer = new Steer((Object)meta, lowestCost.seek, desiredVel, orient, lowestCost.priority, lowestCost.squeezeFactor, (Predicate<OccAgent>)lowestCost.collisionFilter, tightGeometry, collidable, avoidOcc);
        this.d_nextSteerTime = agent.calcNextUpdate(world, agent.getOcc().reacTime);
        return this.d_lastSteer;
    }

    private BestDir getNoMovementDir(KB world, OccAgent agent, SeekCurve seek, Predicate<OccAgent> initCollisionFilter) {
        InvSteerMeta meta = new InvSteerMeta(0.0, 0.0, Filters.rejectAll(), new Senses.Memory(), InvSteerMeta.Memento.DEFAULT, false, Double.NaN, false);
        return new BestDir(seek, GeomConstants.VEC3D_ZERO, 0.0, OccPriority.lower(agent.getOcc().priority), 1.0, new OccAgent[0], false, initCollisionFilter, meta, null);
    }

    private BestDir getLowestCostDir(KB world, OccAgent agent, SeekCurve seek, Predicate<OccAgent> agentFilter, Predicate<OccAgent> initCollisionFilter) {
        TriFunction<SeekCurve, Dir, Boolean, BestDir> releasePriority;
        double stuckOnWallsBegin;
        boolean extendStuckWalls;
        boolean stuck;
        Vector3d[] sampleDirs;
        if (KB.DEBUG_STEERING && agent.isSelected()) {
            System.out.printf("Selected Agent (t=%s):%n", world.getCurrentSimTime());
        }
        OccInfo.CachedData cdata = new OccInfo.CachedData(world, agent);
        if (cdata.maxVel == 0.0) {
            return this.getNoMovementDir(world, agent, seek, initCollisionFilter);
        }
        BiFunction<OccAgent, Boolean, Pair> getGeomBodyShape = (occ, tightGeometry) -> {
            boolean isSafeShape = occ.hasVehicle() && occ.getVehicle().getFreePass();
            IAgentBodyShape geomShape = occ.getGeomCollisionShape(world, false, (boolean)tightGeometry);
            IAgentBodyShape safeGeomShape = isSafeShape ? occ.getGeomCollisionShape(world, true, (boolean)tightGeometry) : geomShape;
            return new Pair<IAgentBodyShape, IAgentBodyShape>(safeGeomShape, geomShape);
        };
        Pair geomShapes = getGeomBodyShape.apply(agent, false);
        SeekCurve tightSeekCurve = seek;
        if (agent.hasTightGeomRepresentation()) {
            WallSlider expandedWallSlider = Util.getWallSlider(world, agent, ((IAgentBodyShape)geomShapes.v1).getEnclosingRadius(), seek.wallSlider.getEdgeFilter());
            seek = new SeekCurve(seek.curve, expandedWallSlider, seek.transientPathFilter, seek.seeking);
        }
        OccInfo oi = new OccInfo(agent, agent.getShape(), 1.0, (IAgentBodyShape)geomShapes.v1, (IAgentBodyShape)geomShapes.v2, OccPriority.lower(agent.getOcc().priority), initCollisionFilter, InvSteerUtil.getSteerMeta((OccAgent)agent).raisedPriorityFilter, cdata, false);
        this.d_seek.init(world, oi, seek.curve);
        IdleSeparation sep = this.d_seek.getSeparation(world, oi);
        SeekInfo seekInfo = this.d_seek.getSeekInfo(world, oi, seek);
        double searchRadius = sep.getSensingRadius(world, oi);
        if (oi.oa.getOcc().bodyShape instanceof PolygonShape) {
            double searchMult = 1.1;
            searchRadius = 2.0 * oi.oa.getOcc().bodyShape.getEnclosingRadius() * searchMult;
        }
        searchRadius = Math.max(searchRadius, AvoidOccs.getSensingRadius(world, oi, sep.getSepDist()));
        searchRadius = Math.max(searchRadius, SocialDistance.getSensingRadius(world, oi));
        for (ICostCalc additionalCalc : this.d_additionalCalcs) {
            double sdist = additionalCalc.getOccSensingRadius(world, agent);
            if (!(sdist > searchRadius)) continue;
            searchRadius = sdist;
        }
        double fov = this.d_seek.getSensingFOV(world, oi);
        double wallSenseRadius = SeekWallSeparation.getWallSensingRadius(world, oi, fov);
        double hazardSenseRadius = AvoidObstacles.getSensingRadius(world, oi);
        ArrayList<Senses.AgentFilter> filters = new ArrayList<Senses.AgentFilter>();
        filters.add(new Senses.AgentFilter(-1348979970, agentFilter, searchRadius, fov));
        Senses.AgentFilter laneFilter = LaneBehavior.getAgentFilter(oi, seekInfo, agentFilter);
        if (laneFilter != null) {
            filters.add(laneFilter);
        }
        InvSteerMeta meta = InvSteerUtil.getSteerMeta(agent);
        Senses senses = new Senses(world, meta.senseMemory != null ? meta.senseMemory : new Senses.Memory(), agent, seek.curve, seek.wallSlider, hazardSenseRadius, wallSenseRadius, filters);
        TriFunction<OccInfo, IdleSeparation, SeekInfo, Optional> getSocialDistance = (occInfo, s, si) -> !s.isSeparating() && occInfo.oa.isSocialDistancingEnabled() ? Optional.of(new SocialDistance(world, (OccInfo)occInfo, (SeekInfo)si, senses)) : Optional.empty();
        sep.init(world, seek.wallSlider, oi, seekInfo, senses);
        Optional socialDist = getSocialDistance.apply(oi, sep, seekInfo);
        int seekOpts = 0;
        Vector3d[] unfilteredDirs = this.d_seek.getSeekDirs(world, oi, seekInfo, sep, seekOpts |= socialDist.map(SocialDistance::getSeekSampleOptions).orElse(0).intValue());
        if (oi.oa.getLoc().tri.getSpeedModifier().getTerrainSpeed() != 0.0 && oi.oa.getOcc().movingTerrainPref != EscalatorPreference.WALK && oi.oa.getOcc().movingTerrainPref != EscalatorPreference.STAND_ANYWHERE && seekInfo.seekDir != null) {
            ArrayList<Vector3d> filteredDirs = new ArrayList<Vector3d>();
            Vector3d seekDir = seekInfo.seekDir;
            Predicate<Double> filter = oi.oa.getOcc().movingTerrainPref == EscalatorPreference.STAND_LEFT ? theta -> theta > 0.0 : theta -> theta < 0.0;
            for (Vector3d v : unfilteredDirs) {
                double angle;
                if (v == null || !filter.test(angle = Util.sAngle2d(seekDir, v))) continue;
                filteredDirs.add(v);
            }
            sampleDirs = filteredDirs.toArray(new Vector3d[filteredDirs.size()]);
        } else {
            sampleDirs = unfilteredDirs;
        }
        Dir dir = this.getLowestCostDir(world, oi, seekInfo, sampleDirs, senses, sep, socialDist);
        InvSteerMeta currMeta = InvSteerUtil.getSteerMeta(agent);
        boolean bl = stuck = oi.oa.hasVehicle() && oi.oa.getVehicle().isStuckForAtLeast(world, 0.25) && (currMeta.tRaisedPriorityEnd == 0.0 || world.getCurrentSimTime() <= currMeta.tRaisedPriorityEnd);
        if (agent.hasVehicle()) {
            agent.getVehicle().setFreePass(false);
        }
        TriPredicate<Dir, OccInfo, SeekInfo> testHighPriority = (d, occInfo, si) -> !(!si.seeking || !stuck && d.avoidOccs.length <= 0 || !(world.getCurrentSimTime() >= currMeta.tRaisedPriorityBegin) || !stuck && !theUtil.eq0(d.speed * d.speed, 1.0E-6) && !theUtil.le0(d.dir.dot(si.seekDir), 1.0E-9) && !d.meta.isLaneLeader && !this.checkAngleToCurVel((Dir)d, occInfo.oa.getVel(), currMeta.tRaisedPriorityEnd, world.getCurrentSimTime()));
        TriPredicate<Dir, OccInfo, SeekInfo> isNoProgress = (d, occInfo, si) -> si.seeking && world.getCurrentSimTime() >= currMeta.tRaisedPriorityBegin && (stuck || theUtil.eq0(d.speed * d.speed, 1.0E-6) || theUtil.le0(d.dir.dot(si.seekDir), 1.0E-9) || this.checkAngleToCurVel((Dir)d, occInfo.oa.getVel(), currMeta.tRaisedPriorityEnd, world.getCurrentSimTime()));
        TriPredicate<Dir, OccInfo, SeekInfo> testTightGeom = (d, occInfo, si) -> occInfo.oa.hasTightGeomRepresentation() && (d.stuckOnWall || !testHighPriority.test((Dir)d, (OccInfo)occInfo, (SeekInfo)si)) && isNoProgress.test((Dir)d, (OccInfo)occInfo, (SeekInfo)si);
        boolean bl2 = extendStuckWalls = !Double.isNaN(currMeta.tStuckOnWallsBegin) && world.getCurrentSimTime() <= currMeta.tStuckOnWallsBegin + (double)oi.oa.getOcc().persistTime;
        if (oi.oa.hasTightGeomRepresentation() && (extendStuckWalls || testTightGeom.test(dir, oi, seekInfo))) {
            Dir avoidWallsDir;
            Pair gShapes = getGeomBodyShape.apply(agent, true);
            oi = new OccInfo(oi.oa, oi.shapeAgents, oi.squeezeFactor, (IAgentBodyShape)gShapes.v1, (IAgentBodyShape)gShapes.v2, oi.priority, oi.collisionFilter, oi.raisedPriorityFilter, oi.cache, true);
            seek = tightSeekCurve;
            senses.setWallSlider(seek.wallSlider);
            seekInfo = this.d_seek.getSeekInfo(world, oi, seek);
            sep.init(world, seek.wallSlider, oi, seekInfo, senses);
            dir = avoidWallsDir = this.getLowestCostDir(world, oi, seekInfo, sampleDirs, senses, sep, socialDist);
            stuckOnWallsBegin = !Double.isNaN(currMeta.tStuckOnWallsBegin) ? currMeta.tStuckOnWallsBegin : world.getCurrentSimTime();
        } else {
            stuckOnWallsBegin = Double.NaN;
        }
        boolean testHighPrior = testHighPriority.test(dir, oi, seekInfo);
        if (!testHighPrior || NO_HIGH_PRIORITY) {
            return new BestDir(seek, dir.dir, dir.speed, dir.priority, dir.squeezeFactor, dir.avoidOccs, dir.stuckOnWall, dir.collisionFilter, new InvSteerMeta(0.0, currMeta.tRaisedPriorityBegin, Filters.rejectAll(), senses.getMemory(), dir.meta.memento, !Double.isNaN(stuckOnWallsBegin), stuckOnWallsBegin, dir.meta.isLaneLeader), dir.orient);
        }
        AvoidOccs.FreePassResult fp = world.getCycleBreaker().isCycleBreaker(agent) && NavigateMesh.containsAny(world.getCycleBreaker().getCycleToBreak(agent), Arrays.asList(dir.avoidOccs)) ? AvoidOccs.FreePassResult.pass() : AvoidOccs.getFreePass(world, agent, senses, dir.avoidOccs, seekInfo, dir.meta.isLaneLeader);
        if (agent.hasVehicle()) {
            agent.getVehicle().setFreePass(fp.freePass);
        }
        BiPredicate<Vector3d, SeekInfo> getVecProgress = (d, si) -> theUtil.gt0(d.dot(si.seekDir), 1.0E-9);
        BiPredicate<Dir, SeekInfo> getDirProgress = (d, si) -> getVecProgress.test(d.dir, (SeekInfo)si) && theUtil.gt0(d.speed * d.speed, 1.0E-6);
        if (!fp.freePass) {
            if (stuck && agent.hasVehicle() && world.clipsBoundary(agent.getOcc(), oi.shapeGeom, 0.1 * oi.shapeGeom.getEnclosingRadius())) {
                AgentVehicle vagent = agent.getVehicle();
                vagent.setFreePass(true);
                geomShapes = getGeomBodyShape.apply(agent, oi.tightGeometry);
                oi = new OccInfo(oi.oa, oi.shapeAgents, oi.squeezeFactor, (IAgentBodyShape)geomShapes.v1, (IAgentBodyShape)geomShapes.v2, oi.priority, oi.collisionFilter, oi.raisedPriorityFilter, oi.cache, oi.tightGeometry);
                sampleDirs = this.d_seek.getSeekDirs(world, oi, seekInfo, sep, seekOpts);
                Dir raisedDir = this.getLowestCostDir(world, oi, seekInfo, sampleDirs, senses, sep, socialDist);
                if (getDirProgress.test(raisedDir, seekInfo)) {
                    return new BestDir(seek, raisedDir.dir, raisedDir.speed, raisedDir.priority, raisedDir.squeezeFactor, raisedDir.avoidOccs, raisedDir.stuckOnWall, raisedDir.collisionFilter, new InvSteerMeta(0.0, 0.0, oi.raisedPriorityFilter, senses.getMemory(), raisedDir.meta.memento, oi.tightGeometry, stuckOnWallsBegin, raisedDir.meta.isLaneLeader), raisedDir.orient);
                }
                vagent.setFreePass(false);
            }
            if (!agent.hasVehicle() && dir.squeezeFactor != 1.0) {
                double minFactor = oi.oa.getOcc().getCollisionFactor(dir.squeezeFactor);
                oi = new OccInfo(oi.oa, oi.oa.getCollisionShape(minFactor), dir.squeezeFactor, oi.shapeGeom, oi.shapeGeomDefault, oi.priority, oi.collisionFilter, oi.raisedPriorityFilter, oi.cache, oi.tightGeometry);
                sep = this.d_seek.getSeparation(world, oi);
                sep.init(world, seek.wallSlider, oi, seekInfo, senses);
                socialDist = getSocialDistance.apply(oi, sep, seekInfo);
                sampleDirs = this.d_seek.getSeekDirs(world, oi, seekInfo, sep, seekOpts |= socialDist.map(SocialDistance::getSeekSampleOptions).orElse(0).intValue());
                dir = this.getLowestCostDir(world, oi, seekInfo, sampleDirs, senses, sep, socialDist);
            }
            return new BestDir(seek, dir.dir, dir.speed, oi.priority, dir.squeezeFactor, new OccAgent[]{fp.avoidOcc}, dir.stuckOnWall, dir.collisionFilter, new InvSteerMeta(0.0, 0.0, Filters.rejectAll(), senses.getMemory(), dir.meta.memento, oi.tightGeometry, stuckOnWallsBegin, dir.meta.isLaneLeader), dir.orient);
        }
        double raisedPriority = OccPriority.raise(oi.priority);
        Predicate<OccAgent> collisionFilter = agent.getLastSteer() != null ? agent.getLastSteer().collisionFilter : Filters.acceptAll();
        Predicate<OccAgent> raisedPriorityFilter = NavigateMesh.getRaisedPriorityFilter(currMeta, new OccAgent[][]{dir.avoidOccs});
        QuadFunction<SeekCurve, Dir, OccInfo, OccAgent[], BestDir> getExtendPriorityDir = (seekCurve, d, occInfo, highCostOccs) -> new BestDir((SeekCurve)seekCurve, d.dir, d.speed, d.priority, d.squeezeFactor, d.avoidOccs, d.stuckOnWall, d.collisionFilter, new InvSteerMeta(world.getCurrentSimTime() + (double)agent.getOcc().persistTime, 0.0, NavigateMesh.getRaisedPriorityFilter(currMeta, new OccAgent[][]{highCostOccs}), senses.getMemory(), d.meta.memento, occInfo.tightGeometry, stuckOnWallsBegin, d.meta.isLaneLeader), d.orient);
        while (true) {
            releasePriority = (fseek, ldir, tightGeom) -> new BestDir((SeekCurve)fseek, ldir.dir, ldir.speed, ldir.priority, ldir.squeezeFactor, ldir.avoidOccs, ldir.stuckOnWall, ldir.collisionFilter, new InvSteerMeta(0.0, world.getCurrentSimTime() + (double)agent.getOcc().persistTime, Filters.rejectAll(), senses.getMemory(), ldir.meta.memento, (boolean)tightGeom, stuckOnWallsBegin, ldir.meta.isLaneLeader), ldir.orient);
            if (raisedPriority == agent.getOcc().priority && agent.getOcc().reEnteredDoorQueue) {
                return releasePriority.apply(seek, dir, oi.tightGeometry);
            }
            double minFactor = oi.oa.getOcc().getCollisionFactor(oi.oa.getOcc().minSqueezeFactor);
            geomShapes = getGeomBodyShape.apply(agent, oi.tightGeometry);
            oi = new OccInfo(oi.oa, oi.oa.getCollisionShape(minFactor), oi.oa.getOcc().minSqueezeFactor, (IAgentBodyShape)geomShapes.v1, (IAgentBodyShape)geomShapes.v2, raisedPriority, collisionFilter, raisedPriorityFilter, oi.cache, oi.tightGeometry);
            sep = this.d_seek.getSeparation(world, oi);
            sep.init(world, seek.wallSlider, oi, seekInfo, senses);
            socialDist = getSocialDistance.apply(oi, sep, seekInfo);
            sampleDirs = this.d_seek.getSeekDirs(world, oi, seekInfo, sep, 3);
            Dir raisedDir = this.getLowestCostDir(world, oi, seekInfo, sampleDirs, senses, sep, socialDist);
            OccAgent[] highOccs = dir.avoidOccs;
            if (agent.getOcc().priority != oi.priority || getDirProgress.test(raisedDir, seekInfo)) {
                return getExtendPriorityDir.apply(seek, raisedDir, oi, highOccs);
            }
            if (agent.getLastSteer() != null && world.getCurrentSimTime() < currMeta.tRaisedPriorityEnd) {
                Vector3d dirVec = oi.oa.getOcc().bodyShape instanceof PolygonShape ? dir.dir : new Vector3d(0.0, 0.0, 0.0);
                return new BestDir(seek, dirVec, 0.0, raisedDir.priority, raisedDir.squeezeFactor, raisedDir.avoidOccs, raisedDir.stuckOnWall, raisedDir.collisionFilter, new InvSteerMeta(currMeta.tRaisedPriorityEnd, 0.0, NavigateMesh.getRaisedPriorityFilter(currMeta, new OccAgent[][]{highOccs}), senses.getMemory(), raisedDir.meta.memento, oi.tightGeometry, stuckOnWallsBegin, raisedDir.meta.isLaneLeader), raisedDir.orient);
            }
            if (!Filters.alwaysTrue(collisionFilter) || dir.avoidOccs.length <= 0) break;
            if (KB.DEBUG_STEERING) {
                System.out.printf("Occupant stuck - becoming non-corporeal: t=%g, occ=%s%n", world.getCurrentSimTime(), agent.getOcc().name);
            }
            collisionFilter = Filters.reject(dir.avoidOccs);
        }
        return releasePriority.apply(seek, dir, oi.tightGeometry);
    }

    private boolean checkAngleToCurVel(Dir dir, Vector3d vel, double tRaisedPriorityEnd, double currTime) {
        if (tRaisedPriorityEnd < currTime) {
            return false;
        }
        if (theUtil.eq(vel.length(), 0.0, 1.0E-6)) {
            return false;
        }
        Vector3d desVel = new Vector3d(dir.dir);
        Vector3d curVel = new Vector3d(vel);
        desVel.normalize();
        curVel.normalize();
        double angle = desVel.dot(curVel);
        return theUtil.le(angle, Math.cos(0.39269908169872414), 1.0E-6);
    }

    private static boolean containsAny(Collection<?> c1, Collection<?> c2) {
        for (Object o : c2) {
            if (!c1.contains(o)) continue;
            return true;
        }
        return false;
    }

    private static Predicate<OccAgent> getRaisedPriorityFilter(InvSteerMeta currMeta, OccAgent[] ... avoidOccs) {
        ArrayList<OccAgent> allAvoid = new ArrayList<OccAgent>();
        if (avoidOccs.length > 0) {
            allAvoid.addAll(Arrays.asList(avoidOccs[0]));
            for (int m = 1; m < avoidOccs.length; ++m) {
                for (OccAgent a : avoidOccs[m]) {
                    if (allAvoid.contains(a)) continue;
                    allAvoid.add(a);
                }
            }
        }
        Predicate<OccAgent> rpFilter = Filters.accept(allAvoid);
        rpFilter = Filters.or(rpFilter, currMeta.raisedPriorityFilter);
        return rpFilter;
    }

    private double getSpeedFromDensity(KB kb, OccInfo oi, Vector3d preferredDir, Senses senses, SeekInfo seekInfo) {
        Vector2d pdir2d;
        double dirLen;
        if (seekInfo.seekDir == null) {
            return oi.cache.maxVel;
        }
        if (preferredDir == null) {
            preferredDir = seekInfo.seekCurve.getTangent(0.0);
        }
        if ((dirLen = Util2D.safeNormalize(pdir2d = new Vector2d(preferredDir.x, preferredDir.y), 1.0E-9)) == 0.0) {
            return oi.cache.maxVel;
        }
        Collection<OccAgent> nearOccs = senses.getNearOccs(-1348979970, oi);
        ArrayList<Pair<OccAgent, Point3d>> nearPos = new ArrayList<Pair<OccAgent, Point3d>>();
        for (OccAgent occ : InvSteerUtil.getOccsAffectingDensity(kb, oi.oa, seekInfo, senses, nearOccs)) {
            nearPos.add(new Pair<OccAgent, Point3d>(occ, occ.getPos()));
        }
        double maxDensity = InvSteerUtil.getDensityFromSpacing((KB)kb, (OccInfo)oi, (Point3d)oi.oa.getPos(), (Vector2d)pdir2d, nearPos).density;
        return maxDensity == 0.0 ? oi.cache.maxVel : OccAgent.getMaxVel(kb, oi.oa.getOcc(), maxDensity, preferredDir);
    }

    private Dir getLowestCostDir(KB world, OccInfo oi, SeekInfo seekInfo, Vector3d[] sampleDirs, Senses senses, IdleSeparation sep, Optional<SocialDistance> socialDist) {
        if (Double.isNaN(AvoidOccs.IGNORE_IF_DOMINANT) || seekInfo.seekDir == null) {
            return this.getLowestCostDirOriginal(world, oi, seekInfo, sampleDirs, senses, sep, socialDist);
        }
        return this.getLowestCostDirUsingDominance(world, oi, seekInfo, sampleDirs, senses, sep);
    }

    private Dir getLowestCostDirOriginal(KB world, OccInfo oi, SeekInfo seekInfo, Vector3d[] sampleDirections, Senses senses, IdleSeparation sep, Optional<SocialDistance> socialDist) {
        double squeezeFactor;
        Consumer<Boolean> hcWalls;
        Predicate<OccAgent> sepFilter;
        PassBehavior pass;
        AvoidObstacles ab;
        AvoidOccs ao;
        BehaviorWeights weights;
        List<Vector3d> sampleDirs = Arrays.asList(sampleDirections);
        if (!sep.isSeparating()) {
            Vector3d dir2 = oi.cache.currVel > 0.0 ? oi.oa.getVel() : seekInfo.seekCurve.getTangent(0.0);
            double maxSpeed = this.getSpeedFromDensity(world, oi, dir2, senses, seekInfo);
            if (maxSpeed == 0.0) {
                return this.getNoMovementDir(world, oi.oa, null, oi.collisionFilter);
            }
            oi = new OccInfo(oi.oa, oi.shapeAgents, oi.squeezeFactor, oi.shapeGeom, oi.shapeGeomDefault, oi.priority, oi.collisionFilter, oi.raisedPriorityFilter, new OccInfo.CachedData(maxSpeed, oi.cache.currVel), oi.tightGeometry);
        }
        OccInfo foi = oi;
        boolean isSocialDistancing = socialDist.map(SocialDistance::isDistancing).orElse(false);
        for (ICostCalc cc : this.d_additionalCalcs) {
            cc.init(world, oi, seekInfo, senses);
        }
        boolean raisedPriority = OccPriority.isLocallyHighest(oi.priority);
        ISeekCalc seek = !sep.isSeparating() ? this.d_seek : null;
        BehaviorWeights behaviorWeights = weights = seek != null ? seek.getWeights(world, oi, isSocialDistancing) : new BehaviorWeights(oi.oa, oi.oa.getOcc().bodyShape, isSocialDistancing);
        LaneBehavior lb = weights.laneBehavior != 0.0 && seekInfo.seekDir != null ? new LaneBehavior(world, oi, senses, seekInfo, !sep.isSeparating()) : null;
        boolean isLaneLeader = false;
        CornerBehavior cb = weights.cornerBehavior != 0.0 && (lb == null || !lb.isInCounterFlow()) ? new CornerBehavior(world, oi, seekInfo, senses) : null;
        AvoidOccs avoidOccs = ao = weights.avoidOccs != 0.0 ? new AvoidOccs(world, oi, senses, seekInfo, sep.getSepDist(), true, isSocialDistancing) : null;
        SeekSeparation seekSep = seekInfo.seekDir != null && !sep.isSeparating() && oi.cache.currVel > 0.0 && weights.seekSep != 0.0 ? new SeekSeparation(world, oi, seekInfo, senses, socialDist.isPresent() ? nearocc -> !((SocialDistance)socialDist.get()).separateFrom(world, foi, (OccAgent)nearocc) : Predicates.alwaysTrue()) : null;
        SeekWallSeparation seekWallSep = seekInfo.seekDir != null && !sep.isSeparating() && oi.cache.currVel > 0.0 && !raisedPriority && weights.seekWallSep != 0.0 ? new SeekWallSeparation(world, oi, seekInfo, senses) : null;
        AvoidWalls aw = weights.avoidWalls != 0.0 ? new AvoidWalls(world, oi, senses, seekInfo) : null;
        AvoidObstacles avoidObstacles = ab = weights.avoidObstacles != 0.0 && world.hasImpedingTris() && senses.hasNearbyHazards(world, oi) ? new AvoidObstacles(world, oi, senses, seekInfo) : null;
        PassBehavior passBehavior = weights.pass != 0.0 && PassBehavior.isNeeded(world, oi, seekInfo, senses, lb != null && lb.isInCounterFlow(), isSocialDistancing) ? new PassBehavior() : (pass = null);
        if (oi.oa.hasVehicle()) {
            sepFilter = Filters.reject(sep.getInfluencingOccs());
        } else {
            Predicate<Object> predicate = sepFilter = sep.isSeparating() ? Predicates.alwaysFalse() : Predicates.alwaysTrue();
        }
        if (sampleDirs.get(0) != null && sep.isSeparating() && sep.getMoveVec().lengthSquared() > 0.0) {
            ArrayList<Vector3d> newSampleDirs = new ArrayList<Vector3d>(sampleDirs.size() + 1);
            newSampleDirs.add(sampleDirs.get(0));
            newSampleDirs.add(new Vector3d(sep.getMoveVec()));
            Util3D.safeNormalize((Vector3d)newSampleDirs.get(1), 1.0E-9);
            newSampleDirs.addAll(sampleDirs.subList(1, sampleDirs.size()));
            sampleDirs = newSampleDirs;
        }
        sampleDirs = this.addVehicleDirs(world, oi, sampleDirs, lb != null && lb.isInCounterFlow());
        Vector3d preferredDir = sampleDirs.get(0);
        boolean polygonFreePass = oi.oa.hasVehicle() ? oi.oa.getVehicle().getFreePass() : false;
        CostAccum costAccum = new CostAccum(oi, preferredDir);
        Vector3d bestDir = null;
        Function<Vector3d, Vector3d> adjustDir = dir -> {
            Vector3d adjustedDir = AvoidWalls.adjustDir(world, foi.oa, senses, dir);
            if (!adjustedDir.epsilonEquals((Tuple3d)dir, 1.0E-6) && (adjustedDir.lengthSquared() == 0.0 || seek != null && !seek.isDirectionAllowed(world, foi.oa, preferredDir, adjustedDir))) {
                return null;
            }
            return adjustedDir;
        };
        ArrayList<Vector3d> adjustedDirs = new ArrayList<Vector3d>(sampleDirs.size());
        for (int m = 0; m < sampleDirs.size(); ++m) {
            Vector3d dir3 = sampleDirs.get(m);
            if (dir3 == null) {
                adjustedDirs.add(null);
                continue;
            }
            Vector3d adjustedDir = adjustDir.apply(dir3);
            if (adjustedDir != null) {
                adjustedDirs.add(adjustedDir);
                continue;
            }
            if (m != 0) continue;
            costAccum.newDir(oi, dir3, true);
            hcWalls = costAccum.getHighCostWallConsumer();
            if (hcWalls == null) continue;
            hcWalls.accept(true);
        }
        sampleDirs = adjustedDirs;
        if (socialDist.isPresent()) {
            socialDist.get().init(world, oi, senses, seekInfo, sampleDirs);
        }
        block2: for (int m = 0; m < sampleDirs.size(); ++m) {
            Object[] abCost;
            double[] cbCost;
            double[] lbCost;
            double[] aoCost;
            double[] sepCost;
            double[] passCost;
            double[] seekWallSepCost;
            double[] cost;
            double[] seekSepCost;
            double[] seekCost;
            Vector3d dir4 = sampleDirs.get(m);
            OccInfo diroi = oi;
            costAccum.newDir(diroi, dir4, m == 0);
            if (seek != null && !costAccum.add(NavigateMeshData.Behavior.SEEK, weights.seek, seekCost = seek.getCost(world, diroi, senses, seekInfo, preferredDir, dir4))) continue;
            Consumer<OccAgent> hcOccs = costAccum.getHighCostOccConsumer();
            hcWalls = costAccum.getHighCostWallConsumer();
            if (seekSep != null && !costAccum.add(NavigateMeshData.Behavior.SEEKSEP, weights.seekSep, seekSepCost = seekSep.getCost(world, diroi, senses, seekInfo, dir4, isSocialDistancing, hcOccs)) || socialDist.isPresent() && !costAccum.add(NavigateMeshData.Behavior.SOCIALDIST, weights.socialDist, cost = socialDist.get().getCost(world, diroi, senses, seekInfo, dir4, hcOccs)) || seekWallSep != null && !costAccum.add(NavigateMeshData.Behavior.SEEKWALLSEP, weights.seekWallSep, seekWallSepCost = seekWallSep.getCost(world, diroi, senses, seekInfo, dir4, isSocialDistancing)) || pass != null && !costAccum.add(NavigateMeshData.Behavior.PASS, weights.pass, passCost = pass.getCost(world, diroi, senses, seekInfo, dir4, hcOccs)) || sep.isSeparating() && !costAccum.add(NavigateMeshData.Behavior.SEP, 1.0, sepCost = sep.getCost(world, diroi, senses, seekInfo, dir4, hcOccs))) continue;
            if (aw != null) {
                double[] awCost = aw.getCost(world, diroi, senses, seekInfo, sep.isSeparating(), dir4, m == 0);
                if (hcWalls != null && theUtil.eq(awCost[0], 1.0, 1.0E-6)) {
                    hcWalls.accept(true);
                }
                if ((!costAccum.add(NavigateMeshData.Behavior.AVOIDWALLS, weights.avoidWalls, awCost) || awCost[0] >= 1.0 && !polygonFreePass) && !oi.oa.hasVehicle()) continue;
            }
            if (ao != null && (aoCost = ao.getCost(world, diroi, senses, seekInfo, dir4, sepFilter, sep.getSepDist(), hcOccs)) != null && !costAccum.add(NavigateMeshData.Behavior.AVOIDOCCS, weights.avoidOccs, aoCost)) continue;
            if (lb != null && (lbCost = lb.getCost(world, diroi, senses, seekInfo, dir4)) != null) {
                isLaneLeader = lb.isLaneLeader();
                if (costAccum.navMeshData != null) {
                    world.getProps().setDbg(oi.oa.getOcc(), "LANE_BEHAVIOR", lb);
                }
                if (!costAccum.add(NavigateMeshData.Behavior.LANEBEHAVIOR, weights.laneBehavior, lbCost)) continue;
            }
            if (cb != null && (cbCost = cb.getCost(dir4, diroi, seekInfo, !sep.isSeparating(), sep.getSepDist(), preferredDir)) != null && !costAccum.add(NavigateMeshData.Behavior.CORNERBEHAVIOR, weights.cornerBehavior, cbCost) || ab != null && (abCost = (Object[])ab.getCost(world, diroi, senses, seekInfo, sep.isSeparating(), dir4, m == 0)) != null && !costAccum.add(NavigateMeshData.Behavior.AVOIDOBSTACLES, weights.avoidObstacles, (double[])abCost)) continue;
            abCost = this.d_additionalCalcs;
            int n = abCost.length;
            for (int i = 0; i < n; ++i) {
                ICostCalc cc = abCost[i];
                double[] ccCost = cc.getCost(world, diroi.oa, senses, seekInfo, dir4);
                if (!costAccum.add(NavigateMeshData.Behavior.ADDITIONAL, 1.0, ccCost)) continue block2;
            }
            costAccum.record(m);
            bestDir = dir4;
            if (costAccum.dirCost <= 0.01) break;
        }
        costAccum.finalizeData(world);
        world.getProps().setDbgFunc(oi.oa.getOcc(), "COUNTERFLOWING", () -> {
            if (lb != null && lb.isInCounterFlow()) {
                return Integer.valueOf(!lb.isLaneLeader() ? 1 : 2);
            }
            return Integer.valueOf(0);
        });
        if (bestDir == null) {
            bestDir = new Vector3d(0.0, 0.0, 0.0);
        }
        Collection<OccAgent> highCostOccs = costAccum.bestHCOccs;
        boolean highCostWall = costAccum.bestHighCostWall;
        boolean squeeze = NavigateMesh.shouldSqueeze(world, oi, senses, seekInfo, preferredDir, sep, highCostOccs);
        double d = squeezeFactor = squeeze ? (double)oi.oa.getOcc().minSqueezeFactor : 1.0;
        if (sep.isSeparating() && preferredDir != null && (theUtil.lt0(bestDir.dot(preferredDir), 1.0E-9) || costAccum.bestTravelSpeed == 0.0)) {
            highCostOccs = new ListSet<OccAgent>(highCostOccs);
            highCostOccs.addAll(sep.getInfluencingOccs());
        }
        InvSteerMeta meta = new InvSteerMeta(0.0, 0.0, null, null, new InvSteerMeta.Memento(sep.isSeparating()), oi.tightGeometry, Double.NaN, isLaneLeader);
        return new Dir(bestDir, costAccum.bestTravelSpeed, oi.priority, squeezeFactor, theUtil.toArray(highCostOccs, OccAgent.class), highCostWall, oi.collisionFilter, meta, aw != null ? aw.getGoalOrient(bestDir) : bestDir);
    }

    private Dir getLowestCostDirUsingDominance(KB world, OccInfo oi, SeekInfo seekInfo, Vector3d[] sampleDirs, Senses senses, IdleSeparation sep) {
        Collection<OccAgent> highCostOccs;
        boolean squeeze;
        double squeezeFactor;
        Object hcOccs;
        Predicate<OccAgent> sepFilter;
        PassBehavior pass;
        AvoidWalls aw;
        BehaviorWeights weights;
        if (!sep.isSeparating()) {
            Vector3d dir = oi.cache.currVel > 0.0 ? oi.oa.getVel() : seekInfo.seekCurve.getTangent(0.0);
            double maxSpeed = this.getSpeedFromDensity(world, oi, dir, senses, seekInfo);
            if (maxSpeed == 0.0) {
                return this.getNoMovementDir(world, oi.oa, null, oi.collisionFilter);
            }
            oi = new OccInfo(oi.oa, oi.shapeAgents, oi.squeezeFactor, oi.shapeGeom, oi.shapeGeomDefault, oi.priority, oi.collisionFilter, oi.raisedPriorityFilter, new OccInfo.CachedData(maxSpeed, oi.cache.currVel), oi.tightGeometry);
        }
        boolean isSocialDistancing = false;
        for (ICostCalc cc : this.d_additionalCalcs) {
            cc.init(world, oi, seekInfo, senses);
        }
        boolean raisedPriority = OccPriority.isLocallyHighest(oi.priority);
        ISeekCalc seek = !sep.isSeparating() ? this.d_seek : null;
        BehaviorWeights behaviorWeights = weights = seek != null ? seek.getWeights(world, oi, isSocialDistancing) : new BehaviorWeights(oi.oa, oi.oa.getOcc().bodyShape, isSocialDistancing);
        LaneBehavior lb = weights.laneBehavior != 0.0 && seekInfo.seekDir != null ? new LaneBehavior(world, oi, senses, seekInfo, !sep.isSeparating()) : null;
        boolean isLaneLeader = false;
        CornerBehavior cb = weights.cornerBehavior != 0.0 && (lb == null || !lb.isInCounterFlow()) ? new CornerBehavior(world, oi, seekInfo, senses) : null;
        AvoidOccs ao = weights.avoidOccs != 0.0 ? new AvoidOccs(world, oi, senses, seekInfo, sep.getSepDist(), true, isSocialDistancing) : null;
        SeekSeparation seekSep = seekInfo.seekDir != null && !sep.isSeparating() && oi.cache.currVel > 0.0 && weights.seekSep != 0.0 ? new SeekSeparation(world, oi, seekInfo, senses, Predicates.alwaysTrue()) : null;
        SeekWallSeparation seekWallSep = seekInfo.seekDir != null && !sep.isSeparating() && oi.cache.currVel > 0.0 && !raisedPriority && weights.seekWallSep != 0.0 ? new SeekWallSeparation(world, oi, seekInfo, senses) : null;
        AvoidWalls avoidWalls = aw = weights.avoidWalls != 0.0 ? new AvoidWalls(world, oi, senses, seekInfo) : null;
        PassBehavior passBehavior = weights.pass != 0.0 && PassBehavior.isNeeded(world, oi, seekInfo, senses, lb != null && lb.isInCounterFlow(), isSocialDistancing) ? new PassBehavior() : (pass = null);
        if (oi.oa.hasVehicle()) {
            sepFilter = Filters.reject(sep.getInfluencingOccs());
        } else {
            Predicate<Object> predicate = sepFilter = sep.isSeparating() ? Predicates.alwaysFalse() : Predicates.alwaysTrue();
        }
        if (sampleDirs[0] != null && sep.isSeparating() && sep.getMoveVec().lengthSquared() > 0.0) {
            Vector3d[] newSampleDirs = new Vector3d[sampleDirs.length + 1];
            newSampleDirs[0] = sampleDirs[0];
            newSampleDirs[1] = sep.getMoveVec();
            Util3D.safeNormalize(newSampleDirs[1], 1.0E-9);
            for (int m = 1; m < sampleDirs.length; ++m) {
                newSampleDirs[m + 1] = sampleDirs[m];
            }
            sampleDirs = newSampleDirs;
        }
        sampleDirs = theUtil.toArray(this.addVehicleDirs(world, oi, Arrays.asList(sampleDirs), lb != null && lb.isInCounterFlow()), Vector3d.class);
        Vector3d preferredDir = sampleDirs[0];
        boolean polygonFreePass = oi.oa.hasVehicle() ? oi.oa.getVehicle().getFreePass() : false;
        double[][] avoidOccsCosts = new double[sampleDirs.length][];
        List[] aoHighCostOccs = new List[sampleDirs.length];
        if (ao != null) {
            ArrayList<Integer> leftRays = new ArrayList<Integer>();
            ArrayList<Integer> rightRays = new ArrayList<Integer>();
            double[] highCosts = new double[]{0.0, 0.0};
            for (int m = 0; m < sampleDirs.length; ++m) {
                boolean crossflow;
                Vector3d dir = sampleDirs[m];
                aoHighCostOccs[m] = hcOccs = new ArrayList();
                if (dir != null) {
                    Vector3d adjustedDir = AvoidWalls.adjustDir(world, oi.oa, senses, dir);
                    if (!adjustedDir.epsilonEquals(dir, 1.0E-6) && (adjustedDir.lengthSquared() == 0.0 || seek != null && !seek.isDirectionAllowed(world, oi.oa, preferredDir, adjustedDir))) continue;
                    dir = adjustedDir;
                }
                OccInfo diroi = oi;
                double[] aoCost = ao.getCost(world, diroi, senses, seekInfo, dir, sepFilter, sep.getSepDist(), ((List)hcOccs)::add);
                avoidOccsCosts[m] = aoCost;
                if (sampleDirs[0] == null) continue;
                if (!hcOccs.isEmpty() && seekInfo.seekDir != null && (crossflow = hcOccs.stream().anyMatch(oa -> senses.getFlow(world, diroi.oa, seekInfo, (OccAgent)oa, Senses.getSeekDir(oa)) == Senses.Flow.CROSS))) {
                    int travelSide = -1;
                    Iterator iterator = hcOccs.iterator();
                    while (iterator.hasNext()) {
                        OccAgent otherOcc = (OccAgent)iterator.next();
                        Vector3d otherVel = InvSteerUtil.getCollisionVel(otherOcc);
                        Vector3d dirCross = Util3D.cross(sampleDirs[0], otherVel);
                        double dot = dirCross.dot(GeomConstants.VEC3D_ZPOS);
                        int comp = theUtil.compare(dot, 0.0, 1.0E-6);
                        if (comp == 0) continue;
                        int n = travelSide = comp > 0 ? 0 : 1;
                        break;
                    }
                    if (travelSide != -1 && aoCost[0] > highCosts[travelSide]) {
                        highCosts[travelSide] = aoCost[0];
                    }
                }
                if (m == 0 || dir == null) continue;
                Vector3d dirCross = Util3D.cross(sampleDirs[0], dir);
                double dot = dirCross.dot(GeomConstants.VEC3D_ZPOS);
                if (theUtil.gt0(dot, 1.0E-6)) {
                    leftRays.add(m);
                    continue;
                }
                rightRays.add(m);
            }
            BiConsumer<Double, List> assignCostsToSide = (hcost, ixes) -> {
                if (hcost == 0.0 || ixes.isEmpty()) {
                    return;
                }
                hcost = hcost * AvoidOccs.IGNORE_IF_DOMINANT;
                Iterator iterator = ixes.iterator();
                while (iterator.hasNext()) {
                    int oix = (Integer)iterator.next();
                    double[] ocost = avoidOccsCosts[oix];
                    if (!(hcost > ocost[0])) continue;
                    ocost[0] = hcost;
                }
            };
            assignCostsToSide.accept(highCosts[1], rightRays);
            assignCostsToSide.accept(highCosts[0], leftRays);
        }
        CostAccum costAccum = new CostAccum(oi, preferredDir);
        Vector3d bestDir = null;
        block4: for (int m = 0; m < sampleDirs.length; ++m) {
            Object[] cbCost;
            double[] lbCost;
            double[] awCost;
            double[] sepCost;
            double[] passCost;
            double[] seekWallSepCost;
            double[] seekSepCost;
            double[] seekCost;
            Vector3d dir = sampleDirs[m];
            if (dir != null) {
                Vector3d adjustedDir = AvoidWalls.adjustDir(world, oi.oa, senses, dir);
                if (!adjustedDir.epsilonEquals(dir, 1.0E-6) && (adjustedDir.lengthSquared() == 0.0 || seek != null && !seek.isDirectionAllowed(world, oi.oa, preferredDir, adjustedDir))) continue;
                dir = adjustedDir;
            }
            OccInfo diroi = oi;
            costAccum.newDir(diroi, dir, m == 0);
            hcOccs = costAccum.getHighCostOccConsumer();
            if (ao != null) {
                double[] aoCost = avoidOccsCosts[m];
                List hcoccs = aoHighCostOccs[m];
                if (hcOccs != null) {
                    hcoccs.forEach(hcOccs);
                }
                if (aoCost != null && !costAccum.add(NavigateMeshData.Behavior.AVOIDOCCS, weights.avoidOccs, aoCost)) continue;
            }
            if (seek != null && !costAccum.add(NavigateMeshData.Behavior.SEEK, weights.seek, seekCost = seek.getCost(world, diroi, senses, seekInfo, preferredDir, dir)) || seekSep != null && !costAccum.add(NavigateMeshData.Behavior.SEEKSEP, weights.seekSep, seekSepCost = seekSep.getCost(world, diroi, senses, seekInfo, dir, isSocialDistancing, (Consumer<OccAgent>)hcOccs)) || seekWallSep != null && !costAccum.add(NavigateMeshData.Behavior.SEEKWALLSEP, weights.seekWallSep, seekWallSepCost = seekWallSep.getCost(world, diroi, senses, seekInfo, dir, isSocialDistancing)) || pass != null && !costAccum.add(NavigateMeshData.Behavior.PASS, weights.pass, passCost = pass.getCost(world, diroi, senses, seekInfo, dir, (Consumer<OccAgent>)hcOccs)) || sep.isSeparating() && !costAccum.add(NavigateMeshData.Behavior.SEP, 1.0, sepCost = sep.getCost(world, diroi, senses, seekInfo, dir, (Consumer<OccAgent>)hcOccs)) || aw != null && (!costAccum.add(NavigateMeshData.Behavior.AVOIDWALLS, weights.avoidWalls, awCost = aw.getCost(world, diroi, senses, seekInfo, sep.isSeparating(), dir, m == 0)) || awCost[0] >= 1.0 && !polygonFreePass) && !oi.oa.hasVehicle()) continue;
            if (lb != null && (lbCost = lb.getCost(world, diroi, senses, seekInfo, dir)) != null) {
                isLaneLeader = lb.isLaneLeader();
                if (costAccum.navMeshData != null) {
                    world.getProps().setDbg(oi.oa.getOcc(), "LANE_BEHAVIOR", lb);
                }
                if (!costAccum.add(NavigateMeshData.Behavior.LANEBEHAVIOR, weights.laneBehavior, lbCost)) continue;
            }
            if (cb != null && (cbCost = (Object[])cb.getCost(dir, diroi, seekInfo, !sep.isSeparating(), sep.getSepDist(), preferredDir)) != null && !costAccum.add(NavigateMeshData.Behavior.CORNERBEHAVIOR, weights.cornerBehavior, (double[])cbCost)) continue;
            cbCost = this.d_additionalCalcs;
            int n = cbCost.length;
            for (int i = 0; i < n; ++i) {
                ICostCalc cc = cbCost[i];
                double[] ccCost = cc.getCost(world, diroi.oa, senses, seekInfo, dir);
                if (!costAccum.add(NavigateMeshData.Behavior.ADDITIONAL, 1.0, ccCost)) continue block4;
            }
            costAccum.record(m);
            bestDir = dir;
            if (costAccum.dirCost <= 0.01) break;
        }
        costAccum.finalizeData(world);
        world.getProps().setDbgFunc(oi.oa.getOcc(), "COUNTERFLOWING", () -> {
            if (lb != null && lb.isInCounterFlow()) {
                return Integer.valueOf(!lb.isLaneLeader() ? 1 : 2);
            }
            return Integer.valueOf(0);
        });
        if (bestDir == null) {
            bestDir = new Vector3d(0.0, 0.0, 0.0);
        }
        double d = squeezeFactor = (squeeze = NavigateMesh.shouldSqueeze(world, oi, senses, seekInfo, preferredDir, sep, highCostOccs = costAccum.bestHCOccs)) ? (double)oi.oa.getOcc().minSqueezeFactor : 1.0;
        if (sep.isSeparating() && preferredDir != null && (theUtil.lt0(bestDir.dot(preferredDir), 1.0E-9) || costAccum.bestTravelSpeed == 0.0)) {
            highCostOccs = new ListSet<OccAgent>(highCostOccs);
            highCostOccs.addAll(sep.getInfluencingOccs());
        }
        InvSteerMeta meta = new InvSteerMeta(0.0, 0.0, null, null, new InvSteerMeta.Memento(sep.isSeparating()), oi.tightGeometry, Double.NaN, isLaneLeader);
        return new Dir(bestDir, costAccum.bestTravelSpeed, oi.priority, squeezeFactor, theUtil.toArray(highCostOccs, OccAgent.class), false, oi.collisionFilter, meta, aw != null ? aw.getGoalOrient(bestDir) : bestDir);
    }

    private List<Vector3d> addVehicleDirs(KB kb, OccInfo oi, List<Vector3d> sampleDirs, boolean isInCounterFlow) {
        if (oi.oa.hasVehicle()) {
            boolean add = isInCounterFlow && !oi.oa.getVehicle().isStuckForAtLeast(kb, 2.5);
            ArrayList<Vector3d> newDirs = new ArrayList<Vector3d>(sampleDirs.size() + 1);
            if (add) {
                newDirs.addAll(sampleDirs);
                Vector3d backupStraight = new Vector3d(oi.oa.getDirFacing());
                backupStraight.negate();
                newDirs.add(backupStraight);
                return newDirs;
            }
            return sampleDirs;
        }
        return sampleDirs;
    }

    private static Vector3d[] addDirs(OccInfo oi, SeekInfo seek, int skipCount, Vector3d[] dirs, Collection<Vector3d> toAdd) {
        if (toAdd.isEmpty()) {
            return dirs;
        }
        ArrayList<Vector3d> newDirs = new ArrayList<Vector3d>(dirs.length + toAdd.size());
        newDirs.addAll(Arrays.asList(dirs).subList(skipCount, dirs.length));
        newDirs.addAll(toAdd);
        if (seek.seeking) {
            Collections.sort(newDirs, (v1, v2) -> {
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                double dot1 = Util.dot2d(v1, seek.seekDir);
                double dot2 = Util.dot2d(v2, seek.seekDir);
                return Double.compare(dot1, dot2);
            });
        }
        newDirs.addAll(0, Arrays.asList(dirs).subList(0, skipCount));
        return theUtil.toArray(newDirs, Vector3d.class);
    }

    private static boolean shouldSqueeze(KB world, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d prefDir, IdleSeparation sep, Collection<OccAgent> highCostOccs) {
        Collection[] highPriorTestAgents;
        if (OccPriority.isLocallyHighest(oi.priority)) {
            return true;
        }
        for (Collection otherOccs : highPriorTestAgents = new Collection[]{sep.getInfluencingOccs(), highCostOccs}) {
            for (OccAgent otherOcc : otherOccs) {
                if (InvSteerUtil.compare(world, oi, otherOcc) <= 0) continue;
                return true;
            }
        }
        if (oi.oa.isWaiting(world) || seekInfo.seekDir == null || prefDir == null) {
            for (Collection otherOccs : highPriorTestAgents) {
                for (OccAgent otherOcc : otherOccs) {
                    if (otherOcc.isWaiting(world) || InvSteerUtil.getYieldToIdler(world, otherOcc, oi.oa)) continue;
                    return true;
                }
            }
            return false;
        }
        int nearbyCount = 0;
        int crossCount = 0;
        boolean hasMergeOccs = false;
        for (Collection otherOccs : highPriorTestAgents) {
            nearbyCount += otherOccs.size();
            for (OccAgent otherOcc : otherOccs) {
                if (otherOcc.isWaiting(world) && !InvSteerUtil.getYieldToIdler(world, oi.oa, otherOcc) || InvSteerUtil.compare(world, oi, otherOcc) != 0) continue;
                Senses.Flow flow = NavigateMesh.getFlow(world, oi, senses, seekInfo, otherOcc);
                switch (flow) {
                    case MERGE: {
                        hasMergeOccs = true;
                        break;
                    }
                    case FLOW: {
                        hasMergeOccs = true;
                        break;
                    }
                    case OBSTRUCT: {
                        return true;
                    }
                    case COUNTER: {
                        return true;
                    }
                    case CROSS: {
                        ++crossCount;
                    }
                }
            }
        }
        return !hasMergeOccs && nearbyCount != 0 && nearbyCount != crossCount;
    }

    private static Senses.Flow getFlow(KB kb, OccInfo oi, Senses senses, SeekInfo seek, OccAgent agent2) {
        if (agent2.isWaiting(kb)) {
            return Senses.Flow.OBSTRUCT;
        }
        Vector3d dir2 = Senses.getSeekDir(agent2);
        return senses.getFlow(kb, oi.oa, seek, agent2, dir2);
    }

    private static class BestDir
    extends Dir {
        public final SeekCurve seek;

        public BestDir(SeekCurve seek, Vector3d dir, double speed, double priority, double squeezeFactor, OccAgent[] avoidOccs, boolean stuckOnWall, Predicate<OccAgent> collisionFilter, InvSteerMeta meta, Vector3d orient) {
            super(dir, speed, priority, squeezeFactor, avoidOccs, stuckOnWall, collisionFilter, meta, orient);
            this.seek = seek;
        }
    }

    private static class Dir {
        public final Vector3d dir;
        public final double speed;
        public final double priority;
        public final OccAgent[] avoidOccs;
        public final boolean stuckOnWall;
        public final double squeezeFactor;
        public final InvSteerMeta meta;
        public final Predicate<OccAgent> collisionFilter;
        public Vector3d orient;

        public Dir(Vector3d dir, double speed, double priority, double squeezeFactor, OccAgent[] avoidOccs, boolean stuckOnWall, Predicate<OccAgent> collisionFilter, InvSteerMeta meta, Vector3d orient) {
            this.dir = dir;
            this.speed = speed;
            this.priority = priority;
            this.avoidOccs = avoidOccs;
            this.stuckOnWall = stuckOnWall;
            this.squeezeFactor = squeezeFactor;
            this.collisionFilter = collisionFilter;
            this.meta = meta;
            this.orient = orient;
        }

        public String toString() {
            return this.dir != null ? String.format("%s @ %g m/s", this.dir.toString(), this.speed) : "stopped";
        }
    }

    private static interface TriPredicate<T, U, V> {
        public boolean test(T var1, U var2, V var3);
    }

    private static class CostAccum {
        public final OccInfo oi;
        public double bestCost;
        public double bestTravelSpeed;
        public Collection<OccAgent> bestHCOccs = Collections.emptySet();
        public Set<OccAgent> allHCOccs = new ListSet<OccAgent>(2);
        public boolean bestHighCostWall = false;
        public boolean highCostWall = false;
        public Vector3d dir;
        public double dirCost;
        public double dirTravelSpeed;
        public NavigateMeshData navMeshData;
        private final Vector3d d_preferredDir;
        private boolean recordHC = true;
        private boolean recordHCWalls = false;

        public CostAccum(OccInfo oi, Vector3d preferredDir) {
            this.oi = oi;
            this.d_preferredDir = preferredDir;
            this.bestCost = Double.MAX_VALUE;
            this.bestTravelSpeed = oi.cache.maxVel;
            this.navMeshData = oi.oa.isSelected() ? new NavigateMeshData() : null;
        }

        public void newDir(OccInfo oi, Vector3d dir, boolean preferred) {
            this.dir = dir;
            this.dirCost = 0.0;
            this.dirTravelSpeed = oi.cache.maxVel;
            this.recordHC = this.d_preferredDir != null && dir != null && dir.dot(this.d_preferredDir) >= 0.0;
            boolean bl = this.recordHCWalls = this.recordHC && preferred;
            if (this.navMeshData != null) {
                this.navMeshData.addDir(dir);
            }
        }

        public Consumer<OccAgent> getHighCostOccConsumer() {
            return this.recordHC ? this.allHCOccs::add : null;
        }

        public Consumer<Boolean> getHighCostWallConsumer() {
            return this.recordHCWalls ? highCostWall -> {
                this.highCostWall = highCostWall;
            } : null;
        }

        public boolean add(NavigateMeshData.Behavior behavior, double cost, double maxSpeed) {
            if (this.navMeshData != null) {
                this.navMeshData.addData(behavior, cost, maxSpeed);
            }
            this.dirCost += cost;
            if (maxSpeed < this.dirTravelSpeed) {
                this.dirTravelSpeed = maxSpeed;
            }
            if (this.dirTravelSpeed == 0.0 && this.bestTravelSpeed == 0.0 && this.dir != null) {
                return false;
            }
            if (theUtil.eq(this.dirCost, this.bestCost, 1.0E-6)) {
                return this.dirTravelSpeed > this.bestTravelSpeed;
            }
            return this.dirCost < this.bestCost;
        }

        public boolean add(NavigateMeshData.Behavior behavior, double weight, double[] cost) {
            return this.add(behavior, weight * cost[0], cost[1]);
        }

        public void record(int bestDirIx) {
            this.bestCost = this.dirCost;
            this.bestTravelSpeed = this.dirTravelSpeed;
            if (this.d_preferredDir != null) {
                this.bestHCOccs = !this.recordHC || !this.oi.oa.hasVehicle() ? this.allHCOccs : new ArrayList<OccAgent>(this.allHCOccs);
                this.bestHighCostWall = this.highCostWall;
            }
            if (this.navMeshData != null) {
                this.navMeshData.setBestDirIndex(bestDirIx);
            }
        }

        public void finalizeData(KB world) {
            if (this.navMeshData != null) {
                this.navMeshData.setHighCostOccs(this.bestHCOccs);
                world.getProps().setDbg(this.oi.oa.getOcc(), "NAVMESH_DIR", this.navMeshData);
            }
        }
    }
}

