/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.PathChange;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;
import thunderheadeng.util.theUtil;

public class AvoidObstacles
implements Serializable {
    static final long serialVersionUID = 1L;
    private final double d_sensingRadius;
    private double d_preferredDirTime = Double.NaN;
    private Vector3d d_preferredDir = null;
    private double d_maxT;

    public static double getSensingRadius(KB kb, OccInfo oi) {
        double maxVel = oi.cache.maxVel;
        return Math.max(OccAgent.calcStopDist(maxVel, oi.oa.getMaxStopAccel(kb)), oi.cache.currVel * (double)oi.oa.getOcc().collisionResponseTime);
    }

    public AvoidObstacles(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo) {
        assert (senses.hasNearbyHazards(kb, oi));
        this.d_sensingRadius = AvoidObstacles.getSensingRadius(kb, oi);
        double distToGoal = seekInfo.seekCurve.length();
        this.d_maxT = Math.min(distToGoal, this.d_sensingRadius);
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, boolean separating, Vector3d dir, boolean isPreferredDir) {
        if (isPreferredDir && dir != null) {
            this.d_preferredDir = dir;
            return new double[]{0.0, oi.cache.maxVel};
        }
        if (!isPreferredDir && dir == null) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        double preferredDirTime = this.getPreferredDirTravelTime(kb, oi, senses, seekInfo);
        if (Double.isNaN(preferredDirTime)) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        Predicate<PathChange> pathFilter = seekInfo.transientPathFilter;
        double travelTime = senses.senseGeomTravelTime(kb, oi, dir, this.d_maxT, pathFilter);
        if (theUtil.le(travelTime, preferredDirTime, 1.0E-9)) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        double cost = InvSteerUtil.clampCost(travelTime / preferredDirTime - 1.0);
        double speed = oi.cache.maxVel;
        return new double[]{cost, speed};
    }

    private double getPreferredDirTravelTime(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo) {
        if (!Double.isNaN(this.d_preferredDirTime)) {
            return this.d_preferredDirTime;
        }
        if (this.d_preferredDir == null) {
            return Double.NaN;
        }
        this.d_preferredDirTime = senses.senseGeomTravelTime(kb, oi, this.d_preferredDir, this.d_maxT, seekInfo.transientPathFilter);
        return this.d_preferredDirTime;
    }
}

