/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.geodesics;

import javax.vecmath.Point3d;

public class GeodesicsJNI {
    private static boolean meshCreated;

    public static void createMesh(double[] points, int[] faces, int[] forcedBoundaryEdges) {
        new GeodesicsJNI().setMesh(points, faces, forcedBoundaryEdges);
        meshCreated = true;
    }

    private native void setMesh(double[] var1, int[] var2, int[] var3);

    private native Point3d[] findPath(double var1, double var3, double var5, int var7, double var8, double var10, double var12, int var14);

    private native double[] findPathDouble(double var1, double var3, double var5, int var7, double var8, double var10, double var12, int var14);

    public static Point3d[] findPath(Point3d start, int startTriId, Point3d target, int targetTriId) {
        return new GeodesicsJNI().findPath(start.x, start.y, start.z, startTriId, target.x, target.y, target.z, targetTriId);
    }

    private static Point3d[] convert(double[] pathDouble) {
        assert (pathDouble.length % 3 == 0);
        Point3d[] ret = new Point3d[pathDouble.length / 3];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Point3d(pathDouble[3 * i], pathDouble[3 * i + 1], pathDouble[3 * i + 2]);
        }
        return ret;
    }

    public static boolean isMeshCreated() {
        return meshCreated;
    }

    static {
        System.loadLibrary("FreeImage");
        System.loadLibrary("Pathfinder_jni");
    }
}

