/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.Occupant;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.geom.Inter;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.path.IPathSeek;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.RegroupPlanner;
import inferno.sim.steering.inverse.ICostCalc;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.NavigateMesh;
import inferno.sim.steering.inverse.Seek;
import inferno.sim.steering.powerlaw.PowerLawNavigateMesh;
import inferno.sim.steering.simple.Arrive;
import inferno.sim.steering.simple.MoveToGoal;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;

public class SteerUtil {
    public static ISteeringBehavior newSeekSteer(KB kb, OccAgent agent, IPathPlanner pathPlanner) {
        boolean agentIsGrouped;
        if (System.getProperty("powerlaw") != null) {
            return new PowerLawNavigateMesh(new Seek(kb, agent, pathPlanner, Double.NaN, null), new ICostCalc[0]);
        }
        boolean reactiveSteering = kb.getParams().reactive_steering;
        boolean bl = agentIsGrouped = agent.getOcc().occupantGroup != null;
        if (agentIsGrouped && reactiveSteering) {
            return new NavigateMesh(new RegroupPlanner.RegroupPlannerSeek(kb, agent, RegroupPlanner.createRegroupPlanner(agent, kb, pathPlanner)), Predicates.alwaysTrue(), Predicates.alwaysTrue(), new ICostCalc[0]);
        }
        if (agentIsGrouped && !reactiveSteering) {
            return new RegroupPlanner.RegroupPlannerMoveToGoal(kb, agent, RegroupPlanner.createRegroupPlanner(agent, kb, pathPlanner));
        }
        if (!agentIsGrouped && reactiveSteering) {
            return new NavigateMesh(new Seek(kb, agent, pathPlanner, Double.NaN, null), Predicates.alwaysTrue(), Predicates.alwaysTrue(), new ICostCalc[0]);
        }
        if (!agentIsGrouped && !reactiveSteering) {
            return new MoveToGoal(kb, agent, pathPlanner);
        }
        assert (false);
        throw new RuntimeException("This should not happen.");
    }

    public static ISteeringBehavior newIdleSteer(KB kb, OccAgent agent, IdleParams idleParams, Supplier<ISeekCalc> getWanderSeek, Supplier<Pair<ITpSource, Vector3d>> getArrivalPoint) {
        if (kb.getParams().reactive_steering) {
            Predicate<OccAgent> avoidFilter = Predicates.always(idleParams.avoidOthers);
            Predicate<OccAgent> collisionFilter = Predicates.always(idleParams.isCollidable);
            return new NavigateMesh(getWanderSeek.get(), avoidFilter, collisionFilter, new ICostCalc[0]);
        }
        Pair<ITpSource, Vector3d> arrival = getArrivalPoint.get();
        return new Arrive((ITpSource)arrival.v1, (Vector3d)arrival.v2);
    }

    public static ISteeringBehavior newIdleSteer(KB kb, OccAgent agent, IdleParams idleParams) {
        ISeekArea seek = AiUtil.getCurrentSeekArea(kb, agent);
        return seek.getIdleSteer(kb, agent, idleParams);
    }

    public static double getPredDistance(Occupant occ, double lookaheadTime) {
        return occ.vel.length() * lookaheadTime;
    }

    public static Point3d getPredPoint(OccAgent oa, double lookahead) {
        Vector3d dir = new Vector3d(oa.getVel());
        dir.normalize();
        dir.scale(lookahead);
        return Inter.add(oa.getPos(), (Tuple3d)dir);
    }

    public static Vector3d getPredVec(OccAgent oa) {
        Vector3d dir = new Vector3d(oa.getVel());
        dir.normalize();
        return dir;
    }

    public static Vector3d getPredictDir(KB kb, OccAgent agent, PathFollow gp) {
        return SteerUtil.getPredictDir(kb, agent, gp, 0.0);
    }

    public static Vector3d getPredictDir(KB kb, OccAgent agent, PathFollow gp, double minDistance) {
        IPathSeek seek1 = gp.getSeek();
        Vector3d dir = seek1.getPredictDir();
        if (dir == null) {
            if (minDistance != 0.0) {
                ArrayList<Point3d> seeks = new ArrayList<Point3d>();
                gp.getSeekPoints(kb, agent.getPos(), minDistance, false, false, seeks);
                Point3d first = (Point3d)seeks.get(0);
                Point3d last = (Point3d)seeks.get(seeks.size() - 1);
                if (first.equals(last)) {
                    last = gp.getNextSeekPt().p;
                }
                if (first.equals(last)) {
                    first = agent.getPos();
                }
                dir = Util3D.vector(first, last);
                Util.safeNormalize(dir, 1.0E-9);
            } else {
                IPathSeek seek2 = gp.getNextSeek();
                Point3d currPt = seek1 != seek2 ? seek1.getSeekPt().p : agent.getPos();
                Point3d nextPt = seek2.getSeekPt().p;
                dir = Util3D.vector(currPt, nextPt);
                Util.safeNormalize(dir, 1.0E-9);
            }
        }
        return dir;
    }
}

