/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.scripting;

import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.scripting.AgentsApi;
import inferno.sim.scripting.GeomApi;
import inferno.sim.scripting.IoApi;
import inferno.sim.scripting.SimulationControlApi;
import inferno.sim.scripting.TriggersApi;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.io.IOAccess;
import thunderheadeng.util.Predicates;

public class ScriptHandler {
    private static final String LANG_ID = "js";
    private Context d_jsContext;
    private Api d_api;
    private Engine d_pthEngine;

    public ScriptHandler(Engine e, KB kb) {
        this.d_pthEngine = e;
        System.setProperty("polyglotimpl.DisableClassPathIsolation", "true");
        this.d_jsContext = Context.newBuilder(LANG_ID).allowHostAccess(HostAccess.ALL).allowHostClassLookup(Predicates.alwaysTrue()).allowIO(IOAccess.ALL).build();
        this.d_api = new Api(kb);
        this.d_jsContext.getBindings(LANG_ID).putMember("api", this.d_api);
    }

    private ScriptHandler() {
    }

    public static ScriptHandler createNullHandler() {
        return new ScriptHandler(){

            @Override
            public void init(String script) {
            }

            @Override
            public void invokeCallbacks(String method) {
            }
        };
    }

    public void init(String script) {
        this.d_jsContext.eval(LANG_ID, script);
    }

    public void invokeCallbacks(String method) {
        if ("onUpdate".equals(method)) {
            this.d_api.simctl.invokeCallbacksOnUpdate();
        } else if ("onExit".equals(method)) {
            this.d_api.simctl.invokeCallbacksOnExit();
        }
    }

    public static class Api {
        public final GeomApi geometry;
        public final SimulationControlApi simctl;
        public final AgentsApi agents;
        public final IoApi io;
        public final TriggersApi triggers;

        public Api(KB kb) {
            this.geometry = new GeomApi(kb);
            this.triggers = new TriggersApi(kb);
            this.simctl = new SimulationControlApi(kb);
            this.agents = new AgentsApi(kb);
            this.io = new IoApi(kb);
        }
    }
}

