/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.scripting;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.MeasurementRegion;
import inferno.elevator.ITimeEstimate;
import inferno.sim.KB;
import inferno.sim.scripting.ScriptingUtil;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class GeomApi {
    public final ApiV1 v1;
    private KB d_kb;
    private static final Function<Serializable, Stream<String>> s_getNames = obj -> {
        if (obj instanceof ANode) {
            ANode node = (ANode)obj;
            return Stream.of(node.name, node.annotatedName);
        }
        if (obj instanceof MeasurementRegion) {
            return Stream.of(((MeasurementRegion)obj).name);
        }
        throw new IllegalArgumentException(obj.getClass().getName());
    };

    public GeomApi(KB kb) {
        this.d_kb = kb;
        this.v1 = new ApiV1();
    }

    public class ApiV1 {
        public Serializable find(String name) {
            return ScriptingUtil.findMultiName(name, s_getNames, GeomApi.this.d_kb.getNodes(), GeomApi.this.d_kb.getDensityRegions());
        }

        public List<Serializable> findAll(String regexName) {
            return ScriptingUtil.findAllMultiName(regexName, s_getNames, GeomApi.this.d_kb.getNodes(), GeomApi.this.d_kb.getDensityRegions());
        }

        public void open(ANode door) {
            door.setClosed(null);
        }

        public void close(ANode door) {
            door.setClosed(new ITimeEstimate.Offset(60.0));
        }

        private Vector2d parseDir(String sdir) {
            Runnable throwExc = () -> {
                throw new IllegalArgumentException("Door direction must be empty, {+|-}{x|y}, or two values indicating the 2d flow direction, separated by a space.");
            };
            if (sdir == null || sdir.isEmpty()) {
                return null;
            }
            double mult = 1.0;
            int ix = 0;
            if (sdir.charAt(0) == '-') {
                mult = -1.0;
                ++ix;
            } else if (sdir.charAt(0) == '+') {
                ++ix;
            }
            switch (Character.toLowerCase(sdir.charAt(ix))) {
                case 'x': {
                    return new Vector2d(mult * 1.0, 0.0);
                }
                case 'y': {
                    return new Vector2d(0.0, mult * 1.0);
                }
            }
            StringTokenizer tok = new StringTokenizer(sdir.substring(ix), " ");
            if (tok.countTokens() < 2) {
                throwExc.run();
            }
            double x = Double.parseDouble(tok.nextToken());
            double y = Double.parseDouble(tok.nextToken());
            return new Vector2d(x, y);
        }

        public void setDoorDir(ANode door, String sdir) {
            DoorDir dir;
            Vector2d onewayVec = this.parseDir(sdir);
            DoorDir onewayDir = onewayVec != null ? DoorDir.get(door, new Vector3d(onewayVec.x, onewayVec.y, 0.0)) : null;
            DoorDir doorDir = dir = onewayDir != null && !door.isExitDoor() ? onewayDir : null;
            if (dir != door.getSetDoorDir()) {
                door.setDoorDir(dir);
                GeomApi.this.d_kb.markMeshDirty();
            }
        }
    }
}

