/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.scripting;

import inferno.data2.ANode;
import inferno.data2.MeasurementRegion;
import inferno.data2.Tag;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.scripting.ScriptingUtil;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.search.ITest;

public class AgentsApi {
    public final ApiV1 v1;
    private KB d_kb;

    public AgentsApi(KB kb) {
        this.d_kb = kb;
        this.v1 = new ApiV1();
    }

    public class ApiV1 {
        @Deprecated
        public List<OccAgent> getAllAgents() {
            return new ArrayList<OccAgent>(AgentsApi.this.d_kb.getAllAgentsEver());
        }

        public Collection<OccAgent> getAllAgentsEver() {
            return AgentsApi.this.d_kb.getAllAgentsEver();
        }

        public OccAgent find(String name) {
            return (OccAgent)ScriptingUtil.find(name, obj -> ((OccAgent)obj).getName(), AgentsApi.this.d_kb.getAllAgentsEver());
        }

        public List<OccAgent> findAll(String regexName) {
            return ScriptingUtil.findAll(regexName, obj -> ((OccAgent)obj).getName(), AgentsApi.this.d_kb.getAllAgentsEver());
        }

        public List<OccAgent> findAll(MeasurementRegion r) {
            ArrayList<OccAgent> agentsCenterInside = new ArrayList<OccAgent>();
            AgentsApi.this.d_kb.findOccs((ITest<AABox>)r.area, true, (occ, ctmt) -> {
                if (r.area.contains(occ.getPos())) {
                    agentsCenterInside.add((OccAgent)occ);
                }
            });
            return agentsCenterInside;
        }

        public List<OccAgent> findAll(ANode node) {
            ArrayList<OccAgent> agents = new ArrayList<OccAgent>();
            agents.addAll(node.getCurrentUsage());
            return agents;
        }

        public List<OccAgent> findAllTagged(String tagStr, Serializable location) {
            Serializable serializable = location;
            Objects.requireNonNull(serializable);
            Serializable serializable2 = serializable;
            int n = 0;
            List<OccAgent> locationAgents = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ANode.class, MeasurementRegion.class}, (Object)serializable2, n)) {
                case 0 -> {
                    ANode node = (ANode)serializable2;
                    yield this.findAll(node);
                }
                case 1 -> {
                    MeasurementRegion measure = (MeasurementRegion)serializable2;
                    yield this.findAll(measure);
                }
                default -> throw new IllegalArgumentException(location.getClass().getName());
            };
            Predicate<OccAgent> tagFilter = this.getTagFilter(tagStr);
            return locationAgents.stream().filter(tagFilter).collect(Collectors.toList());
        }

        public List<OccAgent> findAllTagged(String tagStr) {
            return AgentsApi.this.d_kb.getTags().stream().filter(tag -> tag.name.equalsIgnoreCase(tagStr)).findFirst().orElseThrow(IllegalArgumentException::new).getTaggedAgents().stream().map(occId -> AgentsApi.this.d_kb.getAgent((int)occId)).collect(Collectors.toList());
        }

        private Predicate<OccAgent> getTagFilter(String tagStr) {
            Tag tagToFilter = AgentsApi.this.d_kb.getTags().stream().filter(tag -> tag.name.equalsIgnoreCase(tagStr)).findFirst().orElseThrow(IllegalArgumentException::new);
            return agent -> tagToFilter.getTaggedAgents().contains(agent.getId());
        }
    }
}

