/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.path.AStar;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.WaypointSeek;
import java.io.Serializable;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class PartialPath
implements IPath,
Serializable {
    static final long serialVersionUID = 1L;
    private final IPath d_headPath;
    private double d_estTailDist;
    private TriPoint[] d_tailPts;

    public PartialPath(IPath headPath, TriPoint[] tailPts, double estTailDist) {
        this.d_headPath = headPath;
        this.d_tailPts = tailPts;
        this.d_estTailDist = estTailDist;
    }

    @Override
    public AStar.DebugInfo getDebugInfo() {
        return this.d_headPath.getDebugInfo();
    }

    public double getLocalDist() {
        return this.d_headPath.length(true);
    }

    public double getTailDist() {
        return this.d_estTailDist;
    }

    @Override
    public int getNumPoints(boolean fuzzy) {
        int numPoints = this.d_headPath.getNumPoints(fuzzy);
        if (fuzzy) {
            numPoints += Math.max(this.d_tailPts.length - 1, 0);
        }
        return numPoints;
    }

    @Override
    public IPathSeek pointAt(int ix) {
        int crossIx = this.d_headPath.getNumPoints(true);
        if (ix < crossIx) {
            return this.d_headPath.pointAt(ix);
        }
        TriPoint tp = this.d_tailPts[ix - crossIx + 1];
        return new WaypointSeek(tp, Filters.acceptAll(WingedEdge.class));
    }

    @Override
    public double length(boolean fuzzy) {
        double len = this.d_headPath.length(fuzzy);
        if (fuzzy) {
            len += this.getTailDist();
        }
        return len;
    }

    @Override
    public double fuzzyLength() {
        return this.d_headPath.fuzzyLength() + this.getTailDist();
    }

    @Override
    public Pair<ANode, DoorDir> getTargetDoor() {
        return this.d_headPath.getTargetDoor();
    }

    public String toString() {
        return String.format("PartialPath[length=%.2f,localDist=%.2f,tailDist=%.2f]", this.length(true), this.d_headPath.length(true), this.d_estTailDist);
    }
}

