/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.output.SocialDistanceTransientWriter;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class SocialDistanceTransientWriterJson
extends AJsonInfoWriter {
    public static final double SD_TRANSIENT_DETECTION_RADIUS = 3.0;

    public static boolean isWriterEnabled(KB kb) {
        return kb.getParams().social_distance_csv_output;
    }

    public SocialDistanceTransientWriterJson(KB kb) {
        super(kb, true);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_sd_transient_json));
    }

    @Override
    public void writeFrame(double t) {
        if (this.getKb().getActiveAgents().isEmpty()) {
            return;
        }
        Mesh m = this.getKb().getMesh();
        Optional<OccAgent> maxIdAgent = this.getKb().getActiveAgents().stream().max(Comparator.comparingInt(OccAgent::getId));
        ArrayList<Object> nearOccsData = new ArrayList<Object>(Collections.nCopies(maxIdAgent.get().getId() + 1, null));
        ArrayList<Object> nearestOccData = new ArrayList<Object>(Collections.nCopies(maxIdAgent.get().getId() + 1, null));
        ConcurrentHashMap distMap = new ConcurrentHashMap(this.getKb().getActiveAgents().size(), 0.75f, Runtime.getRuntime().availableProcessors());
        this.getKb().getActiveAgents().parallelStream().forEach(agent -> {
            List<OccAgent> nearOccs = this.getKb().findOccs((ITest<AABox>)new BoundingSphere(agent.getPos(), 3.0), OccLocator.exclude(agent, Filters.acceptAll()), true);
            nearOccsData.set(agent.getId(), nearOccs);
            for (OccAgent nearOcc2 : nearOccs) {
                distMap.computeIfAbsent(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, nearOcc2), key -> SocialDistanceTransientWriter.getSocialDistance(m, agent, nearOcc2, 3.0));
            }
            Optional<OccAgent> nearestOcc = nearOccs.stream().filter(nearOcc -> Double.isFinite((Double)distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, (OccAgent)nearOcc)))).min(Comparator.comparingDouble(nearOcc -> (Double)distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, (OccAgent)nearOcc))));
            nearestOccData.set(agent.getId(), nearestOcc);
        });
        this.getKb().getActiveAgents().stream().forEach(agent -> {
            LinkedHashMap<String, Object> agentData = new LinkedHashMap<String, Object>();
            Optional nearestOcc = (Optional)nearestOccData.get(agent.getId());
            SocialDistanceData data = new SocialDistanceData(distMap, nearestOccData, nearOccsData, nearestOcc);
            for (Keys k : Keys.values()) {
                agentData.put(k.toString(), k.apply(this.getKb(), (OccAgent)agent, data));
            }
            this.getWriter().add(agentData);
        });
    }

    @Override
    public void consolidate() {
        LinkedHashMap finalData = new LinkedHashMap();
        ArrayList<Map<String, Object>> tempData = this.getWriter().readTempJsonData();
        for (Map<String, Object> occFrame : tempData) {
            String time = String.valueOf(occFrame.get(Keys.TIME.toString()));
            occFrame.remove(Keys.TIME.toString());
            String occId = (String)occFrame.get(Keys.ID.toString());
            occFrame.remove(Keys.ID.toString());
            theUtil.mapPutSubObject(finalData, occId, time, occFrame);
        }
        this.getWriter().add(finalData);
    }

    private static ArrayList<OccAgent> filterToDist(OccAgent root, List<OccAgent> agents, double maxDistance) {
        ArrayList<OccAgent> nearAgents = new ArrayList<OccAgent>();
        Point3d rootPos = root.getPos();
        for (OccAgent nearAgent : agents) {
            double distance = rootPos.distance(nearAgent.getPos());
            if (!(distance <= maxDistance)) continue;
            nearAgents.add(nearAgent);
        }
        return nearAgents;
    }

    private static enum Keys {
        TIME("time", (kb, occ, data) -> kb.getCurrentSimTime()),
        ID("id", (kb, occ, data) -> String.valueOf(occ.getOcc().getId())),
        NAME("name", (kb, occ, data) -> occ.getOcc().name),
        OCC_GROUP_ID("groupId", (kb, occ, data) -> {
            if (occ.getOcc().occupantGroup != null) {
                return String.valueOf(occ.getOcc().occupantGroup.getID());
            }
            return "None";
        }),
        CLOSEST("closest", (kb, occ, data) -> {
            if (data.d_nearestOcc.isPresent()) {
                LinkedHashMap<String, Object> closestData = new LinkedHashMap<String, Object>();
                closestData.put("id", String.valueOf(data.d_nearestOcc.get().getOcc().getId()));
                closestData.put("name", data.d_nearestOcc.get().getName());
                closestData.put("distance", AJsonInfoWriter.formatDouble((Double)data.d_distmap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)occ, data.d_nearestOcc.get())), 3));
                return closestData;
            }
            return "None";
        }),
        OCCS_WITHIN("occsWithin", (kb, occ, data) -> {
            LinkedHashMap occDistances = new LinkedHashMap();
            List<OccAgent> nearOccs = data.d_nearOccsData.get(occ.getId());
            ArrayList<OccAgent> m1 = SocialDistanceTransientWriterJson.filterToDist(occ, nearOccs, 1.0);
            ArrayList<OccAgent> m2 = SocialDistanceTransientWriterJson.filterToDist(occ, nearOccs, 2.0);
            ArrayList<OccAgent> m3 = SocialDistanceTransientWriterJson.filterToDist(occ, nearOccs, 3.0);
            theUtil.mapPutSubObject(occDistances, "1.0", "count", m1.size());
            theUtil.mapPutSubObject(occDistances, "1.0", "ids", m1.stream().map(oa -> String.valueOf(oa.getOcc().getId())).collect(Collectors.toList()));
            theUtil.mapPutSubObject(occDistances, "2.0", "count", m2.size());
            theUtil.mapPutSubObject(occDistances, "2.0", "ids", m2.stream().map(oa -> String.valueOf(oa.getOcc().getId())).collect(Collectors.toList()));
            theUtil.mapPutSubObject(occDistances, "3.0", "count", m3.size());
            theUtil.mapPutSubObject(occDistances, "3.0", "ids", m3.stream().map(oa -> String.valueOf(oa.getOcc().getId())).collect(Collectors.toList()));
            return occDistances;
        });

        private String key;
        private TriFunction<KB, OccAgent, SocialDistanceData, Object> formatter;

        private Keys(String key, TriFunction<KB, OccAgent, SocialDistanceData, Object> formatter) {
            this.key = key;
            this.formatter = formatter;
        }

        public Object apply(KB kb, OccAgent occ, SocialDistanceData data) {
            return this.formatter.apply(kb, occ, data);
        }

        public String toString() {
            return this.key;
        }
    }

    private static class SocialDistanceData {
        public ConcurrentMap<UnorderedPair<OccAgent, OccAgent>, Double> d_distmap;
        public List<Optional<OccAgent>> d_nearestOccData;
        public List<List<OccAgent>> d_nearOccsData;
        public Optional<OccAgent> d_nearestOcc;

        private SocialDistanceData(ConcurrentMap<UnorderedPair<OccAgent, OccAgent>, Double> distmap, List<Optional<OccAgent>> nearestOccData, List<List<OccAgent>> nearOccsData, Optional<OccAgent> nearestOcc) {
            this.d_distmap = distmap;
            this.d_nearestOccData = nearestOccData;
            this.d_nearOccsData = nearOccsData;
            this.d_nearestOcc = nearestOcc;
        }
    }
}

