/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.ANode;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.output.RoomUsageWriter;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.theUtil;

public class RoomUsageWriterJson
extends AJsonInfoWriter {
    private final List<RoomUsageWriter.IUsageElement> d_sortedNodes;
    private int d_initialOccupants;

    public static boolean isWriterEnabled(KB kb) {
        return true;
    }

    public RoomUsageWriterJson(KB kb) {
        super(kb, true);
        ArrayList<RoomUsageWriter.IUsageElement> nodes = new ArrayList<RoomUsageWriter.IUsageElement>(kb.getNodes().size());
        IdentityHashSet<ANode> excludeNodes = new IdentityHashSet<ANode>(kb.getDoorNodes());
        excludeNodes.addAll(kb.getElevatorModel().getAllElevatorRooms());
        for (ANode node : kb.getNodes()) {
            if (excludeNodes.contains(node)) continue;
            nodes.add(new RoomUsageWriter.NodeUsage(node));
        }
        List<Elevator> elevators = kb.getElevatorModel().getElevators();
        for (Elevator elevator : elevators) {
            ANode dischargeNode = elevator.getTravelingNode();
            ArrayList<ANode> elevatorNodes = new ArrayList<ANode>(elevator.getLevels().size());
            for (ElevatorLevel level : elevator.getLevels()) {
                elevatorNodes.add(level.pickupNode);
            }
            RoomUsageWriter.CompositeNodeUsage usage = new RoomUsageWriter.CompositeNodeUsage(dischargeNode, elevatorNodes);
            nodes.add(usage);
        }
        Collections.sort(nodes, new Comparator<RoomUsageWriter.IUsageElement>(this){

            @Override
            public int compare(RoomUsageWriter.IUsageElement o1, RoomUsageWriter.IUsageElement o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.d_sortedNodes = nodes;
        this.d_initialOccupants = kb.getAgents().size();
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_rooms_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap<String, Serializable> frameData = new LinkedHashMap<String, Serializable>();
        int exited = 0;
        LinkedHashMap<String, Integer> rooms = new LinkedHashMap<String, Integer>();
        for (RoomUsageWriter.IUsageElement n : this.d_sortedNodes) {
            exited += n.getExitedVia();
            rooms.put(n.getName(), n.getNumOccupants());
        }
        frameData.put(Keys.TIME.get(), Double.valueOf(t));
        frameData.put(Keys.REMAINING.get(), Integer.valueOf(this.getKb().getAllAgentsEver().size() - exited));
        frameData.put(Keys.EXITED.get(), Integer.valueOf(exited));
        frameData.put(Keys.ROOMS.get(), rooms);
        this.getWriter().add(frameData);
    }

    @Override
    public void consolidate() {
        LinkedHashMap finalData = new LinkedHashMap();
        ArrayList<Map<String, Object>> frames = this.getWriter().readTempJsonData();
        for (Map<String, Object> frame : frames) {
            double time = (Double)frame.get(Keys.TIME.get());
            double remaining = (Double)frame.get(Keys.REMAINING.get());
            double exited = (Double)frame.get(Keys.EXITED.get());
            Map rooms = (Map)frame.get(Keys.ROOMS.get());
            theUtil.mapPutSubObject(finalData, Keys.REMAINING.get(), String.valueOf(time), remaining);
            theUtil.mapPutSubObject(finalData, Keys.EXITED.get(), String.valueOf(time), exited);
            for (Map.Entry entry : rooms.entrySet()) {
                theUtil.mapPutSubObject(finalData, (String)entry.getKey(), String.valueOf(time), entry.getValue());
            }
        }
        this.getWriter().add(finalData);
    }

    private static enum Keys implements Supplier<String>
    {
        TIME("time"),
        REMAINING("remaining"),
        EXITED("exited"),
        ROOMS("rooms");

        private final String d_val;

        private Keys(String val) {
            this.d_val = val;
        }

        public String toString() {
            return this.d_val.toString();
        }

        @Override
        public String get() {
            return this.d_val;
        }
    }
}

