/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.OccTarget;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import thunderheadeng.util.theUtil;

public class OccTargetsWriterJson
extends AJsonInfoWriter {
    public static boolean isWriterEnabled(KB kb) {
        return !kb.getOccTargets().getAll().isEmpty();
    }

    public OccTargetsWriterJson(KB kb) {
        super(kb, true);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_occtargets_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap<String, Serializable> timeStep = new LinkedHashMap<String, Serializable>();
        timeStep.put(Keys.TIME.get(), Double.valueOf(t));
        LinkedHashMap targets = new LinkedHashMap();
        OccAgent[] reservations = new OccAgent[this.getKb().getOccTargets().getAll().size()];
        boolean[] using = new boolean[this.getKb().getOccTargets().getAll().size()];
        for (OccAgent agent : this.getKb().getActiveAgents()) {
            for (OccTarget target : this.getKb().getOccTargets().getReservations(agent)) {
                reservations[target.id] = agent;
            }
            agent.getAiCore().getOccTargetInUse(this.getKb(), agent).ifPresent(loc -> {
                using[loc.id] = true;
            });
        }
        for (OccTarget target : this.getKb().getOccTargets().getAll()) {
            OccAgent reservingAgent = reservations[target.id];
            theUtil.mapPutSubObject(targets, target.name, Keys.RESERVED_BY_NAME.get(), reservingAgent != null ? reservingAgent.getName() : "");
            theUtil.mapPutSubObject(targets, target.name, Keys.RESERVED_BY_ID.get(), reservingAgent != null ? String.valueOf(reservingAgent.getId()) : "");
            theUtil.mapPutSubObject(targets, target.name, Keys.USING.get(), using[target.id]);
        }
        timeStep.put(Keys.TARGETS.get(), targets);
        this.getWriter().add(timeStep);
    }

    @Override
    public void consolidate() {
        ArrayList<Map<String, Object>> tempData = this.getWriter().readTempJsonData();
        LinkedHashMap<String, LinkedHashMap> finalData = new LinkedHashMap<String, LinkedHashMap>();
        for (Map<String, Object> frame : tempData) {
            double time = (Double)frame.get(Keys.TIME.get());
            Map targets = (Map)frame.get(Keys.TARGETS.get());
            for (Map.Entry entry : targets.entrySet()) {
                String name = (String)entry.getKey();
                Map data = (Map)entry.getValue();
                LinkedHashMap existingTargetData = finalData.containsKey(name) ? (LinkedHashMap)finalData.get(name) : new LinkedHashMap();
                for (Map.Entry vals : data.entrySet()) {
                    theUtil.mapPutSubObject(existingTargetData, (String)vals.getKey(), String.valueOf(time), vals.getValue());
                }
                finalData.put(name, existingTargetData);
            }
        }
        this.getWriter().add(finalData);
    }

    private static enum Keys implements Supplier<String>
    {
        RESERVED_BY_NAME("reservedBy"),
        RESERVED_BY_ID("reservedById"),
        TARGETS("targets"),
        TIME("time"),
        USING("using");

        private final String d_val;

        private Keys(String val) {
            this.d_val = val;
        }

        public String toString() {
            return this.d_val.toString();
        }

        @Override
        public String get() {
            return this.d_val;
        }
    }
}

