/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.Tag;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.Param;
import inferno.sim.occsource.OccSource;
import inferno.sim.output.json.AOccDataWriterJson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class OccDataWriterSingleJson
extends AOccDataWriterJson {
    private Set<OccAgent> d_agents;
    private transient List<Tag> d_tags;

    public OccDataWriterSingleJson(KB kb, boolean initAgents) {
        super(kb, true);
        this.d_agents = initAgents ? new LinkedIdentityHashSet<OccAgent>(OccDataWriterSingleJson.filterAgents(kb.getActiveAgents())) : new LinkedIdentityHashSet();
        this.d_tags = OccDataWriterSingleJson.calcSingleFileTags(kb, this.d_agents);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_occ_detailed_json));
    }

    public void open(double t, String fn) throws IOException {
        this.getWriter().open(t, new File(fn));
    }

    public void forceOpen(String filename) throws IOException {
        this.getWriter().forceOpen(new File(filename));
    }

    @Override
    public void addAgents(double t, Collection<OccAgent> agents) {
        agents = OccDataWriterSingleJson.filterAgents(agents);
        for (OccAgent agent : agents) {
            this.writeFrame(t, agent, this.d_tags);
            if (agent.isDone()) continue;
            this.d_agents.add(agent);
        }
    }

    public void addAgent(OccAgent agent) {
        if (!agent.isDone()) {
            this.d_agents.add(agent);
        }
    }

    @Override
    public void writeFrame(double t, boolean removeFinished) {
        Iterator<OccAgent> it = this.d_agents.iterator();
        while (it.hasNext()) {
            OccAgent agent = it.next();
            this.writeFrame(t, agent, this.d_tags);
            if (!removeFinished || !agent.isDone()) continue;
            it.remove();
        }
    }

    @Override
    public void consolidate() {
        LinkedHashMap finalData = new LinkedHashMap();
        ArrayList<Map<String, Object>> data = this.getWriter().readTempJsonData();
        for (Map<String, Object> frame : data) {
            String time = String.valueOf((Double)frame.get(AOccDataWriterJson.Keys.TIME.get()));
            String occId = frame.get(AOccDataWriterJson.Keys.ID.get()).toString();
            frame.remove(AOccDataWriterJson.Keys.TIME.get());
            frame.remove(AOccDataWriterJson.Keys.ID.get());
            theUtil.mapPutSubObject(finalData, occId, time, frame);
        }
        this.getWriter().add(finalData);
    }

    private static List<Tag> calcSingleFileTags(KB d_kb, Collection<OccAgent> d_agents) {
        LinkedIdentityHashSet<Tag> tags = new LinkedIdentityHashSet<Tag>();
        OccDataWriterSingleJson.calcPossibleTags(d_kb, d_agents, tags);
        for (OccSource source : d_kb.getOccSources()) {
            boolean[] mayOutput = new boolean[]{false};
            try {
                source.getFutureProfileValues(OccProfileSim.PROP_PRINT_EXTRA_OUTPUT, printExtra -> {
                    if (printExtra.getUnique(HashSet.class).contains(Boolean.TRUE)) {
                        mayOutput[0] = true;
                        throw new RuntimeException();
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!mayOutput[0]) continue;
            for (BehaviorSim behavior : source.getBehaviors()) {
                OccDataWriterSingleJson.getPossibleTags(behavior, tags);
            }
        }
        return new ArrayList<Tag>(tags);
    }
}

