/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.AttractorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import thunderheadeng.util.theUtil;

public class AttractorWriterJson
extends AJsonInfoWriter {
    public static boolean isWriterEnabled(KB kb) {
        return !kb.getRootAttractors().isEmpty();
    }

    public AttractorWriterJson(KB kb) {
        super(kb, true);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_attractors_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap<String, Serializable> attractorFrame = new LinkedHashMap<String, Serializable>();
        attractorFrame.put(Keys.TIME.get(), Double.valueOf(t));
        int[] counts = new int[this.getKb().getAllAttractors().size()];
        for (OccAgent agent : this.getKb().getActiveAgents()) {
            agent.getAiCore().getAttractorInUse(this.getKb(), agent).ifPresent(core -> {
                int n = core.getRootId();
                counts[n] = counts[n] + 1;
            });
        }
        if (this.getKb().getAllAttractors().isEmpty()) {
            attractorFrame.put(Keys.USAGE.get(), new LinkedHashMap());
        } else {
            for (AttractorSim attr : this.getKb().getAllAttractors()) {
                theUtil.mapPutSubObject(attractorFrame, Keys.USAGE.get(), attr.name, counts[attr.getRootId()]);
            }
        }
        this.getWriter().add(attractorFrame);
    }

    @Override
    public void consolidate() {
        LinkedHashMap finalData = new LinkedHashMap();
        ArrayList<Map<String, Object>> tempData = this.getWriter().readTempJsonData();
        if (tempData != null) {
            for (Map<String, Object> obj : tempData) {
                String time = String.valueOf(obj.get(Keys.TIME.get()));
                Map attractors = (Map)obj.get(Keys.USAGE.get());
                for (Map.Entry entry : attractors.entrySet()) {
                    String name = (String)entry.getKey();
                    Double val = (Double)entry.getValue();
                    theUtil.mapPutSubObject(finalData, name, time, val);
                }
            }
        }
        this.getWriter().add(finalData);
    }

    private static enum Keys implements Supplier<String>
    {
        TIME("time"),
        USAGE("usage");

        private final String d_val;

        private Keys(String val) {
            this.d_val = val;
        }

        public String toString() {
            return this.d_val.toString();
        }

        @Override
        public String get() {
            return this.d_val;
        }
    }
}

