/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.Tag;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.AOccDataWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;

public class OccDataWriterMultiple
extends AOccDataWriter {
    private static final long serialVersionUID = 1L;
    private final KB d_kb;
    private Map<OccAgent, Writer> d_occDataWriters;

    public OccDataWriterMultiple(KB kb) {
        this.d_kb = kb;
        this.d_occDataWriters = new LinkedIdentityHashMap<OccAgent, Writer>();
        for (OccAgent oa : OccDataWriterMultiple.filterAgents(this.d_kb.getAgents())) {
            this.d_occDataWriters.put(oa, new Writer(this.d_kb, oa));
        }
    }

    @Override
    public void open(Param p) throws FileNotFoundException {
        for (Writer writer : this.d_occDataWriters.values()) {
            writer.open(p);
        }
    }

    @Override
    public void close() {
        for (Writer writer : this.d_occDataWriters.values()) {
            writer.close();
        }
    }

    @Override
    public void writeHeader() {
        for (Writer writer : this.d_occDataWriters.values()) {
            writer.writeHeader();
        }
    }

    @Override
    public void writeFrame(double t, boolean removeFinished) {
        Iterator<Writer> it = this.d_occDataWriters.values().iterator();
        while (it.hasNext()) {
            Writer writer = it.next();
            writer.writeFrame(t);
            if (!removeFinished || !writer.getAgent().isDone()) continue;
            writer.close();
            it.remove();
        }
    }

    @Override
    public void addAgents(double t, Collection<OccAgent> agents) {
        agents = OccDataWriterMultiple.filterAgents(agents);
        Param d_param = this.d_kb.getParams();
        for (OccAgent newAgent : agents) {
            Writer newWriter = new Writer(this.d_kb, newAgent);
            try {
                newWriter.open(d_param);
                newWriter.writeHeader();
                newWriter.writeFrame(t);
                if (!newWriter.getAgent().isDone()) {
                    this.d_occDataWriters.put(newWriter.getAgent(), newWriter);
                    continue;
                }
                newWriter.close();
            }
            catch (FileNotFoundException e) {
                d_param.err.println(e.getLocalizedMessage());
            }
        }
    }

    private static class Writer
    implements Serializable,
    Closeable {
        private static final long serialVersionUID = 1L;
        private KB d_kb;
        private OccAgent d_oa;
        private final SerializedOutputStream d_stream;
        private final CSVWriter d_out;
        private transient List<Tag> d_tags;

        public Writer(KB kb, OccAgent oa) {
            this.d_kb = kb;
            this.d_oa = oa;
            this.d_out = new CSVWriter();
            String fn = kb.getParams().out_occ_individual;
            fn = fn.replace("{id}", String.format("%05d_%s", this.d_oa.getOcc().id, this.d_oa.getOcc().name));
            this.d_stream = new SerializedOutputStream(fn);
            this.d_tags = this.calcPossibleTags();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.d_tags = this.calcPossibleTags();
        }

        private List<Tag> calcPossibleTags() {
            LinkedIdentityHashSet<Tag> tags = new LinkedIdentityHashSet<Tag>();
            OccDataWriterMultiple.calcPossibleTags(this.d_kb, Collections.singleton(this.d_oa), tags);
            return new ArrayList<Tag>(tags);
        }

        private void writeHeader() {
            OccDataWriterMultiple.writeHeader(this.d_out, this.d_kb, this.d_tags);
        }

        public OccAgent getAgent() {
            return this.d_oa;
        }

        public void open(Param p) throws FileNotFoundException {
            this.d_out.open(Output.openTxtStream(this.d_stream));
        }

        @Override
        public void close() {
            this.d_out.close();
        }

        public void writeFrame(double t) {
            OccDataWriterMultiple.writeFrame(this.d_out, this.d_kb, t, this.d_oa, this.d_tags);
            this.d_out.flush();
        }
    }
}

