/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.PointGoal;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.PointSeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.DefaultAiCore;
import inferno.sim.ai.EmptyAiCore;
import inferno.sim.ai.IAiCore;
import inferno.sim.ai.IGoalAiCore;
import java.util.Optional;

public class AiUtil {
    public static IAiCore newCore(OccAgent agent) {
        return agent.getOcc().behavior.isEmpty() ? new EmptyAiCore() : new DefaultAiCore();
    }

    public static IGoalInstance getCurrentGoalInstance(OccAgent agent) {
        return AiUtil.getGoalCore(agent).map(core -> core.getCurrentGoalInstance(agent)).orElse(AiUtil.getDefaultCurrGoal(agent));
    }

    public static ISeekArea getCurrentSeekArea(KB kb, OccAgent agent) {
        return AiUtil.getGoalCore(agent).map(core -> core.getCurrentSeekArea(kb, agent)).orElse(IGoalInstance.getCurrentAreaAsPoint(kb, agent));
    }

    public static ISeekArea getPreviousSeekArea(KB kb, OccAgent agent) {
        return AiUtil.getGoalCore(agent).map(core -> core.getPreviousSeekArea(kb, agent)).orElse(AiUtil.getInitSeekArea(agent));
    }

    public static Optional<IGoalAiCore> getGoalCore(OccAgent agent) {
        IAiCore core = agent.getAiCore();
        return core instanceof IGoalAiCore ? Optional.of((IGoalAiCore)core) : Optional.empty();
    }

    public static PointGoal.Instance getDefaultCurrGoal(OccAgent agent) {
        return new PointGoal(agent.getLoc(), 0.5).begin(null, agent);
    }

    public static PointSeekArea getInitSeekArea(OccAgent agent) {
        return new PointSeekArea(agent.getOcc().initLoc, 0.5, 0);
    }
}

