/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.io.FileUtil;
import inferno.sim.path.PathGen;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.geometry.Util;

public class Param
implements Serializable {
    static final long serialVersionUID = 1L;
    public double max_time = 0.0;
    public boolean show_vis = false;
    @IOFile
    @OutputFile
    public String out_occ_time_history = "vis.pfd";
    @IOFile
    @OutputFile
    public String out_geom_time_history = "geomvis.pfg";
    @IOFile
    @OutputFile
    public String out_summary = "summary.txt";
    @IOFile
    @OutputFile
    public String out_summary_json = "summary.json";
    @IOFile
    @OutputFile
    public String out_performance = "performance.txt";
    @IOFile
    @OutputFile
    public String out_stuck = "stuck.txt";
    @IOFile
    @OutputFile
    public String out_room_usage = "rooms.csv";
    @IOFile
    @OutputFile
    public String out_door_usage = "doors.csv";
    @IOFile
    @OutputFile
    public String out_occ_cumulative = "occupants.csv";
    @IOFile
    @OutputFile
    public String out_occ_detailed = "occupants_detailed.csv";
    @IOFile
    @OutputFile
    public String out_occ_individual = "occupant_{id}.csv";
    @IOFile
    @OutputFile
    public String out_sd_transient = "sd_transient.csv";
    @IOFile
    @OutputFile
    public String out_sd_accumulated = "sd_accumulated.csv";
    @IOFile
    @OutputFile
    public String out_group_info = "groups.csv";
    @IOFile
    @OutputFile
    public String out_attractor_info = "triggers.csv";
    @IOFile
    @OutputFile
    public String out_occtargets_info = "occtargets.csv";
    @IOFile
    @OutputFile
    public String out_dt_info = "dt.csv";
    @IOFile
    @OutputFile
    public String out_occ_params = "occupant_params.csv";
    @IOFile
    @OutputFile
    public String out_clear_times = "clear.csv";
    @IOFile
    @OutputFile
    public String out_snapshot_base = "snapshot";
    @IOFile
    @OutputFile
    public String out_results = "results.pfr";
    @IOFile
    @OutputFile
    public String out_combined_json = "out.json";
    @IOFile
    @OutputFile
    public String out_doors_json = "doors.json";
    @IOFile
    @OutputFile
    public String out_measurement_regions_json = "meaurement_regions.json";
    @IOFile
    @OutputFile
    public String out_rooms_json = "rooms.json";
    @IOFile
    @OutputFile
    public String out_sd_transient_json = "sd_transient.json";
    @IOFile
    @OutputFile
    public String out_sd_accumulated_json = "sd_accumulated.json";
    @IOFile
    @OutputFile
    public String out_occtargets_json = "occtargets.json";
    @IOFile
    @OutputFile
    public String out_attractors_json = "triggers.json";
    @IOFile
    @OutputFile
    public String out_occ_params_json = "occupant_params.json";
    @IOFile
    @OutputFile
    public String out_occ_detailed_json = "occupants_detailed.json";
    @IOFile
    @OutputFile
    public String out_occ_cummulative_json = "occupants.json";
    @IOFile
    @OutputFile
    public String out_occ_individual_json = "occupant_{id}.json";
    @IOFile
    @OutputFile
    public String out_groups_json = "groups.json";
    @IOFile
    public String imported_geom = "importedgeom.geom";
    @IOFile
    public String views = "views.json";
    @IOFile
    public String input = "input.txt";
    @IOFile
    public String in_simulations = "_simulations.json";
    public String scenario = "<default>";
    public String dir;
    public double dt_init = 0.025;
    public double dt_vis = 0.25;
    public double dt_wall_meta = 0.5;
    public double dt_csv_data = 5.0;
    public double dt_snapshot = 120.0;
    public transient PrintStream out = System.out;
    public transient PrintStream err = System.err;
    public transient InputStream in = System.in;
    public PathGen.PathCleanup path_cleanup = PathGen.PathCleanup.IF_NECESSARY;
    public int slower = 0;
    public boolean handle_collisions = false;
    public boolean force_separation = false;
    public boolean reactive_steering = true;
    public boolean inertia = true;
    public boolean vel_from_density = true;
    public double specific_flowrate_max = 1.32;
    public boolean door_flow_from_density = true;
    public double door_flow_density_min = 1.9;
    public double door_flow_density_max = 3.0;
    @Deprecated
    public boolean print_performance = false;
    public double density_max = 3.55;
    public double max_trim_error = Util.inchesToMeters(1.0);
    public double elevator_call_distance = 0.5;
    public double min_repath_dt = 1.0;
    public double max_repath_dt = 4.0;
    public double local_tail_tol_frac = 0.1;
    public double local_speed_avg_time = 2.0;
    public double door_queue_update_interval = 0.1;
    public double max_pathspeed_history = 5.0;
    public double pathspeed_history_freq = 4.0;
    public double door_flowrate_f0 = 0.05;
    public double door_flowrate_Q = 0.5;
    public boolean realtime = false;
    public double boundary_layer = 0.15;
    public boolean shutdown_empty = true;
    public double low_speed_threshold = 0.25;
    public double low_speed_averaging_time = 5.0;
    public boolean occ_csv_file_as_one = false;
    public boolean write_occ_params_file = true;
    public boolean social_distance_csv_output = false;
    public double social_distance_value = 2.0;
    public boolean measurement_region_seekspeed = false;
    public boolean smvDataEnable = false;
    public String smvDataFilePath = null;
    public long smvDataLastModified = 0L;
    public double smvHypoxiaLimit = 0.195;
    public double min_flowrate_factor = 0.1;
    public double attr_default_idle_time = 900.0;
    public double occtarget_conflict_resolve_time = 5.0;
    public boolean enable_json_output = false;
    public double dynamictarget_search_dt = 0.25;

    public Param(String baseName, String simulations, String scenario, String dir) {
        String rootFn;
        this.input = rootFn = baseName.replaceAll(".txt", "");
        this.scenario = scenario;
        this.dir = dir;
        File dirf = new File(dir);
        this.in_simulations = simulations;
        this.out_room_usage = FileUtil.getNodesFn(dirf, rootFn).getPath();
        this.out_door_usage = FileUtil.getDoorsFn(dirf, rootFn).getPath();
        this.out_occ_cumulative = FileUtil.getOccsFn(dirf, rootFn).getPath();
        this.out_occ_detailed = FileUtil.getOccsDetailedFn(dirf, rootFn).getPath();
        this.out_occ_params = FileUtil.getOccParamsFn(dirf, rootFn).getPath();
        this.out_occ_individual = FileUtil.getOccFn(dirf, rootFn).getPath();
        this.out_sd_transient = FileUtil.getSuffixFn(dirf, rootFn, "_sd_transient.csv").getPath();
        this.out_sd_accumulated = FileUtil.getSuffixFn(dirf, rootFn, "_sd_accumulated.csv").getPath();
        this.out_group_info = FileUtil.getSuffixFn(dirf, rootFn, "_groups.csv").getPath();
        this.out_attractor_info = FileUtil.getSuffixFn(dirf, rootFn, "_triggers.csv").getPath();
        this.out_occtargets_info = FileUtil.getSuffixFn(dirf, rootFn, "_occtargets.csv").getPath();
        this.out_dt_info = FileUtil.getSuffixFn(dirf, rootFn, "_dt.csv").getPath();
        this.out_combined_json = FileUtil.getCombinedJsonFn(dirf, rootFn).getPath();
        this.out_doors_json = FileUtil.getDoorsJsonFn(dirf, rootFn).getPath();
        this.out_rooms_json = FileUtil.getRoomsJsonFn(dirf, rootFn).getPath();
        this.out_attractors_json = FileUtil.getAttractorsJsonFn(dirf, rootFn).getPath();
        this.out_summary_json = FileUtil.getSummaryJsonFn(dirf, rootFn).getPath();
        this.out_occ_cummulative_json = FileUtil.getSuffixFn(dirf, rootFn, "_occupants.json").getPath();
        this.out_occ_individual_json = FileUtil.getSuffixFn(dirf, rootFn, "_occupant_{id}.json").getPath();
        this.out_occ_detailed_json = FileUtil.getOccDetailedJsonFn(dirf, rootFn).getPath();
        this.out_measurement_regions_json = FileUtil.getMeasurementRegionsJsonFn(dirf, rootFn).getPath();
        this.out_sd_transient_json = FileUtil.getSdTransientJsonFn(dirf, rootFn).getPath();
        this.out_sd_accumulated_json = FileUtil.getSuffixFn(dirf, rootFn, "_sd_accumulated.json").getPath();
        this.out_occtargets_json = FileUtil.getOccTargetsJsonFn(dirf, rootFn).getPath();
        this.out_occ_params_json = FileUtil.getOccParamsJsonFn(dirf, rootFn).getPath();
        this.out_groups_json = FileUtil.getGroupsJsonFn(dirf, rootFn).getPath();
        this.out_summary = FileUtil.getSummaryFn(dirf, rootFn).getPath();
        this.out_performance = FileUtil.getPerformanceFn(dirf, rootFn).getPath();
        this.out_stuck = FileUtil.getSuffixFn(dirf, rootFn, "_stuck.txt").getPath();
        this.out_snapshot_base = FileUtil.getSnapshotBase(dirf, rootFn).getPath();
        this.out_occ_time_history = FileUtil.getOccHistFn(dirf, rootFn).getPath();
        this.out_geom_time_history = FileUtil.getGeomHistFn(dirf, rootFn).getPath();
        this.out_results = FileUtil.getResultsFn(dirf, rootFn).getPath();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.out = System.out;
        this.err = System.err;
        this.in = System.in;
    }

    public void set(String key, String val) {
        this.set(key, val, null);
    }

    public void set(String key, String val, String absolutePath) {
        block10: {
            if (key.equalsIgnoreCase("out_time_history")) {
                key = "out_occ_time_history";
            }
            try {
                Field f = this.getClass().getField(key);
                Class<?> c = f.getType();
                if (c.getSimpleName().equals("double")) {
                    f.set(this, Double.parseDouble(val));
                    break block10;
                }
                if (c.getSimpleName().equals("int")) {
                    f.set(this, Integer.parseInt(val));
                    break block10;
                }
                if (c.getSimpleName().equals("boolean")) {
                    f.set(this, Integer.parseInt(val) != 0);
                    break block10;
                }
                if (c.getSimpleName().equals("long")) {
                    f.set(this, Long.parseLong(val));
                    break block10;
                }
                if (c.getSimpleName().equals("String")) {
                    if (absolutePath != null && f.isAnnotationPresent(IOFile.class)) {
                        val = new File(absolutePath, val).getAbsolutePath();
                    }
                    f.set(this, val);
                    break block10;
                }
                if (c.isEnum()) {
                    f.set(this, Enum.valueOf(c, val));
                    break block10;
                }
                throw new Exception("Error setting param " + key);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("[0985] " + e.getMessage());
            }
        }
    }

    public Object get(String key) {
        try {
            return this.getClass().getField(key).get(this);
        }
        catch (Exception e) {
            System.err.println("[0986] " + e.getMessage());
            return null;
        }
    }

    public File[] getOuputFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (Field field : this.getClass().getFields()) {
            if (!field.isAnnotationPresent(OutputFile.class)) continue;
            try {
                Object val = field.get(this);
                if (val == null) continue;
                files.add(new File((String)val));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public String toString() {
        Field[] fields;
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (Field fd : fields = this.getClass().getFields()) {
            String name = fd.getName();
            fd.setAccessible(true);
            try {
                boolean tran = Modifier.isTransient(fd.getModifiers());
                if (tran) continue;
                Object obj = fd.get(this);
                fieldMap.put(name, obj);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : fieldMap.entrySet()) {
            sb.append(entry.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IOFile {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OutputFile {
    }
}

