/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.Occupant;
import inferno.data2.PredefTag;
import inferno.data2.Tag;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import thunderheadeng.util.Pair;

public class OccStats
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Collection<OccAgent> getAllAgentsEver(KB kb) {
        ArrayList<OccAgent> allAgentsEver = new ArrayList<OccAgent>(kb.getAllAgentsEver());
        Collections.sort(allAgentsEver, new Comparator<OccAgent>(this){

            @Override
            public int compare(OccAgent o1, OccAgent o2) {
                return Integer.compare(o1.getOcc().id, o2.getOcc().id);
            }
        });
        return allAgentsEver;
    }

    public QuantityStats<OccAgent> getTagStats(KB kb, Tag tag, ToDoubleFunction<Tag.Info> valFunc) {
        return QuantityStats.getStats(kb.getAllAgentsEver(), obj -> valFunc.applyAsDouble(tag.getInfo((OccAgent)obj)));
    }

    public double getFinishTime(OccAgent oa) {
        return oa.getOcc().tFinished;
    }

    public double getExistanceTime(KB kb, OccAgent oa) {
        Occupant occ = oa.getOcc();
        double tend = occ.tFinished;
        if (Double.isNaN(tend)) {
            tend = kb.getCurrentSimTime();
        }
        return tend - occ.tStarted;
    }

    public QuantityStats<?> getFinishTimeStats(KB kb) {
        return QuantityStats.getStats(kb.getAllAgentsEver(), obj -> this.getFinishTime((OccAgent)obj));
    }

    public double getStartTime(OccAgent oa) {
        return oa.getOcc().tStarted;
    }

    public QuantityStats<?> getStartTimeStats(KB kb) {
        return QuantityStats.getStats(kb.getAllAgentsEver(), obj -> this.getStartTime((OccAgent)obj));
    }

    public QuantityStats<OccAgent> getExitTimeStats(KB kb) {
        return this.getTagStats(kb, kb.getPredefTag(PredefTag.EXITED), tinfo -> tinfo.tLastTagged);
    }

    public double getTravelDistance(OccAgent oa) {
        return oa.getOcc().totalDistanceMeters;
    }

    public QuantityStats<OccAgent> getTravelDistanceStats(KB kb) {
        return QuantityStats.getStats(kb.getAllAgentsEver(), obj -> this.getTravelDistance((OccAgent)obj));
    }

    public double getSlowTimeTotal(OccAgent oa) {
        return oa.getStats().tSlowTotal;
    }

    public double getOpenSlowTimeTotal(OccAgent oa) {
        return oa.getStats().tOpenSlowTotal;
    }

    public double getStairsSlowTimeTotal(OccAgent oa) {
        return oa.getStats().tStairsSlowTotal;
    }

    public double getRampsSlowTimeTotal(OccAgent oa) {
        return oa.getStats().tRampsSlowTotal;
    }

    public QuantityStats<?> getSlowTimeTotalStats(KB kb) {
        return QuantityStats.getStats(kb.getAllAgentsEver(), obj -> this.getSlowTimeTotal((OccAgent)obj));
    }

    public double getSlowTimeMc(OccAgent oa) {
        return oa.getStats().tSlowMaxContinuous;
    }

    public QuantityStats<?> getSlowTimeMcStats(KB kb) {
        return QuantityStats.getStats(kb.getAllAgentsEver(), obj -> this.getSlowTimeMc((OccAgent)obj));
    }

    public double getActiveTime(OccAgent oa) {
        return oa.getStats().tActive;
    }

    public int getNumAttractorsUsed(OccAgent oa) {
        return oa.getStats().attractorTime.size();
    }

    public double getTotalAttractorTime(OccAgent oa) {
        return oa.getStats().getTotalAttractorTime();
    }

    public double getAttractorTime(OccAgent oa, AttractorSim attr) {
        return oa.getStats().attractorTime.getOrDefault(attr, 0.0);
    }

    public QuantityStats<OccAgent> getAttractorTimeStats(KB kb, AttractorSim attr) {
        return QuantityStats.getStats(kb.getAllAgentsEver(), obj -> this.getAttractorTime((OccAgent)obj, attr));
    }

    public int getNumOccTargetsUsed(OccAgent oa) {
        return oa.getStats().occTargetTimeActive.size();
    }

    public double getTotalOccTargetTime(OccAgent oa) {
        return oa.getStats().getTotalOccTargetTimeActive();
    }

    public static interface ValueFunction<T> {
        public double getValue(T var1);
    }

    public static class QuantityStats<T> {
        public final int n;
        public final double min;
        public final double max;
        public final double avg;
        public final double stddev;
        public final T minElement;
        public final T maxElement;

        public QuantityStats(int n, double min, double max, double avg, double stddev, T minElement, T maxElement) {
            this.n = n;
            this.min = min;
            this.max = max;
            this.avg = avg;
            this.stddev = stddev;
            this.minElement = minElement;
            this.maxElement = maxElement;
        }

        public static <T> QuantityStats<T> getStats(Collection<T> coll, ValueFunction<T> func) {
            ArrayDeque<Pair<Double, T>> validValues = new ArrayDeque<Pair<Double, T>>();
            for (T obj : coll) {
                double v = func.getValue(obj);
                if (Double.isNaN(v) || Double.isInfinite(v)) continue;
                validValues.add(new Pair<Double, T>(v, obj));
            }
            if (validValues.isEmpty()) {
                return new QuantityStats<Object>(0, 0.0, 0.0, 0.0, 0.0, null, null);
            }
            int n = validValues.size();
            double min = Double.MAX_VALUE;
            T minElement = null;
            T maxElement = null;
            double max = Double.MIN_VALUE;
            double sum = 0.0;
            for (Pair pair : validValues) {
                double d = (Double)pair.v1;
                if (d < min) {
                    min = d;
                    minElement = (T)pair.v2;
                }
                if (d > max) {
                    max = d;
                    maxElement = (T)pair.v2;
                }
                sum += d;
            }
            double avg = sum / (double)n;
            double meanSquareError = 0.0;
            for (Pair pair : validValues) {
                double d = (Double)pair.v1;
                meanSquareError += (d - avg) * (d - avg) / (double)n;
            }
            double stddev = Math.sqrt(meanSquareError);
            return new QuantityStats<Object>(n, min, max, avg, stddev, minElement, maxElement);
        }
    }

    public static class PerAgentData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double tActive = 0.0;
        public double tSlowTotal = 0.0;
        public double tOpenSlowTotal = 0.0;
        public double tStairsSlowTotal = 0.0;
        public double tRampsSlowTotal = 0.0;
        public double tSlowMaxContinuous = 0.0;
        public double tSlowMaxContinuousCurrent = 0.0;
        public final Map<AttractorSim, Double> attractorTime = new IdentityHashMap<AttractorSim, Double>();
        public final Map<OccTarget, Double> occTargetTimeActive = new IdentityHashMap<OccTarget, Double>();
        public final Map<OccTarget, Double> occTargetTimeReserved = new IdentityHashMap<OccTarget, Double>();

        public double getTotalAttractorTime() {
            return PerAgentData.getTotalTime(this.attractorTime);
        }

        public double getTotalOccTargetTimeActive() {
            return PerAgentData.getTotalTime(this.occTargetTimeActive);
        }

        public double getTotalOccTargetTimeReserved() {
            return PerAgentData.getTotalTime(this.occTargetTimeReserved);
        }

        private static double getTotalTime(Map<?, Double> timeMap) {
            return timeMap.values().stream().mapToDouble(d -> d).sum();
        }
    }
}

