/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.Camera;
import inferno.geom.Util;
import inferno.sim.IAgent;
import inferno.sim.KB;
import inferno.sim.Param;
import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class CameraAgent
implements Serializable,
IAgent {
    static final long serialVersionUID = 1L;
    private final Camera d_cam;
    private final PTZInit d_ptzInit;
    private IModifier d_modifier;
    private UpdatePacket d_update;

    public CameraAgent(Camera cam) {
        this.d_cam = cam;
        this.d_modifier = null;
        this.d_update = null;
        this.d_ptzInit = new PTZInit(cam);
    }

    public Camera getCamera() {
        return this.d_cam;
    }

    @Override
    public boolean init(KB kb, Param p) {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public synchronized void setModifier(IModifier modifier) {
        this.d_modifier = modifier;
    }

    public synchronized IModifier getModifier() {
        return this.d_modifier;
    }

    @Override
    public void preMove(KB kb, Param p, double dt) {
        IModifier modifier = this.getModifier();
        this.d_update = modifier != null ? modifier.modify(kb, dt, this) : null;
    }

    @Override
    public void update(KB kb, Param p, double dt) {
        if (this.d_update != null) {
            this.update(kb, p, dt, this.d_update);
            this.d_update = null;
        }
    }

    protected void update(KB kb, Param p, double dt, UpdatePacket update) {
        this.d_cam.set(Camera.PROP_LOC, update.loc);
        this.d_cam.set(Camera.PROP_REF, update.ref);
        this.d_cam.set(Camera.PROP_UP, update.up);
        this.d_cam.set(Camera.PROP_ZOOM, update.zoom);
    }

    public static interface IModifier {
        public UpdatePacket modify(KB var1, double var2, CameraAgent var4);
    }

    private static class UpdatePacket
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Point3d loc;
        public final Point3d ref;
        public final Vector3d up;
        public final double zoom;

        public UpdatePacket(Point3d loc, Point3d ref, Vector3d up, double zoom) {
            this.loc = loc;
            this.ref = ref;
            this.up = up;
            this.zoom = zoom;
        }
    }

    private static class PTZInit
    implements Serializable {
        private static final long serialVersionUID = -480611147931147496L;
        public final Plane3d tiltPlane0;
        public final Vector3d panRef0;
        public final Vector3d tiltRef0;
        public final double initZoom;

        public PTZInit(Camera cam) {
            this.initZoom = cam.get(Camera.PROP_ZOOM);
            Vector3d viewVec = Util3D.vectorN(cam.get(Camera.PROP_LOC), cam.get(Camera.PROP_REF));
            Vector3d panAxis = new Vector3d(cam.get(Camera.PROP_PTZ_ORIENT));
            Util3D.safeNormalize(panAxis, 1.0E-9);
            this.tiltPlane0 = new Plane3d(panAxis, cam.get(Camera.PROP_LOC));
            Vector3d panRef0 = Util.project(viewVec, this.tiltPlane0, true);
            if (panRef0 == null) {
                panRef0 = cam.get(Camera.PROP_UP);
            }
            this.panRef0 = panRef0;
            this.tiltRef0 = Util3D.cross(panRef0, panAxis);
            Util3D.safeNormalize(this.tiltRef0, 1.0E-9);
        }

        public double[] getPanTiltAngles(Camera c, Point3d ref) {
            double tiltAngle;
            Point3d currLoc = c.get(Camera.PROP_LOC);
            Vector3d currView = Util3D.vectorN(currLoc, ref);
            Vector3d projectedVec = Util.project(currView, this.tiltPlane0, true);
            if (projectedVec == null) {
                projectedVec = c.get(Camera.PROP_UP);
                tiltAngle = 1.5707963267948966;
            } else {
                tiltAngle = projectedVec.angle(currView);
            }
            Vector3d panAxis = this.tiltPlane0.getNormal();
            if (currView.dot(panAxis) < 0.0) {
                tiltAngle = -tiltAngle;
            }
            double panAngle = Util3D.angle(this.panRef0, projectedVec, panAxis);
            return new double[]{panAngle, tiltAngle};
        }

        public Vector3d[] rotate(double panAngle, double tiltAngle) {
            Vector3d up = this.tiltPlane0.getNormal();
            AxisAngle4d aa = new AxisAngle4d();
            aa.set(up, panAngle);
            Quat4d pan = new Quat4d();
            pan.set(aa);
            aa.set(this.tiltRef0, tiltAngle);
            Quat4d tilt = new Quat4d();
            tilt.set(aa);
            Quat4d rot = pan;
            rot.mul(tilt);
            Matrix4d rotMat = new Matrix4d();
            rotMat.set(rot);
            Vector3d newUp = Util3D.xform(rotMat, up);
            Vector3d newView = Util3D.xform(rotMat, this.panRef0);
            return new Vector3d[]{newView, newUp};
        }
    }

    public static class AimAt
    implements Serializable,
    IModifier {
        private static final long serialVersionUID = 6566169921335983315L;
        private Point3d d_target;
        private double d_lastPan;
        private double d_lastTilt;

        public AimAt(Point3d target) {
            this.d_target = target;
            this.d_lastPan = Double.NaN;
            this.d_lastTilt = Double.NaN;
        }

        private double clamp(double x, double xmin, double xmax) {
            return Math.min(Math.max(xmin, x), xmax);
        }

        private double getNewValue(double current, double target, Camera.PTZSpec spec, double slowFactor, double dt) {
            double panMax = spec.maxSpeed * slowFactor * dt;
            double dPan = target - current;
            dPan = this.clamp(dPan, -panMax, panMax);
            double pan = current + dPan;
            return this.clamp(pan, spec.rangeMin, spec.rangeMax);
        }

        @Override
        public UpdatePacket modify(KB kb, double dt, CameraAgent camAgent) {
            Camera c = camAgent.getCamera();
            Point3d currLoc = c.get(Camera.PROP_LOC);
            Point3d currRef = c.get(Camera.PROP_REF);
            double[] currPanTilt = camAgent.d_ptzInit.getPanTiltAngles(c, currRef);
            double[] targetPanTilt = camAgent.d_ptzInit.getPanTiltAngles(c, this.d_target);
            Camera.PTZSpec panSpec = c.get(Camera.PROP_PAN_INFO);
            Camera.PTZSpec tiltSpec = c.get(Camera.PROP_TILT_INFO);
            double tPan = Math.abs(targetPanTilt[0] - currPanTilt[0]) / panSpec.maxSpeed;
            double tTilt = Math.abs(targetPanTilt[1] - currPanTilt[1]) / tiltSpec.maxSpeed;
            double pan = currPanTilt[0];
            double tilt = currPanTilt[1];
            if (0.0 < tPan && 0.0 < tTilt) {
                double panSlowFactor = Math.min(1.0, tPan / tTilt);
                double tiltSlowFactor = Math.min(1.0, tTilt / tPan);
                pan = this.getNewValue(currPanTilt[0], targetPanTilt[0], panSpec, panSlowFactor, dt);
                tilt = this.getNewValue(currPanTilt[1], targetPanTilt[1], tiltSpec, tiltSlowFactor, dt);
            } else {
                pan = this.getNewValue(currPanTilt[0], targetPanTilt[0], panSpec, 1.0, dt);
                tilt = this.getNewValue(currPanTilt[1], targetPanTilt[1], tiltSpec, 1.0, dt);
            }
            Vector3d[] newVecs = camAgent.d_ptzInit.rotate(pan, tilt);
            double refDist = currLoc.distance(currRef);
            Point3d newRef = Util3D.add(currLoc, (Tuple3d)Util3D.scale(newVecs[0], refDist));
            Vector3d newUp = newVecs[1];
            if (theUtil.eq0(pan, 0.001) && theUtil.eq0(tilt, 0.001) || theUtil.eq(pan, this.d_lastPan, 1.0E-12) && theUtil.eq(tilt, this.d_lastTilt, 1.0E-12)) {
                camAgent.setModifier(null);
            }
            this.d_lastPan = pan;
            this.d_lastTilt = tilt;
            return new UpdatePacket(c.get(Camera.PROP_LOC), newRef, newUp, c.get(Camera.PROP_ZOOM));
        }
    }

    public static class PTZModifier
    implements Serializable,
    IModifier {
        private static final long serialVersionUID = 1593024149981237332L;
        public final double panWt;
        public final double tiltWt;
        public final double zoomWt;

        public PTZModifier(double panWt, double tiltWt, double zoomWt) {
            this.panWt = panWt;
            this.tiltWt = tiltWt;
            this.zoomWt = zoomWt;
        }

        @Override
        public UpdatePacket modify(KB kb, double dt, CameraAgent cam) {
            Camera c = cam.getCamera();
            Camera.PTZSpec panSpec = c.get(Camera.PROP_PAN_INFO);
            Camera.PTZSpec tiltSpec = c.get(Camera.PROP_TILT_INFO);
            Camera.PTZSpec zoomSpec = c.get(Camera.PROP_ZOOM_INFO);
            Point3d currLoc = c.get(Camera.PROP_LOC);
            Point3d currRef = c.get(Camera.PROP_REF);
            double[] currPanTilt = cam.d_ptzInit.getPanTiltAngles(c, currRef);
            double currPan = currPanTilt[0];
            double pan = PTZModifier.newVal(dt, currPan, this.panWt, panSpec);
            double currTilt = currPanTilt[1];
            double tilt = PTZModifier.newVal(dt, currTilt, this.tiltWt, tiltSpec);
            double currZoom = c.get(Camera.PROP_ZOOM) / cam.d_ptzInit.initZoom;
            double newZoom = PTZModifier.newVal(dt, currZoom, this.zoomWt, zoomSpec) * cam.d_ptzInit.initZoom;
            Vector3d[] newVecs = cam.d_ptzInit.rotate(pan, tilt);
            double refDist = currLoc.distance(currRef);
            Point3d newRef = Util3D.add(currLoc, (Tuple3d)Util3D.scale(newVecs[0], refDist));
            Vector3d newUp = newVecs[1];
            return new UpdatePacket(currLoc, newRef, newUp, newZoom);
        }

        private static boolean isNan(double ... vals) {
            for (double v : vals) {
                if (!Double.isNaN(v)) continue;
                return true;
            }
            return false;
        }

        private static double newVal(double dt, double currVal, double valWt, Camera.PTZSpec spec) {
            double newVal = currVal + valWt * spec.maxSpeed * dt;
            if (newVal > spec.rangeMax) {
                newVal = spec.rangeMax;
            } else if (newVal < spec.rangeMin) {
                newVal = spec.rangeMin;
            }
            return newVal;
        }
    }
}

