/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.CommonAnimTags;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.VehicleBody;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class AgentVehicle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient OccAgent agent;
    private final VehicleBody vehicle;
    private Set<String> vehicleAnimTags;
    private Point3d[] points;
    private double stuckTime;
    private boolean freePass;
    private Vector3d prevOrient;
    private boolean useOuterPoints = false;
    private int correspondingOccCount;

    public AgentVehicle(KB kb, OccAgent agent) {
        assert (agent.getShape() instanceof PolygonShape);
        this.agent = agent;
        this.vehicle = ((PolygonShape)agent.getShape()).vehicleBody;
        this.vehicleAnimTags = CommonAnimTags.NO_ANIMATION.tags;
        Occupant occ = agent.getOcc();
        this.points = this.getUpdatedPoints(occ.loc, occ.orient);
        this.prevOrient = agent.getOcc().orient;
        double area = Util3D.simplePolygonArea(Arrays.asList(this.points));
        double occArea = Math.PI * Math.pow(0.24, 2.0);
        this.correspondingOccCount = (int)Math.round(area / occArea);
        occ.tri.node.changeCorrespondingOccCount(kb, agent, this.correspondingOccCount - 1);
    }

    public void abandon(KB kb, OccAgent agent) {
        agent.getOcc().tri.node.changeCorrespondingOccCount(kb, agent, -this.correspondingOccCount + 1);
    }

    public Set<String> getAnim() {
        return this.vehicleAnimTags;
    }

    public void setAnim(Set<String> anim) {
        this.vehicleAnimTags = anim;
    }

    protected void setAgent(OccAgent agent) {
        this.agent = agent;
    }

    public OccAgent getAgent() {
        return this.agent;
    }

    public Occupant getOcc() {
        return this.agent.getOcc();
    }

    public Point3d[] getPoints() {
        return this.points;
    }

    public AABox getCurrentBoundingBox() {
        return new AABox(this.points);
    }

    protected void preUpdate(KB kb, Param p, double dt) {
        this.updateStuckTime(kb, dt);
        this.useOuterPoints = this.agent.getAssistedEvacClientModule().isPresent() && this.agent.getAssistedEvacClientModule().get().isFullyOccupied();
        this.prevOrient = this.getOcc().orient;
    }

    protected void postUpdate(KB kb, Param p, double dt) {
        Occupant occ = this.getOcc();
        this.points = this.getUpdatedPoints(occ.loc, occ.orient);
        PolygonShape shape = (PolygonShape)occ.bodyShape;
        shape.update(occ.loc, this.points, occ.orient, this.useOuterPoints);
    }

    private void updateStuckTime(KB kb, double dt) {
        if (this.agent.getUpdatePacket() != null) {
            this.stuckTime = this.isStuckOrientSafe(kb) ? this.stuckTime + dt : 0.0;
        }
    }

    protected void init(KB kb, Param p) {
        this.agent.update(kb, p, 0.0);
    }

    public PolygonShape transformShape(Point3d position, Vector3d direction) {
        return this.getShape().transform(position, direction, this.useOuterPoints);
    }

    public PolygonShape rotateShape(Vector3d newDir) {
        return this.rotateShape(this.getShape(), newDir);
    }

    public PolygonShape rotateShape(PolygonShape shape, Vector3d newDir) {
        return shape.transform(this.agent.getPos(), newDir, this.useOuterPoints);
    }

    public Point3d[] getUpdatedPoints(Point3d position, Vector3d direction) {
        return this.getShape().getUpdatedPoints(position, direction, this.useOuterPoints);
    }

    public PolygonShape getShape() {
        return (PolygonShape)this.getOcc().bodyShape;
    }

    public VehicleBody getBody() {
        return this.vehicle;
    }

    public boolean isValid() {
        if (!(this.getOcc().bodyShape instanceof PolygonShape)) {
            return false;
        }
        return this.vehicle == this.getShape().getVehicleBody();
    }

    public double getStuckTime() {
        return this.stuckTime;
    }

    public boolean getFreePass() {
        return this.freePass;
    }

    public void setFreePass(boolean freepass) {
        this.freePass = freepass;
    }

    public boolean isStuckOrient(KB kb) {
        return !this.getOcc().waiting && this.isStuckOrientSafe(kb);
    }

    public boolean isStuckOrientSafe(KB kb) {
        if (this.agent.isDone()) {
            return false;
        }
        return this.agent.isBehaviorSeeking() && (AgentVehicle.compareAngle2d(this.agent.getVel(), this.agent.getSeekDir(), Math.cos(Math.toRadians(89.999))) > 0 || this.agent.isSlow(kb, this.getOcc().vel.length(), 0.5)) && AgentVehicle.compareAngle2d(this.prevOrient, this.getOcc().orient, Math.cos(0.15707963267948966)) <= 0;
    }

    private static int compareAngle2d(Vector3d v1, Vector3d v2, double cosAngle) {
        double ilen1 = 1.0 / AgentVehicle.len2d(v1);
        double ilen2 = 1.0 / AgentVehicle.len2d(v2);
        double dot2d = AgentVehicle.dot(v1.x * ilen1, v1.y * ilen1, v2.x * ilen2, v2.y * ilen2);
        return Double.compare(cosAngle, Math.abs(dot2d));
    }

    private static double len2d(Vector3d v) {
        return Math.sqrt(v.x * v.x + v.y * v.y);
    }

    private static double dot(double v1x, double v1y, double v2x, double v2y) {
        return v1x * v2x + v1y * v2y;
    }

    public boolean isStuckForAtLeast(KB kb, double time) {
        return theUtil.ge(this.stuckTime, time, 1.0E-9) && this.isStuckOrient(kb);
    }

    protected int getCorrespondingOccCount() {
        return this.correspondingOccCount;
    }

    protected List<Point3d> getStaticAttachedAgentsPositions() {
        return this.getBody().getStaticAttachedAgentsPositions();
    }
}

