/*
 * Decompiled with CFR 0.152.
 */
package inferno.io.fdsout;

import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Point3d;

public class XyzData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int ibar1;
    public final int jbar1;
    public final int kbar1;
    public final float[] xs;
    public final float[] ys;
    public final float[] zs;
    public final boolean xConst;
    public final boolean yConst;
    public final boolean zConst;
    public final int[][][] blanks;

    public XyzData(int ibar1, int jbar1, int kbar1, float[] xs, float[] ys, float[] zs, int[][][] blanks) {
        this.ibar1 = ibar1;
        this.jbar1 = jbar1;
        this.kbar1 = kbar1;
        this.xs = xs;
        this.ys = ys;
        this.zs = zs;
        this.xConst = true;
        this.yConst = true;
        this.zConst = true;
        this.blanks = blanks;
    }

    public String toString() {
        return String.format("XyzData[IBAR1=%s,JBAR1=%s,KBAR1=%s,blanks=%s]", this.ibar1, this.jbar1, this.kbar1, Arrays.deepToString((Object[])this.blanks));
    }

    public int[] calcIx(Point3d testLoc) {
        int[] coords = new int[]{XyzData.lookupIx(testLoc.x, this.xs, this.xConst), XyzData.lookupIx(testLoc.y, this.ys, this.yConst), XyzData.lookupIx(testLoc.z, this.zs, this.zConst)};
        return coords;
    }

    private static int lookupIx(double pos, float[] coords, boolean isConstCoords) {
        if (isConstCoords) {
            assert (coords.length >= 2);
            double dx = coords[1] - coords[0];
            double x_min = coords[0];
            return (int)((pos - x_min) / dx);
        }
        int ix = Arrays.binarySearch(coords, (float)pos);
        if (ix < 0) {
            ix = -ix - 1;
        }
        return ix;
    }
}

