/*
 * Decompiled with CFR 0.152.
 */
package inferno.io.fdsout;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayDeque;
import java.util.Arrays;

public class VtkLibLoader {
    public static void discoverLoadOrder(File vtkFolder) {
        ArrayDeque<File> allDlls;
        File[] files = vtkFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("dll");
            }
        });
        ArrayDeque<File> arrayDeque = allDlls = files != null ? new ArrayDeque<File>(Arrays.asList(files)) : new ArrayDeque();
        while (!allDlls.isEmpty()) {
            File dllFile = (File)allDlls.removeFirst();
            try {
                String baseName = dllFile.getName().replace(".dll", "");
                System.loadLibrary(baseName);
                System.out.println("System.loadLibrary(\"" + baseName + "\");");
            }
            catch (UnsatisfiedLinkError e) {
                allDlls.addLast(dllFile);
            }
        }
    }

    public static void loadReq() {
        String[] libs = new String[]{"vtksys-6.3", "vtkCommonCore-6.3", "vtkWrappingJava-6.3", "vtkCommonCoreJava", "vtkCommonMisc-6.3", "vtkCommonSystem-6.3", "vtkCommonMath-6.3", "vtkCommonMathJava", "vtkCommonTransforms-6.3", "vtkCommonTransformsJava", "vtkCommonDataModel-6.3", "vtkCommonDataModelJava", "vtkCommonExecutionModel-6.3", "vtkCommonExecutionModelJava", "vtkFiltersCore-6.3", "vtkFiltersCoreJava"};
        System.out.println("Loading VTK libs...");
        long t = System.nanoTime();
        for (String lib : libs) {
            System.loadLibrary(lib);
        }
        double dt = (double)(System.nanoTime() - t) / 1.0E9;
        System.out.printf("Done (%.3f s)%n", dt);
    }

    public static void loadAll() {
        System.loadLibrary("vtkalglib-6.3");
        System.loadLibrary("vtkDICOMParser-6.3");
        System.loadLibrary("vtkexpat-6.3");
        System.loadLibrary("vtkjpeg-6.3");
        System.loadLibrary("vtkjsoncpp-6.3");
        System.loadLibrary("vtkoggtheora-6.3");
        System.loadLibrary("vtkproj4-6.3");
        System.loadLibrary("vtksys-6.3");
        System.loadLibrary("vtkverdict-6.3");
        System.loadLibrary("vtkzlib-6.3");
        System.loadLibrary("vtkCommonCore-6.3");
        System.loadLibrary("vtkCommonMath-6.3");
        System.loadLibrary("vtkCommonMisc-6.3");
        System.loadLibrary("vtkCommonSystem-6.3");
        System.loadLibrary("vtkCommonTransforms-6.3");
        System.loadLibrary("vtkfreetype-6.3");
        System.loadLibrary("vtkftgl-6.3");
        System.loadLibrary("vtkhdf5-6.3");
        System.loadLibrary("vtkhdf5_hl-6.3");
        System.loadLibrary("vtklibxml2-6.3");
        System.loadLibrary("vtkmetaio-6.3");
        System.loadLibrary("vtkNetCDF-6.3");
        System.loadLibrary("vtkNetCDF_cxx-6.3");
        System.loadLibrary("vtkpng-6.3");
        System.loadLibrary("vtktiff-6.3");
        System.loadLibrary("vtkWrappingJava-6.3");
        System.loadLibrary("vtkCommonColor-6.3");
        System.loadLibrary("vtkCommonCoreJava");
        System.loadLibrary("vtkCommonDataModel-6.3");
        System.loadLibrary("vtkCommonExecutionModel-6.3");
        System.loadLibrary("vtkCommonExecutionModelJava");
        System.loadLibrary("vtkCommonMathJava");
        System.loadLibrary("vtkCommonMiscJava");
        System.loadLibrary("vtkCommonSystemJava");
        System.loadLibrary("vtkCommonTransformsJava");
        System.loadLibrary("vtkexoIIc-6.3");
        System.loadLibrary("vtkFiltersCore-6.3");
        System.loadLibrary("vtkFiltersGeometry-6.3");
        System.loadLibrary("vtkFiltersGeometryJava");
        System.loadLibrary("vtkFiltersHyperTree-6.3");
        System.loadLibrary("vtkFiltersProgrammable-6.3");
        System.loadLibrary("vtkFiltersProgrammableJava");
        System.loadLibrary("vtkFiltersSelection-6.3");
        System.loadLibrary("vtkFiltersSelectionJava");
        System.loadLibrary("vtkFiltersVerdict-6.3");
        System.loadLibrary("vtkFiltersVerdictJava");
        System.loadLibrary("vtkgl2ps-6.3");
        System.loadLibrary("vtkImagingCore-6.3");
        System.loadLibrary("vtkImagingFourier-6.3");
        System.loadLibrary("vtkImagingHybrid-6.3");
        System.loadLibrary("vtkImagingHybridJava");
        System.loadLibrary("vtkImagingMath-6.3");
        System.loadLibrary("vtkImagingMathJava");
        System.loadLibrary("vtkImagingSources-6.3");
        System.loadLibrary("vtkImagingSourcesJava");
        System.loadLibrary("vtkImagingStatistics-6.3");
        System.loadLibrary("vtkImagingStatisticsJava");
        System.loadLibrary("vtkIOCore-6.3");
        System.loadLibrary("vtkIOCoreJava");
        System.loadLibrary("vtkIOEnSight-6.3");
        System.loadLibrary("vtkIOEnSightJava");
        System.loadLibrary("vtkIOGeometry-6.3");
        System.loadLibrary("vtkIOGeometryJava");
        System.loadLibrary("vtkIOImage-6.3");
        System.loadLibrary("vtkIOImageJava");
        System.loadLibrary("vtkIOLegacy-6.3");
        System.loadLibrary("vtkIOLegacyJava");
        System.loadLibrary("vtkIOMovie-6.3");
        System.loadLibrary("vtkIOMovieJava");
        System.loadLibrary("vtkIONetCDF-6.3");
        System.loadLibrary("vtkIONetCDFJava");
        System.loadLibrary("vtkIOPLY-6.3");
        System.loadLibrary("vtkIOPLYJava");
        System.loadLibrary("vtkIOSQL-6.3");
        System.loadLibrary("vtkIOSQLJava");
        System.loadLibrary("vtkIOVideo-6.3");
        System.loadLibrary("vtkIOVideoJava");
        System.loadLibrary("vtkIOXMLParser-6.3");
        System.loadLibrary("vtkIOXMLParserJava");
        System.loadLibrary("vtkParallelCore-6.3");
        System.loadLibrary("vtkParallelCoreJava");
        System.loadLibrary("vtkCommonColorJava");
        System.loadLibrary("vtkCommonComputationalGeometry-6.3");
        System.loadLibrary("vtkCommonDataModelJava");
        System.loadLibrary("vtkFiltersAMR-6.3");
        System.loadLibrary("vtkFiltersAMRJava");
        System.loadLibrary("vtkFiltersCoreJava");
        System.loadLibrary("vtkFiltersGeneral-6.3");
        System.loadLibrary("vtkFiltersGeneralJava");
        System.loadLibrary("vtkFiltersHyperTreeJava");
        System.loadLibrary("vtkFiltersSMP-6.3");
        System.loadLibrary("vtkFiltersSMPJava");
        System.loadLibrary("vtkFiltersSources-6.3");
        System.loadLibrary("vtkFiltersSourcesJava");
        System.loadLibrary("vtkFiltersStatistics-6.3");
        System.loadLibrary("vtkFiltersStatisticsJava");
        System.loadLibrary("vtkFiltersTexture-6.3");
        System.loadLibrary("vtkFiltersTextureJava");
        System.loadLibrary("vtkImagingColor-6.3");
        System.loadLibrary("vtkImagingCoreJava");
        System.loadLibrary("vtkImagingFourierJava");
        System.loadLibrary("vtkImagingGeneral-6.3");
        System.loadLibrary("vtkImagingGeneralJava");
        System.loadLibrary("vtkImagingMorphological-6.3");
        System.loadLibrary("vtkImagingMorphologicalJava");
        System.loadLibrary("vtkImagingStencil-6.3");
        System.loadLibrary("vtkImagingStencilJava");
        System.loadLibrary("vtkIOAMR-6.3");
        System.loadLibrary("vtkIOAMRJava");
        System.loadLibrary("vtkIOExodus-6.3");
        System.loadLibrary("vtkIOExodusJava");
        System.loadLibrary("vtkIOLSDyna-6.3");
        System.loadLibrary("vtkIOLSDynaJava");
        System.loadLibrary("vtkIOXML-6.3");
        System.loadLibrary("vtkIOXMLJava");
        System.loadLibrary("vtkCommonComputationalGeometryJava");
        System.loadLibrary("vtkFiltersExtraction-6.3");
        System.loadLibrary("vtkFiltersExtractionJava");
        System.loadLibrary("vtkFiltersFlowPaths-6.3");
        System.loadLibrary("vtkFiltersFlowPathsJava");
        System.loadLibrary("vtkFiltersGeneric-6.3");
        System.loadLibrary("vtkFiltersGenericJava");
        System.loadLibrary("vtkFiltersImaging-6.3");
        System.loadLibrary("vtkFiltersImagingJava");
        System.loadLibrary("vtkFiltersModeling-6.3");
        System.loadLibrary("vtkFiltersModelingJava");
        System.loadLibrary("vtkImagingColorJava");
        System.loadLibrary("vtkInfovisCore-6.3");
        System.loadLibrary("vtkInfovisCoreJava");
        System.loadLibrary("vtkInfovisLayout-6.3");
        System.loadLibrary("vtkInfovisLayoutJava");
        System.loadLibrary("vtkIOInfovis-6.3");
        System.loadLibrary("vtkIOInfovisJava");
        System.loadLibrary("vtkIOParallelXML-6.3");
        System.loadLibrary("vtkIOParallelXMLJava");
        System.loadLibrary("vtkRenderingCore-6.3");
        System.loadLibrary("vtkRenderingCoreJava");
        System.loadLibrary("vtkRenderingFreeType-6.3");
        System.loadLibrary("vtkRenderingFreeTypeJava");
        System.loadLibrary("vtkRenderingImage-6.3");
        System.loadLibrary("vtkRenderingImageJava");
        System.loadLibrary("vtkRenderingLabel-6.3");
        System.loadLibrary("vtkRenderingLabelJava");
        System.loadLibrary("vtkRenderingLOD-6.3");
        System.loadLibrary("vtkRenderingLODJava");
        System.loadLibrary("vtkRenderingOpenGL-6.3");
        System.loadLibrary("vtkRenderingOpenGLJava");
        System.loadLibrary("vtkRenderingVolume-6.3");
        System.loadLibrary("vtkRenderingVolumeJava");
        System.loadLibrary("vtkRenderingVolumeOpenGL-6.3");
        System.loadLibrary("vtkRenderingVolumeOpenGLJava");
        System.loadLibrary("vtkViewsCore-6.3");
        System.loadLibrary("vtkViewsCoreJava");
        System.loadLibrary("vtkDomainsChemistry-6.3");
        System.loadLibrary("vtkDomainsChemistryJava");
        System.loadLibrary("vtkFiltersHybrid-6.3");
        System.loadLibrary("vtkFiltersHybridJava");
        System.loadLibrary("vtkFiltersParallel-6.3");
        System.loadLibrary("vtkFiltersParallelImaging-6.3");
        System.loadLibrary("vtkFiltersParallelJava");
        System.loadLibrary("vtkInteractionStyle-6.3");
        System.loadLibrary("vtkInteractionStyleJava");
        System.loadLibrary("vtkIOImport-6.3");
        System.loadLibrary("vtkIOImportJava");
        System.loadLibrary("vtkIOMINC-6.3");
        System.loadLibrary("vtkIOMINCJava");
        System.loadLibrary("vtkIOParallel-6.3");
        System.loadLibrary("vtkIOParallelJava");
        System.loadLibrary("vtkRenderingAnnotation-6.3");
        System.loadLibrary("vtkRenderingAnnotationJava");
        System.loadLibrary("vtkRenderingContext2D-6.3");
        System.loadLibrary("vtkRenderingContext2DJava");
        System.loadLibrary("vtkRenderingContextOpenGL-6.3");
        System.loadLibrary("vtkRenderingContextOpenGLJava");
        System.loadLibrary("vtkRenderingGL2PS-6.3");
        System.loadLibrary("vtkRenderingGL2PSJava");
        System.loadLibrary("vtkRenderingLIC-6.3");
        System.loadLibrary("vtkRenderingLICJava");
        System.loadLibrary("vtkViewsContext2D-6.3");
        System.loadLibrary("vtkViewsContext2DJava");
        System.loadLibrary("vtkChartsCore-6.3");
        System.loadLibrary("vtkChartsCoreJava");
        System.loadLibrary("vtkFiltersParallelImagingJava");
        System.loadLibrary("vtkInteractionWidgets-6.3");
        System.loadLibrary("vtkInteractionWidgetsJava");
        System.loadLibrary("vtkIOExport-6.3");
        System.loadLibrary("vtkIOExportJava");
        System.loadLibrary("vtkViewsInfovis-6.3");
        System.loadLibrary("vtkViewsInfovisJava");
        System.loadLibrary("vtkGeovisCore-6.3");
        System.loadLibrary("vtkGeovisCoreJava");
        System.loadLibrary("vtkInteractionImage-6.3");
        System.loadLibrary("vtkInteractionImageJava");
    }

    public static void main(String[] args) {
        String[] libs = new String[]{"vtksys-6.3", "vtkCommonCore-6.3", "vtkWrappingJava-6.3", "vtkCommonCoreJava", "vtkCommonMisc-6.3", "vtkCommonSystem-6.3", "vtkCommonMath-6.3", "vtkCommonMathJava", "vtkCommonTransforms-6.3", "vtkCommonTransformsJava", "vtkCommonDataModel-6.3", "vtkCommonDataModelJava", "vtkCommonExecutionModel-6.3", "vtkCommonExecutionModelJava", "vtkFiltersCore-6.3", "vtkFiltersCoreJava"};
        String[] clazzes = new String[]{"vtk.vtkDataObject", "vtk.vtkFloatArray", "vtk.vtkMultiPieceDataSet", "vtk.vtkRectilinearGrid", "vtk.vtkCompositeDataProbeFilter", "vtk.vtkDataArray", "vtk.vtkDataObject", "vtk.vtkDataSet", "vtk.vtkPoints", "vtk.vtkUnstructuredGrid"};
        for (String lib : libs) {
            try {
                System.out.print("Loading library \"" + lib + "\"...");
                System.loadLibrary(lib);
                System.out.println("LOADED");
            }
            catch (Throwable e) {
                System.out.println("ERROR");
            }
        }
        System.out.println();
        for (String clazz : clazzes) {
            try {
                System.out.print("Loading class \"" + clazz + "\"...");
                Class<?> c = Class.forName(clazz);
                c.newInstance();
                System.out.println("LOADED");
            }
            catch (Throwable e) {
                System.out.println("ERROR");
            }
        }
    }
}

