/*
 * Decompiled with CFR 0.152.
 */
package inferno.io.fdsout;

import inferno.io.fdsout.DataFinder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.vecmath.Point3d;
import vtk.vtkCharArray;
import vtk.vtkCompositeDataProbeFilter;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkFloatArray;
import vtk.vtkObject;
import vtk.vtkPointData;
import vtk.vtkPoints;
import vtk.vtkUnstructuredGrid;

public class DataInquisitor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long GC_DELAY_MS = 1000L;
    private transient List<CacheObj> d_cachePlot3dData = new ArrayList<CacheObj>(2);
    private transient long d_lastGc = Long.MIN_VALUE;
    private DataFinder d_source;
    private long d_lastUpdate;

    public DataInquisitor(DataFinder source) {
        this.d_source = source;
        this.d_lastUpdate = Long.MIN_VALUE;
    }

    public void cleanup() {
        this.d_cachePlot3dData.clear();
        vtkObject.JAVA_OBJECT_MANAGER.gc(false);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.d_cachePlot3dData = new ArrayList<CacheObj>(2);
        this.d_lastGc = Long.MIN_VALUE;
    }

    public String toString() {
        return String.format("DataInquisitor[d_source=%s,d_lastUpdate=%s]", this.d_source.getClass().getSimpleName(), this.d_lastUpdate);
    }

    public double[] getTimeRange() {
        Float[] times = this.d_source.getTimes();
        if (times.length < 2) {
            return new double[]{0.0, 0.0};
        }
        return new double[]{times[0].floatValue(), times[times.length - 1].floatValue()};
    }

    public DataFinder.Quantity[] getQuantities() {
        try {
            this.update();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.d_source.getQuantities();
    }

    public void update() throws IOException {
        if (this.d_lastUpdate < this.d_source.getLastModified()) {
            this.d_source.update();
            this.d_lastUpdate = this.d_source.getLastModified();
        }
    }

    public double[][] probeInterp(float t, List<Point3d> pts) {
        Object[] times = this.d_source.getTimes();
        if (times.length == 0) {
            return new double[0][];
        }
        int pos = Arrays.binarySearch(times, Float.valueOf(t));
        if (0 <= pos) {
            return this.probeDirect(pos, pts);
        }
        int insertAt = -(pos + 1);
        if (insertAt == 0) {
            return this.probeDirect(0, pts);
        }
        if (insertAt == times.length) {
            return this.probeDirect(insertAt - 1, pts);
        }
        double dt = ((Float)times[insertAt]).floatValue() - ((Float)times[insertAt - 1]).floatValue();
        double f1 = (double)(t - ((Float)times[insertAt - 1]).floatValue()) / dt;
        double f0 = 1.0 - f1;
        double[][] v0 = this.probeDirect(insertAt - 1, pts);
        double[][] v1 = this.probeDirect(insertAt, pts);
        double[][] v = new double[pts.size()][v0[0].length];
        for (int j = 0; j < pts.size(); ++j) {
            for (int i = 0; i < v[j].length; ++i) {
                v[j][i] = f0 * v0[j][i] + f1 * v1[j][i];
            }
        }
        return v;
    }

    private vtkDataObject memoGetVtkDataAt(int tPos) {
        Optional<CacheObj> foundOpt = this.d_cachePlot3dData.stream().filter(obj -> obj.tPos == tPos).findFirst();
        if (foundOpt.isPresent()) {
            return foundOpt.get().value;
        }
        vtkDataObject plt3dData = this.d_source.getVtkDataAt(tPos);
        CacheObj obj2 = new CacheObj(tPos, plt3dData);
        if (this.d_cachePlot3dData.size() >= 2) {
            this.d_cachePlot3dData.remove(0);
            assert (this.d_cachePlot3dData.size() == 1);
        }
        this.d_cachePlot3dData.add(obj2);
        assert (0 < this.d_cachePlot3dData.size() && this.d_cachePlot3dData.size() <= 2);
        return obj2.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[][] probeDirect(int tPos, List<Point3d> ptsJava) {
        try {
            double[][] dArray = this.probeDirectVTK(tPos, ptsJava);
            return dArray;
        }
        finally {
            if (this.d_lastGc + 1000L <= System.currentTimeMillis()) {
                vtkObject.JAVA_OBJECT_MANAGER.gc(false);
                this.d_lastGc = System.currentTimeMillis();
            }
        }
    }

    private double[][] probeDirectVTK(int tPos, List<Point3d> ptsJava) {
        vtkDataObject plt3dData = this.memoGetVtkDataAt(tPos);
        vtkPoints pts = new vtkPoints();
        float[] ptsJavaArr = new float[ptsJava.size() * 3];
        int ix = 0;
        for (Point3d p : ptsJava) {
            ptsJavaArr[ix++] = (float)p.x;
            ptsJavaArr[ix++] = (float)p.y;
            ptsJavaArr[ix++] = (float)p.z;
        }
        vtkFloatArray vtkArray = new vtkFloatArray();
        vtkArray.SetNumberOfComponents(3);
        vtkArray.SetJavaArray(ptsJavaArr);
        pts.SetData(vtkArray);
        vtkUnstructuredGrid ptsGrid = new vtkUnstructuredGrid();
        ptsGrid.SetPoints(pts);
        vtkCompositeDataProbeFilter probe = new vtkCompositeDataProbeFilter();
        probe.SetSourceData(plt3dData);
        probe.SetInputData(ptsGrid);
        probe.SetPassPartialArrays(true);
        probe.Update();
        return this.dataSetToArray(probe.GetOutput());
    }

    private double[][] dataSetToArray(vtkDataSet ds) {
        int n = ds.GetNumberOfPoints();
        vtkPointData pd = ds.GetPointData();
        int numArrays = pd.GetNumberOfArrays();
        double[][] values = new double[ds.GetNumberOfPoints()][numArrays];
        for (int ai = 0; ai < numArrays; ++ai) {
            int i;
            vtkDataArray array = pd.GetArray(ai);
            if (array instanceof vtkFloatArray) {
                float[] arr = ((vtkFloatArray)array).GetJavaArray();
                for (i = 0; i < n; ++i) {
                    values[i][ai] = arr[i];
                }
                continue;
            }
            if (array instanceof vtkCharArray) {
                char[] arr = ((vtkCharArray)array).GetJavaArray();
                for (i = 0; i < n; ++i) {
                    values[i][ai] = arr[i];
                }
                continue;
            }
            for (int i2 = 0; i2 < n; ++i2) {
                values[i2][ai] = array.GetTuple1(i2);
            }
        }
        return values;
    }

    private record CacheObj(int tPos, vtkDataObject value) {
    }
}

