/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.TriPoint;
import inferno.geom.ConnectedMesh;
import inferno.geom.IValueField;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.TriInterpolator3d;
import thunderheadeng.geometry.Util3D;

public class VectorFld
implements Serializable,
IValueField<Vector3d> {
    static final long serialVersionUID = 1L;
    public final ConnectedMesh mesh;
    public final TriInterpolator3d[] triInterp;
    public final int[] vertSinks;

    public VectorFld(ConnectedMesh mesh, TriInterpolator3d[] triInfo, int[] vertSinks) {
        this.mesh = mesh;
        this.triInterp = triInfo;
        this.vertSinks = vertSinks;
    }

    @Override
    public Vector3d getValue(TriPoint tp) {
        ConnectedMesh.Tri tri = this.mesh.find(tp.p);
        if (tri == null) {
            return null;
        }
        return this.getValue(tri, tp.p);
    }

    private Vector3d getMinDir(ConnectedMesh.Vertex vert) {
        int adjId = this.vertSinks[vert.id];
        ConnectedMesh.Vertex sinkVert = this.mesh.verts[adjId];
        Vector3d v = Util3D.vector(vert.p, sinkVert.p);
        Util3D.safeNormalize(v, 0.0);
        return v;
    }

    public Vector3d getValue(ConnectedMesh.Tri tri, Point3d p) {
        Vector3d[] vvals = new Vector3d[3];
        for (int m = 0; m < 3; ++m) {
            ConnectedMesh.Vertex v = tri.verts[m];
            vvals[m] = this.getMinDir(v);
        }
        TriInterpolator3d interp = this.triInterp[tri.id];
        double[] params = interp.getParams(p);
        Vector3d result = new Vector3d(interp.interpolate(params, vvals[0].x, vvals[1].x, vvals[2].x), interp.interpolate(params, vvals[0].y, vvals[1].y, vvals[2].y), interp.interpolate(params, vvals[0].z, vvals[1].z, vvals[2].z));
        Util3D.safeNormalize(result, 0.0);
        return result;
    }
}

