/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.TriPoint;
import inferno.geom.ConnectedMesh;
import inferno.geom.IValueField;
import inferno.geom.Util;
import inferno.geom.ValueFld;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.TriInterpolator3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.BiDoublePredicate;

public class NodeValueToVectorFld
implements Serializable,
IValueField<Vector3d> {
    static final long serialVersionUID = 1L;
    public final ValueFld values;
    public final BiDoublePredicate less;

    public NodeValueToVectorFld(ValueFld values, BiDoublePredicate less) {
        this.values = values;
        this.less = less;
    }

    @Override
    public Vector3d getValue(TriPoint tp) {
        ConnectedMesh.Tri tri = this.values.mesh.find(tp.p);
        if (tri == null) {
            return null;
        }
        return this.getValue(tri, tp.p);
    }

    private Vector3d getMinDir(ConnectedMesh.Vertex vert) {
        double minVal = this.values.vertVals.applyAsDouble(vert.id);
        ConnectedMesh.Vertex minVert = vert;
        block0: for (ConnectedMesh.Tri tri : vert.tris) {
            for (int m = 0; m < 3; ++m) {
                if (tri.verts[m] != vert) continue;
                ConnectedMesh.Vertex nvert = tri.verts[Util.PLUS1MOD3[m]];
                ConnectedMesh.Vertex pvert = tri.verts[Util.MINUS1MOD3[m]];
                double vn = this.values.vertVals.applyAsDouble(nvert.id);
                double vp = this.values.vertVals.applyAsDouble(pvert.id);
                if (this.less.test(vn, minVal)) {
                    minVal = vn;
                    minVert = nvert;
                }
                if (!this.less.test(vp, minVal)) continue block0;
                minVal = vp;
                minVert = pvert;
                continue block0;
            }
        }
        if (minVert == vert) {
            return GeomConstants.VEC3D_ZERO;
        }
        Vector3d v = Util3D.vector(vert.p, minVert.p);
        Util3D.safeNormalize(v, 0.0);
        return v;
    }

    public Vector3d getValue(ConnectedMesh.Tri tri, Point3d p) {
        Vector3d[] vvals = new Vector3d[3];
        for (int m = 0; m < 3; ++m) {
            ConnectedMesh.Vertex v = tri.verts[m];
            vvals[m] = this.getMinDir(v);
        }
        TriInterpolator3d interp = this.values.triInfo[tri.id];
        double[] params = interp.getParams(p);
        Vector3d result = new Vector3d(interp.interpolate(params, vvals[0].x, vvals[1].x, vvals[2].x), interp.interpolate(params, vvals[0].y, vvals[1].y, vvals[2].y), interp.interpolate(params, vvals[0].z, vvals[1].z, vvals[2].z));
        Util3D.safeNormalize(result, 0.0);
        return result;
    }
}

