/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.elevator.ElevatorLevel;
import inferno.elevator.IElevatorSorter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PrioritySorter
implements IElevatorSorter {
    private static final long serialVersionUID = 1L;
    public final List<Integer> d_priorityFloors;
    private transient Map<Integer, Integer> d_levelIxes;

    public PrioritySorter(List<Integer> priorityFloors) {
        this.d_priorityFloors = priorityFloors;
        this.d_levelIxes = this.getIxes();
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_levelIxes = this.getIxes();
    }

    private Map<Integer, Integer> getIxes() {
        HashMap<Integer, Integer> ixes = new HashMap<Integer, Integer>();
        for (int m = 0; m < this.d_priorityFloors.size(); ++m) {
            ixes.put(this.d_priorityFloors.get(m), m);
        }
        return ixes;
    }

    @Override
    public int compare(ElevatorLevel elevLvl1, ElevatorLevel elevLvl2) {
        int priorityIndex1 = this.d_levelIxes.getOrDefault(elevLvl1.levelId, -1);
        int priorityIndex2 = this.d_levelIxes.getOrDefault(elevLvl2.levelId, -1);
        if (priorityIndex1 != -1 && priorityIndex2 != -1) {
            return priorityIndex1 - priorityIndex2;
        }
        if (priorityIndex1 != -1 && priorityIndex2 == -1) {
            return -1;
        }
        if (priorityIndex1 == -1 && priorityIndex2 != -1) {
            return 1;
        }
        double z1 = elevLvl1.pickupNode.getGeometryBounds().getMinZ();
        double z2 = elevLvl2.pickupNode.getGeometryBounds().getMinZ();
        return -Double.compare(z1, z2);
    }

    @Override
    public List<Integer> getPriorityFloors() {
        return this.d_priorityFloors;
    }
}

