/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import common.data.ElevatorType;
import inferno.data2.ANode;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.IElevatorSorter;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.util.Collection;
import java.util.List;

public interface IElevator {
    public void init();

    public void endInit();

    public void update(KB var1);

    public Elevator.ElevatorState getState();

    public String getName();

    public void beginState(KB var1, Elevator.ElevatorState var2);

    public void updateState(KB var1);

    public void beginPickup(KB var1, int var2);

    public void changePickupTo(double var1, int var3);

    public ElevatorLevel getLevel(int var1);

    public List<ElevatorLevel> getLevels();

    public Collection<ElevatorLevel> getInServiceLevels();

    public Collection<ElevatorLevel> getOutOfServiceLevels();

    public void addLevel(ElevatorLevel var1);

    public void addLevels(List<ElevatorLevel> var1);

    public ElevatorLevel getLowerLevelFor(ElevatorLevel var1);

    public ElevatorLevel getUpperLevelFor(ElevatorLevel var1);

    public ElevatorLevel getActiveLevel();

    default public ElevatorLevel getDefaultDischargeLevel() {
        return this.getTravelingNode().getElevatorLevel();
    }

    public ElevatorLevel getTargetLevel();

    public ANode getTravelingNode();

    public ANode getTravelingNodeFor(ElevatorLevel var1);

    public ANode getDischargeNodeFor(ElevatorLevel var1, OccAgent var2);

    public ANode getInitNode();

    public ElevatorLevel getCurrentLevel();

    public List<Integer> getTopPriorityFloors();

    public void setFloorPriority(IElevatorSorter var1);

    public double getCallDistance();

    public boolean isDoubleDeck();

    public double getOpenTime();

    public double getCloseDelay();

    public double getSizeFactor();

    public double getMaxDensity();

    public int getNominalLoad();

    public ElevatorType getType();

    public Elevator.Direction getLastTravelDir();

    default public Elevator.Direction getDirection(int from, int to) {
        if (from == to) {
            return Elevator.Direction.SAME;
        }
        ElevatorLevel fromLevel = this.getLevel(from);
        if (fromLevel == null) {
            return Elevator.Direction.INDETERMINATE;
        }
        ElevatorLevel toLevel = this.getLevel(to);
        if (toLevel == null) {
            return Elevator.Direction.INDETERMINATE;
        }
        return fromLevel.pickupNode.getGeometryBounds().getMinZ() <= toLevel.pickupNode.getGeometryBounds().getMinZ() ? Elevator.Direction.UP : Elevator.Direction.DOWN;
    }
}

