/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import inferno.data2.ANode;
import inferno.data2.ai.IGoal;
import inferno.elevator.ClosestSorter;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorGoal;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ElevatorModel;
import inferno.elevator.PrioritySorter;
import inferno.parse2.SimpleParser;
import inferno.sim.Param;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ElevatorParserTxt {
    public static void parse(Param p, ElevatorModel elevModel, List<ANode> nodes, List<String> elevatorLines, List<String> elevatorDischargeLines, List<String> elevatorLevelDataLines, List<String> elevatorPriorityLines, List<String> elevatorLinkLines, List<String> elevatorTimingModelLines) throws IOException {
        IdentityHashMap<Integer, IElevatorTimingModel> timingModels = ElevatorParserTxt.parseElevatorTimingModels(elevatorTimingModelLines);
        for (int i = 0; i < elevatorDischargeLines.size(); ++i) {
            String elevatorLine = !elevatorLines.isEmpty() ? elevatorLines.get(i) : null;
            ElevatorParserTxt.parseElevatorDischarge(p, elevModel, nodes, timingModels, elevatorDischargeLines.get(i), elevatorLine);
        }
        for (String line : elevatorLevelDataLines) {
            ElevatorParserTxt.parseElevatorLevelData(elevModel, nodes, line);
        }
        for (String line : elevatorPriorityLines) {
            ElevatorParserTxt.parseElevatorPriority(elevModel, line);
        }
        for (String line : elevatorLinkLines) {
            ElevatorParserTxt.parseElevatorLink(elevModel, line);
        }
        for (Elevator elevator : elevModel.getElevators()) {
            elevator.endInit();
        }
    }

    public static void parseElevatorDischarge(Param params, ElevatorModel elevModel, List<ANode> nodes, Map<Integer, IElevatorTimingModel> timingModels, String line, String elevatorLine) throws IOException {
        String[] tokens = SimpleParser.getTokens(line, true);
        int dischargeNodeId = Integer.parseInt(tokens[0]);
        ANode dischargeNode = nodes.get(dischargeNodeId);
        double openTime = Double.parseDouble(tokens[1]);
        double closeDelay = Double.parseDouble(tokens[2]);
        double szFactor = Double.parseDouble(tokens[3]);
        double maxDensity = Double.parseDouble(tokens[4]);
        String name = "";
        String type = "";
        boolean isDoubleDeck = false;
        double callDistance = params.elevator_call_distance;
        ANode initNode = dischargeNode;
        IElevatorTimingModel timingModel = IElevatorTimingModel.DEF_MODEL;
        if (elevatorLine != null) {
            try {
                JSONObject json = SimpleParser.getJsonLine(elevatorLine, false);
                name = (String)json.get("name");
                type = (String)((Object)json.getOrDefault("type", ElevatorType.EVAC));
                isDoubleDeck = (Boolean)json.get("double_deck");
                callDistance = (Double)json.get("call_distance");
                int initNodeId = (int)((Long)json.get("initial_floor")).longValue();
                if (json.containsKey("timing_model")) {
                    timingModel = timingModels.get((int)((Long)json.get("timing_model")).longValue());
                }
                initNode = nodes.get(initNodeId);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Elevator elev = new Elevator(name, ElevatorType.valueOf(type), dischargeNode, openTime, closeDelay, szFactor, maxDensity, initNode, callDistance, isDoubleDeck, timingModel);
        elevModel.addElevator(elev);
    }

    public static void parseElevatorLevelData(ElevatorModel elevModel, List<ANode> nodes, String line) throws IOException {
        double closeTime;
        double openTime;
        String[] tokens = SimpleParser.getTokens(line, false);
        int elevatorId = Integer.parseInt(tokens[0]);
        int pickupNodeId = Integer.parseInt(tokens[1]);
        ANode pickupNode = nodes.get(pickupNodeId);
        int levelId = Integer.parseInt(tokens[2]);
        int tokix = 3;
        if (tokens.length >= 6) {
            openTime = Double.parseDouble(tokens[tokix++]);
            closeTime = Double.parseDouble(tokens[tokix++]);
        } else {
            closeTime = 0.0;
            openTime = 0.0;
        }
        double tFirstAvailable = Double.parseDouble(tokens[tokix++]);
        boolean isEnabled = tFirstAvailable != Double.POSITIVE_INFINITY;
        Elevator elev = elevModel.getElevator(elevatorId);
        ElevatorLevel elevLvl = new ElevatorLevel(levelId, pickupNode, openTime, closeTime, tFirstAvailable, isEnabled);
        pickupNode.setElevatorLevel(elevLvl);
        elev.addLevel(elevLvl);
    }

    public static void parseElevatorLink(ElevatorModel elevModel, String line) throws IOException {
        String[] tokens = SimpleParser.getTokens(line, false);
        ArrayDeque<Elevator> linkedElevs = new ArrayDeque<Elevator>();
        for (String elevIdStr : tokens) {
            int elevId = Integer.parseInt(elevIdStr);
            Elevator elev = elevModel.getElevator(elevId);
            linkedElevs.add(elev);
        }
        elevModel.linkElevators(linkedElevs);
    }

    public static IdentityHashMap<Integer, IElevatorTimingModel> parseElevatorTimingModels(List<String> elevatorTimingModelLines) throws IOException {
        IdentityHashMap<Integer, IElevatorTimingModel> timingModels = new IdentityHashMap<Integer, IElevatorTimingModel>();
        for (int i = 0; i < elevatorTimingModelLines.size(); ++i) {
            double defaultVel;
            String line = elevatorTimingModelLines.get(i);
            JSONObject jsonModel = SimpleParser.getJsonLine(line, true);
            JSONArray values = (JSONArray)jsonModel.get("values");
            String type = jsonModel.get("type").toString();
            if (type.equals("acc")) {
                double accel = (Double)values.get(0);
                double maxVel = (Double)values.get(1);
                timingModels.put(i, new IElevatorTimingModel.AccelModel(accel, maxVel));
                continue;
            }
            if (type.equals("vel")) {
                double vel = (Double)values.get(0);
                timingModels.put(i, new IElevatorTimingModel.VelModel(vel));
                continue;
            }
            if (!type.equals("leg")) continue;
            HashMap<Double, Double> timingMap = new HashMap<Double, Double>();
            for (int jix = 0; jix < values.size(); ++jix) {
                JSONArray times = (JSONArray)values.get(jix);
                timingMap.put((Double)times.get(0), (Double)times.get(1));
            }
            if (jsonModel.containsKey("def_vel")) {
                defaultVel = (Double)jsonModel.get("def_vel");
            } else {
                double max = (Double)Collections.max(timingMap.keySet());
                defaultVel = max / (Double)timingMap.get(max);
            }
            timingModels.put(i, new IElevatorTimingModel.DistModel(timingMap, defaultVel));
        }
        return timingModels;
    }

    public static void parseElevatorPriority(ElevatorModel elevModel, String line) {
        String[] tokens = SimpleParser.getTokens(line, false);
        int elevId = Integer.parseInt(tokens[0]);
        Elevator elev = elevModel.getElevator(elevId);
        if (elev.getType().equals(ElevatorType.SCAN)) {
            elev.setFloorPriority(new ClosestSorter(elev));
        } else {
            ArrayList<Integer> priorityFloorIds = new ArrayList<Integer>();
            for (int i = 1; i < tokens.length; ++i) {
                String tok = tokens[i];
                priorityFloorIds.add(Integer.parseInt(tok));
            }
            elev.setFloorPriority(new PrioritySorter(priorityFloorIds));
        }
    }

    public static IGoal parseElevatorGoal(ElevatorModel elevModel, List<String> tokensOnLine) {
        assert (tokensOnLine.size() > 2);
        assert ("GOTO".equalsIgnoreCase(tokensOnLine.get(0)));
        assert ("ELEVATOR".equalsIgnoreCase(tokensOnLine.get(1)));
        List<String> args = tokensOnLine.subList(2, tokensOnLine.size());
        if ("ANY".equalsIgnoreCase(args.get(0))) {
            return new ElevatorGoal(true, elevModel.getElevators(), Integer.parseInt(args.get(1)));
        }
        ArrayList<Elevator> goalElevs = new ArrayList<Elevator>();
        for (int i = 0; i < args.size() - 1; ++i) {
            int elevatorIx = Integer.parseInt(args.get(i));
            assert (0 <= elevatorIx && elevatorIx < elevModel.getNumElevators());
            goalElevs.add(elevModel.getElevator(elevatorIx));
        }
        boolean all = elevModel.getNumElevators() == goalElevs.size();
        return new ElevatorGoal(all, Collections.unmodifiableList(goalElevs), Integer.parseInt(args.get(args.size() - 1)));
    }
}

