/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.sim.KB;
import java.util.Collection;
import java.util.Optional;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public abstract class AElevatorScheduler<ElevatorType extends Elevator> {
    public void processHallCalls(KB kb, Elevator elevator) {
        ElevatorLevel newPickup;
        Collection<ElevatorLevel> elevatorLevels = elevator.getInServiceLevels();
        Elevator.ElevatorState state = elevator.getState();
        if (state == Elevator.ElevatorState.READY) {
            ElevatorLevel callLvl = this.getTopPriorityHallCall(elevator, elevatorLevels);
            if (callLvl != null) {
                elevator.beginPickup(kb, callLvl.levelId);
            }
        } else if (state == Elevator.ElevatorState.MOVING_TO_FLOOR && (newPickup = this.shouldReRouteTo(elevator, elevatorLevels)) != null) {
            elevator.changePickupTo(kb.getCurrentSimTime(), newPickup.levelId);
        }
    }

    public void processDischargeCalls(KB kb, Elevator elevator) {
        IFilteredCollection<ElevatorLevel> dischargeLevels = theUtil.filter(elevator.getInServiceLevels(), level -> level.isDischargeRequested() && elevator.isLevelInService(level.levelId));
        Optional<ElevatorLevel> priorityLevel = dischargeLevels.stream().min(elevator.getFloorSorter());
        if (elevator.getState() == Elevator.ElevatorState.READY && priorityLevel.isPresent()) {
            elevator.beginDischarge(kb, priorityLevel.get().levelId);
        }
    }

    abstract ElevatorLevel getTopPriorityHallCall(Elevator var1, Collection<ElevatorLevel> var2);

    abstract ElevatorLevel shouldReRouteTo(Elevator var1, Collection<ElevatorLevel> var2);
}

