/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.value;

import inferno.data2.value.IFunction1d;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.util.theUtil;

public class ImpulseFunction1d
implements IFunction1d,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double defaultValue;
    public final List<Pulse> entries;

    public ImpulseFunction1d(double defValue, List<Pulse> entries) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.defaultValue = defValue;
        this.entries = entries;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ImpulseFunction1d f = (ImpulseFunction1d)obj;
        return this.defaultValue == f.defaultValue && this.entries.equals(f.entries);
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.entries);
    }

    public ImpulseFunction1d optimize() {
        int toCombine;
        ArrayList<Pulse> newEntries = new ArrayList<Pulse>(this.entries.size());
        for (int m = 0; m < this.entries.size(); m += toCombine) {
            toCombine = 1;
            Pulse prev = this.entries.get(m);
            double y = prev.y;
            int n = m + 1;
            while (n < this.entries.size()) {
                Pulse curr = this.entries.get(n);
                if (!theUtil.eq(prev.getX2(), curr.x, 1.0E-12) || curr.y != y) break;
                prev = curr;
                ++n;
                ++toCombine;
            }
            if (toCombine == 1) {
                newEntries.add(this.entries.get(m));
                continue;
            }
            Pulse first = this.entries.get(m);
            Pulse last = this.entries.get(m + toCombine - 1);
            newEntries.add(new Pulse(first.x, last.getX2() - first.x, y));
        }
        if (newEntries.size() == this.entries.size()) {
            return this;
        }
        newEntries.trimToSize();
        return new ImpulseFunction1d(this.defaultValue, newEntries);
    }

    @Override
    public double getEndX() {
        if (this.defaultValue != 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        for (int m = this.entries.size() - 1; m >= 0; --m) {
            Pulse entry = this.entries.get(m);
            if (entry.y == 0.0) continue;
            return entry.getX2();
        }
        return 0.0;
    }

    @Override
    public double get(double x) {
        if (this.entries.isEmpty()) {
            return this.defaultValue;
        }
        int ix = this.indexOf(x);
        return ix >= 0 ? this.entries.get((int)ix).y : this.defaultValue;
    }

    public int indexOf(double x) {
        assert (!this.entries.isEmpty());
        int ix = Collections.binarySearch(theUtil.map(this.entries, e -> e.x), x);
        if (ix >= 0) {
            return ix;
        }
        if ((ix = -ix - 2) < 0) {
            return -1;
        }
        Pulse entry = this.entries.get(ix);
        if (x > entry.getX2()) {
            return -(ix + 1) - 1;
        }
        return ix;
    }

    @Override
    public double getAUC(double from, double to) {
        if (this.entries.isEmpty()) {
            return (to - from) * this.defaultValue;
        }
        double tFrom = from;
        double tTo = to;
        assert (tFrom <= tTo);
        if (tFrom == tTo) {
            return 0.0;
        }
        int ix1 = this.indexOf(tFrom);
        int ix2 = this.indexOf(tTo);
        double uac = 0.0;
        if (ix1 < 0) {
            if (ix1 == ix2) {
                return (tTo - tFrom) * this.defaultValue;
            }
            ix1 = -ix1 - 1;
            assert (ix1 < this.entries.size());
            Pulse entry1 = this.entries.get(ix1);
            assert (entry1.x >= tFrom);
            uac += (entry1.x - tFrom) * this.defaultValue;
            tFrom = entry1.x;
        }
        if (ix2 < 0) {
            ix2 = -ix2 - 2;
            assert (ix2 >= 0);
            Pulse entry2 = this.entries.get(ix2);
            assert (tTo >= entry2.getX2());
            uac += (tTo - entry2.getX2()) * this.defaultValue;
            tTo = entry2.getX2();
        }
        for (int m = ix1; m < ix2; ++m) {
            Pulse entry1 = this.entries.get(m);
            uac += (entry1.getX2() - tFrom) * entry1.y;
            tFrom = entry1.getX2();
            Pulse next = this.entries.get(m + 1);
            uac += (next.x - tFrom) * this.defaultValue;
            tFrom = next.x;
        }
        Pulse entry2 = this.entries.get(ix2);
        return uac += (tTo - tFrom) * entry2.y;
    }

    @Override
    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        result.put("type", "impulse");
        JSONArray jentries = new JSONArray();
        for (Pulse entry : this.entries) {
            JSONObject jentry = new JSONObject();
            jentry.put("x", entry.x);
            jentry.put("duration", entry.duration);
            jentry.put("y", entry.y);
            jentries.add(jentry);
        }
        result.put("defaultVal", this.defaultValue);
        result.put("pulses", jentries);
        return result;
    }

    public static ImpulseFunction1d parse(JSONObject object) {
        double defVal = JsonUtil.getDouble(object, "defaultVal");
        JSONArray jentries = (JSONArray)object.get("pulses");
        ArrayList<Pulse> entries = new ArrayList<Pulse>(jentries.size());
        for (JSONObject jentry : theUtil.filter(jentries, JSONObject.class)) {
            double x = JsonUtil.getDouble(jentry, "x");
            double duration = JsonUtil.getDouble(jentry, "duration");
            double y = JsonUtil.getDouble(jentry, "y");
            entries.add(new Pulse(x, duration, y));
        }
        return new ImpulseFunction1d(defVal, entries);
    }

    public static class Pulse
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final double x;
        public final double duration;
        public final double y;

        public Pulse(double x, double duration, double y) {
            this.x = x;
            this.duration = duration;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Pulse f = (Pulse)obj;
            return this.x == f.x && this.duration == f.duration && this.y == f.y;
        }

        public int hashCode() {
            return 0xAF793 ^ Objects.hash(this.x, this.duration, this.y);
        }

        public double getX2() {
            return this.x + this.duration;
        }

        public double getArea() {
            return this.duration * this.y;
        }
    }
}

