/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.seekarea;

import inferno.data2.ANode;
import inferno.data2.CylinderShape;
import inferno.data2.IAgentBodyShape;
import inferno.data2.TriPoint;
import inferno.data2.seekarea.ASeekArea;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.geom.Inter;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.PathGen;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.RegroupPlanner;
import inferno.sim.steering.Shortest;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.Seek;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.util.Pair;

public class PointSeekArea
extends ASeekArea {
    private static final long serialVersionUID = 1L;
    public final ITpSource loc;
    public final double radius;
    public final Vector3d orient;

    public PointSeekArea(ITpSource loc, double radius, int options) {
        this(loc, radius, null, options);
    }

    public PointSeekArea(ITpSource loc, double radius, Vector3d orient, int options) {
        super(options);
        this.loc = loc;
        this.radius = radius;
        this.orient = orient;
    }

    @Override
    public boolean isEqual(ISeekArea obj) {
        if (obj == this) {
            return true;
        }
        if (!super.isEqual(obj)) {
            return false;
        }
        PointSeekArea psa = (PointSeekArea)obj;
        return psa.radius == this.radius && psa.loc.isEqual(this.loc) && Objects.equals(psa.orient, this.orient);
    }

    @Override
    public ISteeringBehavior getIdleSteer(KB kb, OccAgent agent, IdleParams idleParams) {
        return SteerUtil.newIdleSteer(kb, agent, idleParams, () -> this.getIdleSeek(kb, agent), () -> new Pair<TriPoint, Vector3d>(this.getDestinationLoc(kb, agent), this.orient));
    }

    protected ISeekCalc getIdleSeek(KB kb, OccAgent agent) {
        PathGen.PointGoal pg = new PathGen.PointGoal(this.getDestinationLoc(kb, agent));
        Shortest planner = new Shortest(Arrays.asList(pg), false);
        if (agent.getOcc().occupantGroup != null) {
            RegroupPlanner regroupPlanner = RegroupPlanner.createRegroupPlanner(agent, kb, planner);
            return new Seek(kb, agent, regroupPlanner, this.radius, this.orient);
        }
        return new Seek(kb, agent, planner, this.radius, this.orient);
    }

    @Override
    public Collection<ANode> getDestinationRooms() {
        return Collections.emptySet();
    }

    @Override
    public TriPoint getDestinationLoc(KB kb, OccAgent occ) {
        return this.loc.getTriPoint();
    }

    @Override
    public boolean contains(KB kb, TriPoint p) {
        return p.p.distanceSquared(this.loc.getTriPoint().p) <= this.radius * this.radius;
    }

    public boolean intersects(KB kb, IAgentBodyShape shape, Point3d shapeLoc) {
        CylinderShape thisShape = new CylinderShape(this.loc.getTriPoint().p, this.radius, this.radius, 0.01, GeomConstants.VEC3D_XPOS, -1);
        shape = shape.moveTo(new Point3d(shapeLoc.x, shapeLoc.y, this.loc.getTriPoint().p.z));
        return Inter.shapesOverlap(thisShape, shape);
    }
}

