/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.ai.IEventTime;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.WaitGoalInstance;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Objects;
import java.util.Random;

public class WaitUntilGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private static final long s_delaySeed = 11242279853998L;
    public final WaitMode mode;
    public final IEventTime waitSrc;

    public WaitUntilGoal(WaitMode mode, IEventTime waitSrc) {
        assert (!(waitSrc instanceof IEventTime.Auto));
        this.mode = mode;
        this.waitSrc = waitSrc;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitUntilGoal && ((WaitUntilGoal)obj).waitSrc.equals(this.waitSrc) && ((WaitUntilGoal)obj).mode.equals(this.mode);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hash(this.waitSrc, this.mode);
        return hash;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        double simTime = kb.getCurrentSimTime();
        double waitUntilTime = this.waitSrc.getEventTime(kb, WaitUntilGoal.genRandom(kb, agent, simTime));
        assert (!Double.isNaN(waitUntilTime));
        return new WaitGoalInstance(this, this.mode, waitUntilTime);
    }

    private static Random genRandom(KB kb, OccAgent oa, double currTime) {
        return new Random(oa.getOcc().rseed ^ 0xA398C18DFAEL ^ (long)currTime);
    }
}

