/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.RoomSeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.RoomTarget;
import java.io.Serializable;
import java.util.Collection;

public class RoomGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 3650842319151241671L;
    private final Collection<ANode> d_rooms;

    public RoomGoal(Collection<ANode> rooms) {
        assert (!rooms.contains(null)) : "Room goal list contains null.";
        this.d_rooms = rooms;
    }

    public int hashCode() {
        return -1883596 + GoalUtil.setHashCode(this.d_rooms);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RoomGoal)) {
            return false;
        }
        RoomGoal rg = (RoomGoal)obj;
        return GoalUtil.setsEqual(this.d_rooms, rg.d_rooms);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public Instance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public Collection<ANode> getRooms() {
        return this.d_rooms;
    }

    public IPathPlanner getPathPlanner(KB kb, OccAgent agent) {
        RoomTarget target = new RoomTarget(this.d_rooms);
        return new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), target);
    }

    public static class Instance
    implements Serializable,
    ISeekGoalInstance {
        private static final long serialVersionUID = 1L;
        private final RoomGoal d_goal;
        private transient IProgressNote d_progress;

        public Instance(RoomGoal goal) {
            this.d_goal = goal;
        }

        @Override
        public RoomGoal getGoal() {
            return this.d_goal;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.d_goal.d_rooms.contains(occ.getOcc().curNode);
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            return new RoomSeekArea(this.d_goal.d_rooms);
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            return new RoomSeekArea(this.d_goal.d_rooms);
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            this.d_progress = GoalUtil.getSeekProgress(kb, occ, this.d_progress);
            return this.d_progress;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            IPathPlanner planner = this.d_goal.getPathPlanner(kb, agent);
            return SteerUtil.newSeekSteer(kb, agent, planner);
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }
    }
}

