/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.TriPoint;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.seekarea.ASeekArea;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.inverse.PassiveModeSteering;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class PassiveModeGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    private OccAgent activeAgent;

    public PassiveModeGoal(OccAgent activeAgent, KB kb) {
        this.activeAgent = activeAgent;
    }

    @Override
    public PassiveModeGoalInstance begin(KB kb, OccAgent agent) {
        return new PassiveModeGoalInstance(this, new PassiveModeSteering(this.activeAgent), this.activeAgent, kb);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public static class PassiveModeGoalInstance
    implements ISeekGoalInstance {
        static final long serialVersionUID = 1L;
        private final PassiveModeGoal goal;
        private PassiveModeSteering passiveModeSteering;
        private final OccAgent activeAgent;
        private final AssistedEvacClientAgent clientAgent;

        public PassiveModeGoalInstance(PassiveModeGoal goal, PassiveModeSteering passiveModeSteering, OccAgent activeAgent, KB kb) {
            this.goal = goal;
            this.passiveModeSteering = passiveModeSteering;
            this.activeAgent = activeAgent;
            this.clientAgent = activeAgent.getAssistedEvacClientModule().get();
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            return PassiveModeSeekArea.INSTANCE;
        }

        @Override
        public ISeekGoal getGoal() {
            return this.goal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            return this.passiveModeSteering;
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            return true;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            occ.getOcc().isPassive = false;
            occ.getOcc().formationLeader = null;
            this.clientAgent.detachAgent(occ);
            return IGoalInstance.getCurrentAreaAsPoint(kb, occ);
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return false;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (!this.clientAgent.isAttached(occ)) {
                return true;
            }
            IGoalInstance ginst = occ.getCurrentGoalInstance(kb);
            if (ginst instanceof AssistOccupantsGoal.Instance) {
                return ((AssistOccupantsGoal.Instance)ginst).shouldDetach(this.activeAgent);
            }
            assert (false);
            return true;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public void preMove(KB kb, OccAgent agent, double dt) {
            this.passiveModeSteering.preMove(kb, agent, dt);
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return IProgressNote.PROGRESSING;
        }
    }

    private static class PassiveModeSeekArea
    extends ASeekArea {
        private static final long serialVersionUID = 1L;
        public static final PassiveModeSeekArea INSTANCE = new PassiveModeSeekArea();

        private PassiveModeSeekArea() {
            super(0);
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        @Override
        public ISteeringBehavior getIdleSteer(KB kb, OccAgent occ, IdleParams idleParams) {
            return IGoalInstance.getCurrentAreaAsPoint(kb, occ).getIdleSteer(kb, occ, idleParams);
        }

        @Override
        public Collection<ANode> getDestinationRooms() {
            return Collections.emptyList();
        }

        @Override
        public TriPoint getDestinationLoc(KB kb, OccAgent occ) {
            return null;
        }

        @Override
        public boolean contains(KB kb, TriPoint p) {
            return false;
        }
    }
}

