/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.OccTarget;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.data2.seekarea.OccTargetsSeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.OccTargetSteeringBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import thunderheadeng.util.Pair;

public class OccTargetGoal
implements ISeekGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public final Collection<OccTarget> targets;
    public final DistancePref distPref;
    public final PriorityPref priorityPref;
    private transient List<OccTarget> d_targets;

    public OccTargetGoal(Collection<OccTarget> targets, DistancePref choice, PriorityPref priority) {
        this.targets = targets;
        this.distPref = choice;
        this.priorityPref = priority;
    }

    public int hashCode() {
        return 0x742398 ^ Objects.hash(new Object[]{GoalUtil.setHashCode(this.targets), this.distPref, this.priorityPref});
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof OccTargetGoal && GoalUtil.setsEqual(this.targets, ((OccTargetGoal)obj).targets) && ((OccTargetGoal)obj).distPref == this.distPref && ((OccTargetGoal)obj).priorityPref == this.priorityPref;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(kb, this, this.getLocs(kb));
    }

    public synchronized List<OccTarget> getLocs(KB kb) {
        if (this.d_targets == null) {
            if (this.targets.isEmpty()) {
                this.d_targets = kb.getAllOccTargets();
            } else {
                this.d_targets = new ArrayList<OccTarget>(this.targets);
                Collections.sort(this.d_targets, (t1, t2) -> Double.compare(t1.priority, t2.priority));
            }
            assert (!this.d_targets.isEmpty());
        }
        return this.d_targets;
    }

    public static enum DistancePref {
        RANDOM,
        NEAREST;

    }

    public static enum PriorityPref {
        NONE,
        LOWER,
        HIGHER;

    }

    protected static class Instance
    implements ISeekGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        private final OccTargetGoal d_goal;
        private final List<OccTarget> d_targets;
        private OccTargetSteeringBehavior d_steering;
        private OccTarget d_reachedLoc;
        private transient IProgressNote d_prevProgress;

        public Instance(KB kb, OccTargetGoal goal, List<OccTarget> targets) {
            this.d_goal = goal;
            this.d_targets = targets;
        }

        @Override
        public ISeekGoal getGoal() {
            return this.d_goal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            assert (this.d_steering == null);
            this.d_steering = new OccTargetSteeringBehavior(kb, agent, this.d_goal.distPref, this.d_goal.priorityPref, this.d_targets, IdleParams.DEFAULT, IdleParams.DEFAULT);
            return this.d_steering;
        }

        private static boolean isInGroup(KB kb, OccAgent agent) {
            return agent.getGroup().filter(g -> g.getCurrentSize() > 1).isPresent();
        }

        @Override
        public boolean isReached(KB kb, OccAgent agent) {
            return this.d_reachedLoc != null || Instance.isInGroup(kb, agent);
        }

        protected OccTargetsSeekArea asSeekArea() {
            return new OccTargetsSeekArea(this.d_goal.distPref, this.d_goal.priorityPref, this.d_targets, 0);
        }

        @Override
        public ISeekArea end(KB kb, OccAgent agent) {
            if (this.d_reachedLoc == null) {
                return null;
            }
            return this.asSeekArea();
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            OccTarget target = this.d_steering.getCurrentTarget();
            if (target != null) {
                return this.asSeekArea();
            }
            return null;
        }

        @Override
        public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
            OccTarget target = this.d_steering.getCurrentTarget();
            if (target != null) {
                return null;
            }
            return IGoalInstance.unknownIdleStatus();
        }

        @Override
        public ISeekArea update(KB kb, OccAgent agent) {
            if (this.d_steering.getState() == OccTargetSteeringBehavior.State.IDLING) {
                this.d_reachedLoc = this.d_steering.getCurrentTarget();
            }
            return null;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            this.d_prevProgress = GoalUtil.getSeekProgress(kb, occ, this.d_prevProgress);
            return this.d_prevProgress;
        }

        @Override
        public boolean isAlwaysTerminal() {
            return false;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
            return new Pair<OccTargetsSeekArea, Object>(this.asSeekArea(), null);
        }
    }
}

