/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.Occupant;
import inferno.data2.Tag;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.data2.ai.ITargetPtSupplier;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ITpSource;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.json.simple.JSONObject;

public class LookAtGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ITargetPtSupplier targetSupplier;

    public LookAtGoal(ITargetPtSupplier targetSupplier) {
        this.targetSupplier = targetSupplier;
    }

    public JSONObject toJson() {
        JSONObject jobj = new JSONObject();
        jobj.put("target", this.targetSupplier.toJson());
        return jobj;
    }

    public static LookAtGoal fromJson(JSONObject jobj, Function<String, Tag> getTag) throws IOException {
        JSONObject jtarget = (JSONObject)jobj.get("target");
        ITargetPtSupplier.InputFileInfo ifInfo = ITargetPtSupplier.InputFileInfo.findType(jtarget);
        Object target = ifInfo.fromJson.get(jtarget, getTag);
        return new LookAtGoal((ITargetPtSupplier)target);
    }

    public int hashCode() {
        return -1471091226 + this.targetSupplier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LookAtGoal)) {
            return false;
        }
        LookAtGoal la = (LookAtGoal)obj;
        return Objects.equals(this.targetSupplier, la.targetSupplier);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new LookAtGoalInstance(this);
    }

    private static class LookAtGoalInstance
    implements IImmediateGoalInstance {
        private static final long serialVersionUID = 1L;
        public final LookAtGoal goal;
        private ITpSource d_target;

        public LookAtGoalInstance(LookAtGoal goal) {
            this.goal = goal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.goal;
        }

        @Override
        public void preMove(KB kb, OccAgent occ, double dt) {
            this.d_target = this.goal.targetSupplier.get(kb, occ);
        }

        @Override
        public ISeekArea update(KB kb, OccAgent occ) {
            Occupant occupant = occ.getOcc();
            if (this.d_target != null) {
                occupant.lookAtSupplier = this.goal.targetSupplier;
                occupant.lookAtSource = this.d_target;
            } else {
                occupant.lookAtSupplier = null;
                occupant.lookAtSource = null;
            }
            return null;
        }
    }
}

