/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.AttractorSim;
import inferno.data2.Tag;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.ITpSource;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.QuadPredicate;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;

public interface ITargetPtSupplier {
    public static final CurrentAttractorSupplier CURRENT_ATTRACTOR_SUPPLIER = CurrentAttractorSupplier.INSTANCE;

    public boolean getHasMoreTargets(KB var1, OccAgent var2);

    public ITpSource get(KB var1, OccAgent var2);

    public boolean isTarget(KB var1, OccAgent var2, ITpSource var3);

    public boolean getIsFutureTarget(KB var1, OccAgent var2, ITpSource var3);

    public InputFileInfo getInputFileInfo();

    default public JSONObject toJson() {
        return this.getInputFileInfo().toJson.get(this);
    }

    public static enum InputFileInfo {
        BASIC_TAGGED_OCC("BasicTaggedOccSupplier", BasicTaggedOccSupplier.class, a -> {
            JSONObject jobj = a.getInputFileInfo().newJsonObj();
            jobj.put("logic", a.logic.name());
            jobj.put("distPref", a.distPref.name());
            JSONArray jtags = new JSONArray();
            for (Tag tag : a.tags) {
                jtags.add(tag.name);
            }
            jobj.put("tags", jtags);
            return jobj;
        }, (j, getTag) -> {
            JSONArray jtags = (JSONArray)j.get("tags");
            LinkedIdentityHashSet<Tag> tags = jtags.isEmpty() ? Collections.emptySet() : new LinkedIdentityHashSet<Tag>(jtags.size());
            for (Object jtag : jtags) {
                tags.add((Tag)getTag.apply(jtag.toString()));
            }
            return new BasicTaggedOccSupplier(tags, JsonUtil.getEnum(j, "logic", BasicTaggedOccSupplier.Logic.class), JsonUtil.getEnum(j, "distPref", BasicTaggedOccSupplier.DistancePref.class));
        }),
        OCC("OccSupplier", OccSupplier.class, v -> {
            JSONObject jobj = v.getInputFileInfo().newJsonObj();
            jobj.put("occ", v.d_agentId);
            return jobj;
        }, (j, getTag) -> new OccSupplier(JsonUtil.getInt(j, "occ"))),
        CURRENT_ATTRACTOR("CurrentAttractor", CurrentAttractorSupplier.class, v -> v.getInputFileInfo().newJsonObj(), (j, getTag) -> CurrentAttractorSupplier.INSTANCE);

        public final String key;
        public final Class clazz;
        public final FromJson fromJson;
        public final ToJson toJson;

        private <T extends ITargetPtSupplier> InputFileInfo(String key, Class<T> clazz, ToJson<T> toJson, FromJson<T> fromJson) {
            this.key = key;
            this.clazz = clazz;
            this.toJson = toJson;
            this.fromJson = fromJson;
        }

        private JSONObject newJsonObj() {
            JSONObject jobj = new JSONObject();
            jobj.put("type", this.key);
            return jobj;
        }

        public static InputFileInfo findType(JSONObject jobj) throws IOException {
            String key = (String)jobj.get("type");
            Optional<InputFileInfo> info = Stream.of(InputFileInfo.values()).filter(i -> i.key.equalsIgnoreCase(key)).findFirst();
            if (info.isEmpty()) {
                throw new IOException(String.format("Unknown target type: %s", key));
            }
            return info.get();
        }
    }

    public static interface ToJson<T extends ITargetPtSupplier> {
        public JSONObject get(T var1);
    }

    public static class CurrentAttractorSupplier
    implements ITargetPtSupplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static final CurrentAttractorSupplier INSTANCE = new CurrentAttractorSupplier();

        private CurrentAttractorSupplier() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        private Optional<AttractorSim> getCurrAttr(KB kb, OccAgent occ) {
            return occ.getAiCore().getAttractorInUse(kb, occ);
        }

        @Override
        public ITpSource.AttractorSource get(KB kb, OccAgent occ) {
            Optional<AttractorSim> attractor = this.getCurrAttr(kb, occ);
            return attractor.map(attr -> attr.getLocation() == null ? null : new ITpSource.AttractorSource((AttractorSim)attr)).orElse(null);
        }

        @Override
        public boolean isTarget(KB kb, OccAgent source, ITpSource target) {
            if (target instanceof ITpSource.AttractorSource) {
                ITpSource.AttractorSource attrTarget = (ITpSource.AttractorSource)target;
                return kb.isAttractorActive(attrTarget.attractor) && attrTarget.attractor == this.getCurrAttr(kb, source).orElse(null);
            }
            return false;
        }

        @Override
        public boolean getIsFutureTarget(KB kb, OccAgent source, ITpSource target) {
            if (target instanceof ITpSource.AttractorSource) {
                ITpSource.AttractorSource attrTarget = (ITpSource.AttractorSource)target;
                return kb.isAttractorActive(attrTarget.attractor);
            }
            return false;
        }

        @Override
        public boolean getHasMoreTargets(KB kb, OccAgent occ) {
            return true;
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.CURRENT_ATTRACTOR;
        }
    }

    public static interface FromJson<T extends ITargetPtSupplier> {
        public T get(JSONObject var1, Function<String, Tag> var2);
    }

    public static class OccSupplier
    implements ITargetPtSupplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int d_agentId;

        public OccSupplier(int agentId) {
            this.d_agentId = agentId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            OccSupplier asrc = (OccSupplier)obj;
            return asrc.d_agentId == this.d_agentId;
        }

        public int hashCode() {
            return 0x2BAE325 ^ Integer.hashCode(this.d_agentId);
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.OCC;
        }

        @Override
        public ITpSource.AgentTpSource get(KB kb, OccAgent occ) {
            OccAgent target = kb.getAgent(this.d_agentId);
            return target != null && !target.isDone() ? new ITpSource.AgentTpSource(target) : null;
        }

        @Override
        public boolean getHasMoreTargets(KB kb, OccAgent occ) {
            OccAgent target = kb.getAgent(this.d_agentId);
            if (target != null) {
                return !target.isDone();
            }
            return !kb.checkOccSourcesFinished();
        }

        @Override
        public boolean isTarget(KB kb, OccAgent source, ITpSource target) {
            if (target instanceof ITpSource.AgentTpSource) {
                ITpSource.AgentTpSource occTarget = (ITpSource.AgentTpSource)target;
                return occTarget.getAgent().getId() == this.d_agentId && !occTarget.getAgent().isDone();
            }
            return false;
        }

        @Override
        public boolean getIsFutureTarget(KB kb, OccAgent source, ITpSource target) {
            return false;
        }
    }

    public static class BasicTaggedOccSupplier
    implements ITargetPtSupplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final Set<Tag> tags;
        public final Logic logic;
        public final DistancePref distPref;
        private static final IPickOccupant getRandomTarget = (kb, occ, availTargets) -> {
            OccAgent firstTested;
            Random r = kb.getTimeBasedRandom(occ.getOcc(), 17212235719503L);
            Predicate<PathChange> pathFilter = BasicTaggedOccSupplier.getPathFilter(kb, occ);
            Function<OccAgent, PathGen.IPathResult> getPath = dest -> {
                PathGen.IPathResult result = PathGen.getPath(kb.getMesh(), occ.getOcc().tri, null, null, occ.getPos(), new PathGen.PointGoal((OccAgent)dest), occ.getGeometryRadius(), Double.MAX_VALUE, pathFilter, null);
                return result;
            };
            PathGen.IPathResult result = getPath.apply(firstTested = (OccAgent)availTargets.get(r.nextInt(availTargets.size())));
            if (result.isSuccessful()) {
                return firstTested;
            }
            ArrayList<OccAgent> randomizedTargets = new ArrayList<OccAgent>(availTargets.size() - 1);
            for (OccAgent target : availTargets) {
                if (target == firstTested) continue;
                randomizedTargets.add(target);
            }
            Collections.shuffle(randomizedTargets, r);
            return randomizedTargets.stream().filter(dest -> ((PathGen.IPathResult)getPath.apply((OccAgent)dest)).isSuccessful()).findFirst().orElse(null);
        };
        private static final IPickOccupant getNearestTarget = (kb, occ, availTargets) -> {
            Predicate<PathChange> pathFilter = BasicTaggedOccSupplier.getPathFilter(kb, occ);
            List destPts = availTargets.stream().map(dest -> dest.getLoc()).collect(Collectors.toList());
            PathGen.IPathResult result = PathGen.getPath(kb.getMesh(), occ.getOcc().tri, null, null, occ.getPos(), new PathGen.MultiPointGoal(destPts), occ.getGeometryRadius(), Double.MAX_VALUE, pathFilter, null);
            if (!result.isSuccessful()) {
                return null;
            }
            List<TriPoint> resultPoints = result.getPoints();
            assert (!resultPoints.isEmpty());
            TriPoint destPt = resultPoints.get(resultPoints.size() - 1);
            return availTargets.stream().filter(target -> target.getLoc().tolEquals(destPt, 1.0E-6)).findFirst().orElse(null);
        };

        public BasicTaggedOccSupplier(Set<Tag> tags, Logic logic, DistancePref distPref) {
            this.tags = tags;
            this.logic = logic;
            this.distPref = distPref;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            BasicTaggedOccSupplier boc = (BasicTaggedOccSupplier)obj;
            return boc.logic == this.logic && boc.distPref == this.distPref && boc.tags.equals(this.tags);
        }

        public int hashCode() {
            return 0xEF8923A ^ Objects.hash(new Object[]{this.tags, this.distPref, this.logic});
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.BASIC_TAGGED_OCC;
        }

        private static Predicate<PathChange> getPathFilter(KB kb, OccAgent occ) {
            return occ.generatePathFilter(kb, TriFilters.rejectClosed(), Predicates.alwaysTrue(), OccAgent.PathFilterType.POINT_TO_POINT);
        }

        @Override
        public boolean getHasMoreTargets(KB kb, OccAgent occ) {
            return kb.getActiveAgents().stream().anyMatch(a -> a != occ) || !kb.checkOccSourcesFinished();
        }

        @Override
        public ITpSource.AgentTpSource get(KB kb, OccAgent occ) {
            Set<? extends OccAgent> occs = this.logic.getOccs.apply(kb, occ, this.tags);
            if (occs.isEmpty()) {
                return null;
            }
            ArrayList<OccAgent> occsList = new ArrayList<OccAgent>(occs);
            occsList.sort((o1, o2) -> Integer.compare(o1.getId(), o2.getId()));
            OccAgent target = this.distPref.pickOcc.pick(kb, occ, occsList);
            return target != null ? new ITpSource.AgentTpSource(target) : null;
        }

        @Override
        public boolean isTarget(KB kb, OccAgent source, ITpSource target) {
            if (target instanceof ITpSource.AgentTpSource) {
                ITpSource.AgentTpSource occTarget = (ITpSource.AgentTpSource)target;
                return !occTarget.getAgent().isDone() && this.logic.isTarget.test(kb, source, this.tags, occTarget.getAgent());
            }
            return false;
        }

        @Override
        public boolean getIsFutureTarget(KB kb, OccAgent source, ITpSource target) {
            if (target instanceof ITpSource.AgentTpSource) {
                ITpSource.AgentTpSource occTarget = (ITpSource.AgentTpSource)target;
                return !occTarget.getAgent().isDone();
            }
            return false;
        }

        public static enum Logic {
            ALL((kb, agent, tags) -> {
                if (tags.isEmpty()) {
                    return Collections.emptySet();
                }
                LinkedHashSet<Integer> agents = null;
                for (Tag tag : tags) {
                    IFilteredCollection<Integer> tagged = theUtil.filter(tag.getTaggedAgents(), id -> {
                        OccAgent target = kb.getAgent((int)id);
                        return target != null && !target.isDone();
                    });
                    if (agents == null) {
                        agents = new LinkedHashSet<Integer>(tagged);
                        continue;
                    }
                    agents.retainAll(tagged);
                    if (!agents.isEmpty()) continue;
                    return Collections.emptySet();
                }
                agents.remove(agent.getId());
                return theUtil.map(agents, id -> kb.getAgent((int)id));
            }, Stream::allMatch),
            ANY((kb, agent, tags) -> {
                if (tags.isEmpty()) {
                    return Collections.emptySet();
                }
                LinkedHashSet<Integer> agents = null;
                for (Tag tag : tags) {
                    IFilteredCollection<Integer> tagged = theUtil.filter(tag.getTaggedAgents(), id -> {
                        OccAgent target = kb.getAgent((int)id);
                        return target != null && !target.isDone();
                    });
                    if (agents == null) {
                        agents = new LinkedHashSet<Integer>(tagged);
                        continue;
                    }
                    agents.addAll(tagged);
                }
                agents.remove(agent.getId());
                return theUtil.map(agents, id -> kb.getAgent((int)id));
            }, Stream::anyMatch);

            public final TriFunction<KB, OccAgent, Collection<? extends Tag>, Set<? extends OccAgent>> getOccs;
            public final QuadPredicate<KB, OccAgent, Collection<? extends Tag>, OccAgent> isTarget;

            private Logic(TriFunction<KB, OccAgent, Collection<? extends Tag>, Set<? extends OccAgent>> getAgents, BiPredicate<Stream<? extends Tag>, Predicate<? super Tag>> test) {
                this.getOccs = getAgents;
                this.isTarget = (kb, source, tags, target) -> source != target && test.test(tags.stream(), t -> t.isTagged((OccAgent)target));
            }
        }

        public static enum DistancePref {
            RANDOM(getRandomTarget),
            NEAREST(getNearestTarget);

            public final IPickOccupant pickOcc;

            private DistancePref(IPickOccupant pickOcc) {
                this.pickOcc = pickOcc;
            }
        }

        private static interface IPickOccupant {
            public OccAgent pick(KB var1, OccAgent var2, List<OccAgent> var3);
        }
    }
}

