/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.sim.KB;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.jscience.physics.units.SI;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;

public interface IEventTime {
    public InputFileInfo getInputFileInfo();

    public double getEventTime(KB var1, Random var2);

    public void getDistributions(Consumer<? super IDistributedVal<?>> var1);

    public static interface FromJson<T extends IEventTime> {
        public T get(JSONObject var1, IntFunction<IDistributedVal<UnitDouble>> var2);
    }

    public static interface ToJson<T extends IEventTime> {
        public JSONObject get(T var1, ToIntFunction<IDistributedVal<UnitDouble>> var2);
    }

    public static enum InputFileInfo {
        AUTO("IWaitUntilSrc.AUTO", Auto.class, (a, d) -> a.getInputFileInfo().newJsonObj(), (j, d) -> Auto.INSTANCE),
        DELAY("IWaitUntilSrc.DELAY", Delay.class, (v, d) -> {
            JSONObject jobj = v.getInputFileInfo().newJsonObj();
            jobj.put("value", d.applyAsInt(v.value));
            return jobj;
        }, (j, d) -> new Delay((IDistributedVal)d.apply(JsonUtil.getInt(j, "value")))),
        SIMPLE("IWaitUntilSrc.SIMPLE", SimpleEventTime.class, (v, d) -> {
            JSONObject jobj = v.getInputFileInfo().newJsonObj();
            jobj.put("waitTime", d.applyAsInt(v.d_waitTime));
            return jobj;
        }, (j, d) -> new SimpleEventTime((IDistributedVal)d.apply(JsonUtil.getInt(j, "waitTime")))),
        CYCLE("IWaitUntilSrc.CYCLE", CycledEventTime.class, (v, d) -> {
            JSONObject jobj = v.getInputFileInfo().newJsonObj();
            jobj.put("initTime", d.applyAsInt(v.d_initialTime));
            jobj.put("intervalTime", d.applyAsInt(v.d_intervalTime));
            return jobj;
        }, (j, d) -> new CycledEventTime((IDistributedVal)d.apply(JsonUtil.getInt(j, "initTime")), (IDistributedVal)d.apply(JsonUtil.getInt(j, "intervalTime")))),
        LIST("IWaitUntilSrc.LIST", ListedEventTime.class, (v, d) -> {
            JSONObject jobj = v.getInputFileInfo().newJsonObj();
            JSONArray jtimes = new JSONArray();
            for (ICurve c : v.d_goTimes) {
                jtimes.add(d.applyAsInt(c));
            }
            jobj.put("times", jtimes);
            return jobj;
        }, (j, d) -> {
            JSONArray jtimes = (JSONArray)j.get("times");
            ArrayList<ICurve> times = new ArrayList<ICurve>();
            for (Object jtime : jtimes) {
                int curveIx = JsonUtil.getNum(jtime).intValue();
                times.add((ICurve)d.apply(curveIx));
            }
            return new ListedEventTime(times);
        });

        public final String key;
        public final Class clazz;
        public final FromJson fromJson;
        public final ToJson toJson;

        private <T extends IEventTime> InputFileInfo(String key, Class<T> clazz, ToJson<T> toJson, FromJson<T> fromJson) {
            this.key = key;
            this.clazz = clazz;
            this.toJson = toJson;
            this.fromJson = fromJson;
        }

        private JSONObject newJsonObj() {
            JSONObject jobj = new JSONObject();
            jobj.put("type", this.key);
            return jobj;
        }

        public static InputFileInfo findType(JSONObject jobj) throws IOException {
            String key = (String)jobj.get("type");
            Optional<InputFileInfo> info = Stream.of(InputFileInfo.values()).filter(i -> i.key.equalsIgnoreCase(key)).findFirst();
            if (info.isEmpty()) {
                throw new IOException(String.format("Unknown event time type: %s", key));
            }
            return info.get();
        }
    }

    public static class ListedEventTime
    implements IEventTime,
    Serializable {
        static final long serialVersionUID = 1L;
        public final List<ICurve> d_goTimes;
        private transient double[] d_maxTimes;

        public ListedEventTime(List<ICurve> goTimes) {
            this.d_goTimes = Collections.unmodifiableList(goTimes);
        }

        private synchronized double[] getMaxTimes() {
            if (this.d_maxTimes != null) {
                return this.d_maxTimes;
            }
            double[] times = new double[this.d_goTimes.size()];
            for (int m = 0; m < this.d_goTimes.size(); ++m) {
                times[m] = this.d_goTimes.get(m).getMax().get(SI.SECOND);
            }
            this.d_maxTimes = times;
            return this.d_maxTimes;
        }

        @Override
        public double getEventTime(KB kb, Random r) {
            double simTime = kb.getCurrentSimTime();
            double[] asTimes = this.getMaxTimes();
            int ix = Arrays.binarySearch(asTimes, simTime);
            if (ix < 0) {
                ix = -ix - 1;
            }
            if (ix >= this.d_goTimes.size()) {
                ix = this.d_goTimes.size() - 1;
            }
            ICurve currentCurve = this.d_goTimes.get(ix);
            return currentCurve.getValue(r).getValue(SI.SECOND);
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.LIST;
        }

        @Override
        public void getDistributions(Consumer<? super IDistributedVal<?>> dists) {
            this.d_goTimes.stream().forEach(dists);
        }
    }

    public static class CycledEventTime
    implements IEventTime,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IDistributedVal<UnitDouble> d_initialTime;
        public final IDistributedVal<UnitDouble> d_intervalTime;

        public CycledEventTime(IDistributedVal<UnitDouble> initTime, IDistributedVal<UnitDouble> intervalTime) {
            this.d_initialTime = initTime;
            this.d_intervalTime = intervalTime;
        }

        @Override
        public double getEventTime(KB kb, Random r) {
            double delay;
            double simTime = kb.getCurrentSimTime();
            if (simTime < (delay = this.d_initialTime.getValue(r).get(SI.SECOND))) {
                return delay;
            }
            double interval = this.d_intervalTime.getValue(r).get(SI.SECOND);
            double numIntervals = Math.ceil((simTime - delay) / interval);
            return delay + numIntervals * interval;
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.CYCLE;
        }

        @Override
        public void getDistributions(Consumer<? super IDistributedVal<?>> dists) {
            dists.accept(this.d_initialTime);
            dists.accept(this.d_intervalTime);
        }
    }

    public static class SimpleEventTime
    implements IEventTime,
    Serializable {
        static final long serialVersionUID = 1059401209432914162L;
        public final IDistributedVal<UnitDouble> d_waitTime;

        public SimpleEventTime(IDistributedVal<UnitDouble> waitTime) {
            this.d_waitTime = waitTime;
        }

        @Override
        public double getEventTime(KB kb, Random r) {
            return this.d_waitTime.getValue(r).get(SI.SECOND);
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.SIMPLE;
        }

        @Override
        public void getDistributions(Consumer<? super IDistributedVal<?>> dists) {
            dists.accept(this.d_waitTime);
        }
    }

    public static class Delay
    implements IEventTime,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final IDistributedVal<UnitDouble> value;

        public Delay(IDistributedVal<UnitDouble> value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Delay v = (Delay)obj;
            return v.value.equals(this.value);
        }

        public int hashCode() {
            return 0x7F89234 ^ this.value.hashCode();
        }

        public String toString() {
            return String.format("Delay: %s", this.value.toString());
        }

        @Override
        public double getEventTime(KB kb, Random r) {
            return kb.getCurrentSimTime() + this.value.getValue(r).get(SI.SECOND);
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.DELAY;
        }

        @Override
        public void getDistributions(Consumer<? super IDistributedVal<?>> dists) {
            dists.accept(this.value);
        }
    }

    public static class Auto
    implements IEventTime,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static final Auto INSTANCE = new Auto();

        private Auto() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        public String toString() {
            return "Automatic";
        }

        @Override
        public double getEventTime(KB kb, Random r) {
            return Double.NaN;
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.AUTO;
        }

        @Override
        public void getDistributions(Consumer<? super IDistributedVal<?>> dists) {
        }
    }
}

