/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.PredefTag;
import inferno.data2.WingedEdge;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.seekarea.EdgeSeekArea;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.locallyquickest.GlobalDoorTarget;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import thunderheadeng.util.theUtil;

public class ExitGoal
implements ISeekGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public final Collection<ANode> exits;
    private transient List<WingedEdge> d_edges;
    private transient List<ANode> d_exits;

    public ExitGoal(Collection<ANode> exits) {
        this.exits = exits;
    }

    public int hashCode() {
        return 7819907 + GoalUtil.setHashCode(this.exits);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ExitGoal && GoalUtil.setsEqual(this.exits, ((ExitGoal)obj).exits);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new ExitGoalInstance(this);
    }

    public synchronized List<WingedEdge> getEdges(KB kb) {
        if (this.d_edges == null) {
            List<ANode> exits = this.getExits(kb);
            ArrayList<WingedEdge> edges = new ArrayList<WingedEdge>();
            for (ANode n : exits) {
                edges.addAll(n.getDoorEdges());
            }
            edges.trimToSize();
            this.d_edges = Collections.unmodifiableList(edges);
        }
        return this.d_edges;
    }

    public synchronized List<ANode> getExits(KB kb) {
        if (this.d_exits == null) {
            this.d_exits = this.exits == null ? new ArrayList<ANode>(theUtil.filter(kb.getDoorNodes(), ANode::isExitDoor)) : (this.exits instanceof List ? (List)this.exits : new ArrayList<ANode>(this.exits));
        }
        return this.d_exits;
    }

    protected static class ExitGoalInstance
    implements ISeekGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        private final ExitGoal d_goal;
        private ANode d_crossedIntendedExitDoor;
        private transient IProgressNote d_prevProgress;

        public ExitGoalInstance(ExitGoal goal) {
            this.d_goal = goal;
            this.d_crossedIntendedExitDoor = null;
        }

        @Override
        public ISeekGoal getGoal() {
            return this.d_goal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            GlobalDoorTarget target = new GlobalDoorTarget(this.d_goal.getExits(kb));
            LocallyQuickest pathPlanner = new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), target);
            return SteerUtil.newSeekSteer(kb, agent, pathPlanner);
        }

        @Override
        public ISeekArea end(KB kb, OccAgent agent) {
            kb.tag(PredefTag.EXITED, agent);
            assert (this.d_crossedIntendedExitDoor != null);
            return new EdgeSeekArea(this.d_crossedIntendedExitDoor.getDoorEdges());
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            return new EdgeSeekArea(this.d_goal.getEdges(kb));
        }

        @Override
        public boolean isReached(KB kb, OccAgent agent) {
            return this.d_crossedIntendedExitDoor != null;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
            if (crossedDoor != null && crossedDoor.isExitDoor() && (this.d_goal.exits == null || this.d_goal.exits.contains(crossedDoor.getNode()))) {
                this.d_crossedIntendedExitDoor = crossedDoor.getNode();
            }
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            this.d_prevProgress = GoalUtil.getSeekProgress(kb, occ, this.d_prevProgress);
            return this.d_prevProgress;
        }

        @Override
        public boolean isAlwaysTerminal() {
            return true;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }
    }
}

