/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.AttractorSim;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;

public class DestroyAttractorGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final List<AttractorSim> attractors;

    public DestroyAttractorGoal(List<AttractorSim> attractors) {
        this.attractors = attractors;
    }

    public int hashCode() {
        return -62162562 + GoalUtil.setHashCode(this.attractors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DestroyAttractorGoal)) {
            return false;
        }
        DestroyAttractorGoal da = (DestroyAttractorGoal)obj;
        return GoalUtil.setsEqual(this.attractors, da.attractors);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new DestroyAttractorGoalInstance(this);
    }

    private class DestroyAttractorGoalInstance
    implements IImmediateGoalInstance {
        private static final long serialVersionUID = 1L;
        public final DestroyAttractorGoal goal;

        public DestroyAttractorGoalInstance(DestroyAttractorGoal goal) {
            this.goal = goal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.goal;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            Predicate<AttractorSim> pred = attractor -> {
                if (attractor.creator == occ) {
                    for (AttractorSim template : this.goal.attractors) {
                        if (attractor.getRootId() != template.getRootId()) continue;
                        return true;
                    }
                }
                return false;
            };
            for (AttractorSim attr : kb.getAllAttractors(pred)) {
                kb.queueDestroyAttractors(attr);
            }
            return null;
        }
    }
}

