/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.Tag;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TriConsumer;

public class ChangeTagGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Collection<Tag> tags;
    public final Op operator;

    public ChangeTagGoal(Op operator, Tag ... tags) {
        this(operator, Sets.fromArrayLHS(tags));
    }

    public ChangeTagGoal(Op operator, Collection<Tag> tags) {
        this.tags = tags;
        this.operator = operator;
    }

    public static ChangeTagGoal tag(Tag ... tags) {
        return new ChangeTagGoal(Op.TAG, tags);
    }

    public static ChangeTagGoal untag(Tag ... tags) {
        return new ChangeTagGoal(Op.UNTAG, tags);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ChangeTagGoal && ((ChangeTagGoal)obj).operator.equals((Object)this.operator) && GoalUtil.setsEqual(((ChangeTagGoal)obj).tags, this.tags);
    }

    public int hashCode() {
        return 0x12398FA ^ this.operator.hashCode() + GoalUtil.setHashCode(this.tags);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public void getTagRefs(Consumer<? super Tag> tags) {
        if (this.operator == Op.TAG) {
            this.tags.forEach(tags);
        }
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static enum Op {
        TAG((kb, tag, agent) -> tag.tag(kb.getCurrentSimTime(), (OccAgent)agent)),
        UNTAG((kb, tag, agent) -> tag.untag(kb.getCurrentSimTime(), (OccAgent)agent));

        public final TriConsumer<KB, Tag, OccAgent> func;

        private Op(TriConsumer<KB, Tag, OccAgent> func) {
            this.func = func;
        }
    }

    public static class Instance
    implements IImmediateGoalInstance {
        static final long serialVersionUID = 1L;
        private ChangeTagGoal changeTagGoal;

        public Instance(ChangeTagGoal changeTagGoal) {
            this.changeTagGoal = changeTagGoal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.changeTagGoal;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            for (Tag tag : this.changeTagGoal.tags) {
                this.changeTagGoal.operator.func.accept(kb, tag, occ);
            }
            return null;
        }
    }
}

