/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;

public class WingedEdgeUse
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final byte POS = 1;
    public static final byte NEG = -1;
    public final WingedEdge wedge;
    public final byte dir;

    public WingedEdgeUse(WingedEdge flap, byte dir) {
        this.wedge = flap;
        this.dir = dir;
    }

    public Vertex n1() {
        return this.dir == 1 ? this.wedge.base.n1 : this.wedge.base.n2;
    }

    public Vertex n2() {
        return this.dir == 1 ? this.wedge.base.n2 : this.wedge.base.n1;
    }

    public Vector3d edgeDir() {
        return this.dir == 1 ? Util3D.vector(this.wedge.base.n1.p, this.wedge.base.n2.p) : Util3D.vector(this.wedge.base.n2.p, this.wedge.base.n1.p);
    }

    public double whichSide(Point3d p, double tol) {
        double side = this.wedge.whichSide(p, tol);
        return this.dir == 1 ? side : -side;
    }

    public double whichSide(Vector3d v, double tol) {
        double side = this.wedge.whichSide(v, tol);
        return this.dir == 1 ? side : -side;
    }

    public Point3d get(double t) {
        switch (this.dir) {
            case 1: {
                return this.wedge.get(t);
            }
        }
        return Util3D.linesegPoint(this.wedge.base.n2.p, this.wedge.base.n1.p, t);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WingedEdgeUse)) {
            return false;
        }
        WingedEdgeUse eu = (WingedEdgeUse)obj;
        return this.wedge == eu.wedge && eu.dir == this.dir;
    }

    public int hashCode() {
        return this.wedge.hashCode() + this.dir;
    }
}

