/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.ASplitComponent;
import inferno.data2.DoorDir;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import java.util.List;
import javax.vecmath.Point3d;
import thunderheadeng.util.Pair;

public class SplitDoor
extends ASplitComponent<ANode> {
    static final long serialVersionUID = 1L;

    public SplitDoor(ANode door, double[] splits) {
        super(door, splits);
    }

    @Override
    public Pair<Integer, Point3d> getDetailed(double t) {
        return ((ANode)this.comp).getOptionalDoorGeom().map(dg -> dg.get(t)).orElse(new Pair<Integer, Point3d>(0, new Point3d()));
    }

    @Override
    public Pair<Integer, Double> getDetailed(Point3d p, int edgeHint) {
        return ((ANode)this.comp).getOptionalDoorGeom().map(dg -> dg.get(p, edgeHint)).orElse(new Pair<Integer, Double>(0, 0.0));
    }

    @Override
    public double findClosest(double tloc) {
        return this.findClosest(tloc, DEF_RESOLVER);
    }

    @Override
    public TriPoint findClosest(TriPoint tp) {
        if (!this.isTravellable()) {
            return null;
        }
        List<WingedEdge> edges = ((ANode)this.comp).getDoorEdges();
        for (int m = 0; m < edges.size(); ++m) {
            WingedEdge edge = edges.get(m);
            if (edge.t1 != tp.tri && edge.t2 != tp.tri) continue;
            Pair<Integer, Point3d> closest = this.findClosestDetailed(tp.p, m);
            if (closest == null) {
                return null;
            }
            DoorDir dir = DoorDir.get((ANode)this.comp, tp.tri);
            return new TriPoint(edge.getDestTri(dir), (Point3d)closest.v2);
        }
        return null;
    }
}

